/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import mtr.data.MessagePackHelper;
import mtr.data.NameColorDataBase;
import mtr.data.RailwayData;
import mtr.data.TransportMode;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Tuple;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;

public abstract class AreaBase
extends NameColorDataBase {
    public Tuple<Integer, Integer> corner1;
    public Tuple<Integer, Integer> corner2;
    private static final String KEY_X_MIN = "x_min";
    private static final String KEY_Z_MIN = "z_min";
    private static final String KEY_X_MAX = "x_max";
    private static final String KEY_Z_MAX = "z_max";
    private static final String KEY_CORNERS = "corners";

    public AreaBase() {
    }

    public AreaBase(long id) {
        super(id);
    }

    public AreaBase(TransportMode transportMode) {
        super(transportMode);
    }

    public AreaBase(long id, TransportMode transportMode) {
        super(id, transportMode);
    }

    public AreaBase(Map<String, Value> map) {
        super(map);
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.setCorners(messagePackHelper.getInt(KEY_X_MIN), messagePackHelper.getInt(KEY_Z_MIN), messagePackHelper.getInt(KEY_X_MAX), messagePackHelper.getInt(KEY_Z_MAX));
    }

    @Deprecated
    public AreaBase(CompoundTag compoundTag) {
        super(compoundTag);
        this.setCorners(compoundTag.m_128451_(KEY_X_MIN), compoundTag.m_128451_(KEY_Z_MIN), compoundTag.m_128451_(KEY_X_MAX), compoundTag.m_128451_(KEY_Z_MAX));
    }

    public AreaBase(FriendlyByteBuf packet) {
        super(packet);
        this.setCorners(packet.readInt(), packet.readInt(), packet.readInt(), packet.readInt());
    }

    @Override
    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        super.toMessagePack(messagePacker);
        messagePacker.packString(KEY_X_MIN).packInt(this.corner1 == null ? 0 : (Integer)this.corner1.m_14418_());
        messagePacker.packString(KEY_Z_MIN).packInt(this.corner1 == null ? 0 : (Integer)this.corner1.m_14419_());
        messagePacker.packString(KEY_X_MAX).packInt(this.corner2 == null ? 0 : (Integer)this.corner2.m_14418_());
        messagePacker.packString(KEY_Z_MAX).packInt(this.corner2 == null ? 0 : (Integer)this.corner2.m_14419_());
    }

    @Override
    public int messagePackLength() {
        return super.messagePackLength() + 4;
    }

    @Override
    public void writePacket(FriendlyByteBuf packet) {
        super.writePacket(packet);
        packet.writeInt(this.corner1 == null ? 0 : (Integer)this.corner1.m_14418_());
        packet.writeInt(this.corner1 == null ? 0 : (Integer)this.corner1.m_14419_());
        packet.writeInt(this.corner2 == null ? 0 : (Integer)this.corner2.m_14418_());
        packet.writeInt(this.corner2 == null ? 0 : (Integer)this.corner2.m_14419_());
    }

    @Override
    public void update(String key, FriendlyByteBuf packet) {
        if (key.equals(KEY_CORNERS)) {
            this.setCorners(packet.readInt(), packet.readInt(), packet.readInt(), packet.readInt());
        } else {
            super.update(key, packet);
        }
    }

    public void setCorners(Consumer<FriendlyByteBuf> sendPacket) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.m_130070_(this.transportMode.toString());
        packet.m_130070_(KEY_CORNERS);
        packet.writeInt(this.corner1 == null ? 0 : (Integer)this.corner1.m_14418_());
        packet.writeInt(this.corner1 == null ? 0 : (Integer)this.corner1.m_14419_());
        packet.writeInt(this.corner2 == null ? 0 : (Integer)this.corner2.m_14418_());
        packet.writeInt(this.corner2 == null ? 0 : (Integer)this.corner2.m_14419_());
        sendPacket.accept(packet);
    }

    public boolean inArea(int x, int z) {
        return AreaBase.nonNullCorners(this) && RailwayData.isBetween(x, ((Integer)this.corner1.m_14418_()).intValue(), ((Integer)this.corner2.m_14418_()).intValue()) && RailwayData.isBetween(z, ((Integer)this.corner1.m_14419_()).intValue(), ((Integer)this.corner2.m_14419_()).intValue());
    }

    public boolean intersecting(AreaBase areaBase) {
        return AreaBase.nonNullCorners(this) && AreaBase.nonNullCorners(areaBase) && (this.inThis(areaBase) || areaBase.inThis(this));
    }

    public BlockPos getCenter() {
        return AreaBase.nonNullCorners(this) ? RailwayData.newBlockPos(((Integer)this.corner1.m_14418_() + (Integer)this.corner2.m_14418_()) / 2, 0, ((Integer)this.corner1.m_14419_() + (Integer)this.corner2.m_14419_()) / 2) : null;
    }

    private void setCorners(int corner1a, int corner1b, int corner2a, int corner2b) {
        this.corner1 = corner1a == 0 && corner1b == 0 ? null : new Tuple((Object)corner1a, (Object)corner1b);
        this.corner2 = corner2a == 0 && corner2b == 0 ? null : new Tuple((Object)corner2a, (Object)corner2b);
    }

    private boolean inThis(AreaBase areaBase) {
        return this.inArea((Integer)areaBase.corner1.m_14418_(), (Integer)areaBase.corner1.m_14419_()) || this.inArea((Integer)areaBase.corner1.m_14418_(), (Integer)areaBase.corner2.m_14419_()) || this.inArea((Integer)areaBase.corner2.m_14418_(), (Integer)areaBase.corner1.m_14419_()) || this.inArea((Integer)areaBase.corner2.m_14418_(), (Integer)areaBase.corner2.m_14419_());
    }

    public static boolean nonNullCorners(AreaBase station) {
        return station != null && station.corner1 != null && station.corner2 != null;
    }
}

