/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.util.UUID;
import java.util.function.Consumer;
import mtr.KeyMappings;
import mtr.data.Lift;
import mtr.data.VehicleRidingClient;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.render.RenderTrains;
import mtr.screen.LiftSelectionScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class LiftClient
extends Lift {
    private final VehicleRidingClient vehicleRidingClient;

    public LiftClient(FriendlyByteBuf packet) {
        super(packet);
        this.vehicleRidingClient = new VehicleRidingClient(this.ridingEntities, PACKET_UPDATE_LIFT_PASSENGER_POSITION);
    }

    public void tickClient(Level world, RenderLift renderLift, float ticksElapsed) {
        this.tick(world, ticksElapsed);
        this.vehicleRidingClient.begin();
        if (ticksElapsed > 0.0f) {
            this.vehicleRidingClient.movePlayer(uuid -> {
                this.vehicleRidingClient.setOffsets((UUID)uuid, this.currentPositionX + (double)((float)this.liftOffsetX / 2.0f), this.currentPositionY + (double)this.liftOffsetY, this.currentPositionZ + (double)((float)this.liftOffsetZ / 2.0f), this.getYaw(), 0.0f, this.liftWidth - 1, this.liftDepth - 1, this.frontCanOpen, this.backCanOpen, false, false, 0.0f, 0.0f, this.speed > 0.0, this.doorValue == 0.0f, () -> {});
                this.vehicleRidingClient.moveSelf(this.id, (UUID)uuid, this.liftWidth - 1, this.liftDepth - 1, this.getYaw(), 0, 1, this.frontCanOpen, this.backCanOpen, true, ticksElapsed);
            });
        }
        this.vehicleRidingClient.end();
        Vec3 offset = this.vehicleRidingClient.renderPlayerAndGetOffset();
        double newX = this.currentPositionX + (double)((float)this.liftOffsetX / 2.0f) - offset.f_82479_;
        double newY = this.currentPositionY + (double)this.liftOffsetY - offset.f_82480_;
        double newZ = this.currentPositionZ + (double)((float)this.liftOffsetZ / 2.0f) - offset.f_82481_;
        renderLift.renderLift(newX, newY, newZ, this.frontCanOpen ? Math.min(this.doorValue / 24.0f, 1.0f) : 0.0f, this.backCanOpen ? Math.min(this.doorValue / 24.0f, 1.0f) : 0.0f);
        Minecraft minecraftClient = Minecraft.m_91087_();
        LocalPlayer player = minecraftClient.f_91074_;
        if (player != null && this.ridingEntities.contains(player.m_20148_())) {
            if (KeyMappings.LIFT_MENU.m_90857_() && !(minecraftClient.f_91080_ instanceof LiftSelectionScreen)) {
                UtilitiesClient.setScreen(minecraftClient, new LiftSelectionScreen(this));
            }
            if (RenderTrains.showShiftProgressBar()) {
                player.m_5661_((Component)Text.translatable("gui.mtr.press_to_select_floor", KeyMappings.LIFT_MENU.m_90863_()), true);
            }
        }
    }

    public void copyFromLift(LiftClient lift) {
        this.liftHeight = lift.liftHeight;
        this.liftWidth = lift.liftWidth;
        this.liftDepth = lift.liftDepth;
        this.liftOffsetX = lift.liftOffsetX;
        this.liftOffsetY = lift.liftOffsetY;
        this.liftOffsetZ = lift.liftOffsetZ;
        this.isDoubleSided = lift.isDoubleSided;
        this.liftStyle = lift.liftStyle;
        this.facing = lift.facing;
        this.currentPositionX = lift.currentPositionX;
        this.currentPositionY = lift.currentPositionY;
        this.currentPositionZ = lift.currentPositionZ;
        this.liftDirection = lift.liftDirection;
        this.speed = lift.speed;
        this.doorOpen = lift.doorOpen;
        this.doorValue = lift.doorValue;
        this.frontCanOpen = lift.frontCanOpen;
        this.backCanOpen = lift.backCanOpen;
        this.ridingEntities.clear();
        this.ridingEntities.addAll(lift.ridingEntities);
        this.floors.clear();
        this.floors.addAll(lift.floors);
        this.liftInstructions.copyFrom(lift.liftInstructions);
    }

    public void setExtraData(Consumer<FriendlyByteBuf> sendPacket) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeLong(this.id);
        packet.m_130070_(this.transportMode.toString());
        packet.m_130070_("lift_update");
        packet.writeInt(this.liftHeight);
        packet.writeInt(this.liftWidth);
        packet.writeInt(this.liftDepth);
        packet.writeInt(this.liftOffsetX);
        packet.writeInt(this.liftOffsetY);
        packet.writeInt(this.liftOffsetZ);
        packet.writeBoolean(this.isDoubleSided);
        packet.m_130070_(this.liftStyle.toString());
        packet.writeInt(Math.round(this.facing.m_122435_()));
        sendPacket.accept(packet);
    }

    public void startRidingClient(UUID uuid, float percentageX, float percentageZ) {
        this.vehicleRidingClient.startRiding(uuid, percentageX, percentageZ);
    }

    public void updateRiderPercentages(UUID uuid, float percentageX, float percentageZ) {
        this.vehicleRidingClient.updateRiderPercentages(uuid, percentageX, percentageZ);
    }

    public void iterateFloors(Consumer<BlockPos> consumer) {
        this.floors.forEach(consumer);
    }

    public Vec3 getViewOffset() {
        return this.vehicleRidingClient.getViewOffset();
    }

    @FunctionalInterface
    public static interface RenderLift {
        public void renderLift(double var1, double var3, double var5, float var7, float var8);
    }
}

