/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mtr.data.Lift;
import mtr.data.VehicleRidingServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.msgpack.value.Value;

public class LiftServer
extends Lift {
    private static final int LIFT_UPDATE_DISTANCE = 64;

    public LiftServer(BlockPos pos, Direction facing) {
        super(pos, facing);
    }

    public LiftServer(Map<String, Value> map) {
        super(map);
    }

    public void tickServer(Level world, Map<Player, Set<LiftServer>> liftsInPlayerRange, Set<LiftServer> liftsToSync) {
        this.floors.forEach(floor -> world.m_6907_().forEach(player -> {
            if (this.ridingEntities.contains(player.m_20148_()) || player.m_20183_().m_123333_((Vec3i)floor) < 64) {
                if (!liftsInPlayerRange.containsKey(player)) {
                    liftsInPlayerRange.put((Player)player, new HashSet());
                }
                ((Set)liftsInPlayerRange.get(player)).add(this);
            }
        }));
        this.tick(world, 1.0f);
        int ridingEntitiesCount = this.ridingEntities.size();
        VehicleRidingServer.mountRider(world, this.ridingEntities, this.id, 1L, this.currentPositionX + (double)((float)this.liftOffsetX / 2.0f), this.currentPositionY + (double)this.liftOffsetY, this.currentPositionZ + (double)((float)this.liftOffsetZ / 2.0f), this.liftWidth - 1, this.liftDepth - 1, this.getYaw(), 0.0f, this.doorValue > 0.0f, true, 0, PACKET_UPDATE_LIFT_PASSENGERS, player -> true, player -> {});
        if (this.liftInstructions.isDirty() || ridingEntitiesCount != this.ridingEntities.size()) {
            liftsToSync.add(this);
        }
    }
}

