/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mtr.MTRClient;
import mtr.client.ClientData;
import mtr.client.Config;
import mtr.client.ScrollingText;
import mtr.client.TrainClientRegistry;
import mtr.client.TrainProperties;
import mtr.data.Depot;
import mtr.data.IGui;
import mtr.data.RailType;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.Siding;
import mtr.data.Station;
import mtr.data.Train;
import mtr.data.VehicleRidingClient;
import mtr.path.PathData;
import mtr.render.RenderDrivingOverlay;
import mtr.render.TrainRendererBase;
import mtr.sound.TrainSoundBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class TrainClient
extends Train
implements IGui {
    public boolean isRemoved = false;
    private boolean justMounted;
    private float oldSpeed;
    private double oldRailProgress;
    private float oldDoorValue;
    private boolean doorOpening;
    private boolean isSitting;
    private boolean previousShifting;
    private int currentStationIndex;
    private Route thisRoute;
    private Route nextRoute;
    private Station thisStation;
    private Station nextStation;
    private Station lastStation;
    private SpeedCallback speedCallback;
    private AnnouncementCallback announcementCallback;
    private AnnouncementCallback lightRailAnnouncementCallback;
    private Depot depot;
    private List<Long> routeIds = new ArrayList<Long>();
    public final TrainRendererBase trainRenderer;
    public final TrainSoundBase trainSound;
    public final VehicleRidingClient vehicleRidingClient = new VehicleRidingClient(this.ridingEntities, PACKET_UPDATE_TRAIN_PASSENGER_POSITION);
    public final List<ScrollingText> scrollingTexts = new ArrayList<ScrollingText>();
    private final Set<Runnable> trainTranslucentRenders = new HashSet<Runnable>();
    private static final float CONNECTION_HEIGHT = 2.25f;
    private static final float CONNECTION_Z_OFFSET = 0.5f;
    private static final float CONNECTION_X_OFFSET = 0.25f;

    public TrainClient(FriendlyByteBuf packet) {
        super(packet);
        TrainProperties trainProperties = TrainClientRegistry.getTrainProperties(this.trainId);
        this.trainRenderer = trainProperties.renderer.createTrainInstance(this);
        this.trainSound = trainProperties.sound.createTrainInstance(this);
    }

    @Override
    protected void simulateCar(Level world, int ridingCar, float ticksElapsed, double carX, double carY, double carZ, float carYaw, float carPitch, double prevCarX, double prevCarY, double prevCarZ, float prevCarYaw, float prevCarPitch, boolean doorLeftOpen, boolean doorRightOpen, double realSpacing) {
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        if (clientPlayer == null) {
            return;
        }
        BlockPos soundPos = RailwayData.newBlockPos(carX, carY, carZ);
        this.trainSound.playAllCars(world, soundPos, ridingCar);
        if (doorLeftOpen || doorRightOpen) {
            this.trainSound.playAllCarsDoorOpening(world, soundPos, ridingCar);
        }
        Vec3 offset = this.vehicleRidingClient.renderPlayerAndGetOffset();
        double newX = carX - offset.f_82479_;
        double newY = carY - offset.f_82480_;
        double newZ = carZ - offset.f_82481_;
        this.doorOpening = this.doorValue > this.oldDoorValue;
        this.trainRenderer.renderCar(ridingCar, newX, newY, newZ, carYaw, carPitch, doorLeftOpen, doorRightOpen);
        this.trainTranslucentRenders.add(() -> this.trainRenderer.renderCar(ridingCar, newX, newY, newZ, carYaw, carPitch, doorLeftOpen, doorRightOpen));
        if (ridingCar > 0) {
            double newPrevCarX = prevCarX - offset.f_82479_;
            double newPrevCarY = prevCarY - offset.f_82480_;
            double newPrevCarZ = prevCarZ - offset.f_82481_;
            Vec3 prevPos0 = new Vec3(0.0, 0.0, (double)this.spacing / 2.0 - 1.0).m_82496_(prevCarPitch).m_82524_(prevCarYaw).m_82520_(newPrevCarX, newPrevCarY, newPrevCarZ);
            Vec3 thisPos0 = new Vec3(0.0, 0.0, -((double)this.spacing / 2.0 - 1.0)).m_82496_(carPitch).m_82524_(carYaw).m_82520_(newX, newY, newZ);
            Vec3 connectPos = prevPos0.m_82549_(thisPos0).m_82490_(0.5);
            float connectYaw = (float)Mth.m_14136_((double)(thisPos0.f_82479_ - prevPos0.f_82479_), (double)(thisPos0.f_82481_ - prevPos0.f_82481_));
            float connectPitch = realSpacing == 0.0 ? 0.0f : (float)this.asin((thisPos0.f_82480_ - prevPos0.f_82480_) / realSpacing);
            for (int i = 0; i < 2; ++i) {
                double xStart = (double)this.width / 2.0 + (i == 0 ? -1.0 : 0.5) * 0.25;
                double zStart = (double)this.spacing / 2.0 - (double)((float)(i == 0 ? 1 : 2) * 0.5f);
                Vec3 prevPos1 = new Vec3(xStart, (double)0.003125f, zStart).m_82496_(prevCarPitch).m_82524_(prevCarYaw).m_82520_(newPrevCarX, newPrevCarY, newPrevCarZ);
                Vec3 prevPos2 = new Vec3(xStart, 2.253124952316284, zStart).m_82496_(prevCarPitch).m_82524_(prevCarYaw).m_82520_(newPrevCarX, newPrevCarY, newPrevCarZ);
                Vec3 prevPos3 = new Vec3(-xStart, 2.253124952316284, zStart).m_82496_(prevCarPitch).m_82524_(prevCarYaw).m_82520_(newPrevCarX, newPrevCarY, newPrevCarZ);
                Vec3 prevPos4 = new Vec3(-xStart, (double)0.003125f, zStart).m_82496_(prevCarPitch).m_82524_(prevCarYaw).m_82520_(newPrevCarX, newPrevCarY, newPrevCarZ);
                Vec3 thisPos1 = new Vec3(-xStart, (double)0.003125f, -zStart).m_82496_(carPitch).m_82524_(carYaw).m_82520_(newX, newY, newZ);
                Vec3 thisPos2 = new Vec3(-xStart, 2.253124952316284, -zStart).m_82496_(carPitch).m_82524_(carYaw).m_82520_(newX, newY, newZ);
                Vec3 thisPos3 = new Vec3(xStart, 2.253124952316284, -zStart).m_82496_(carPitch).m_82524_(carYaw).m_82520_(newX, newY, newZ);
                Vec3 thisPos4 = new Vec3(xStart, (double)0.003125f, -zStart).m_82496_(carPitch).m_82524_(carYaw).m_82520_(newX, newY, newZ);
                if (i == 0) {
                    this.trainRenderer.renderConnection(prevPos1, prevPos2, prevPos3, prevPos4, thisPos1, thisPos2, thisPos3, thisPos4, connectPos.f_82479_, connectPos.f_82480_, connectPos.f_82481_, connectYaw, connectPitch);
                    continue;
                }
                this.trainRenderer.renderBarrier(prevPos1, prevPos2, prevPos3, prevPos4, thisPos1, thisPos2, thisPos3, thisPos4, connectPos.f_82479_, connectPos.f_82480_, connectPos.f_82481_, connectYaw, connectPitch);
            }
        }
    }

    @Override
    protected boolean handlePositions(Level world, Vec3[] positions, float ticksElapsed) {
        Minecraft client = Minecraft.m_91087_();
        LocalPlayer clientPlayer = client.f_91074_;
        if (clientPlayer == null) {
            return false;
        }
        this.vehicleRidingClient.begin();
        if (ticksElapsed > 0.0f) {
            if (this.isPlayerRiding((Player)clientPlayer)) {
                double targetProgress;
                int headIndex = this.getIndex(0, this.spacing, false);
                int stopIndex = ((PathData)this.path.get((int)headIndex)).stopIndex - 1;
                if (this.speedCallback != null) {
                    this.speedCallback.speedCallback(this.speed * 20.0f, stopIndex, this.routeIds);
                }
                if (this.announcementCallback != null && this.oldRailProgress < (targetProgress = (Double)this.distances.get(this.getPreviousStoppingIndex(headIndex)) + (double)((this.trainCars + 1) * this.spacing)) && this.railProgress >= targetProgress) {
                    this.announcementCallback.announcementCallback(stopIndex, this.routeIds);
                }
                if (this.lightRailAnnouncementCallback != null && (this.justOpening() || this.justMounted)) {
                    this.lightRailAnnouncementCallback.announcementCallback(stopIndex, this.routeIds);
                }
            }
            TrainProperties trainProperties = TrainClientRegistry.getTrainProperties(this.trainId);
            this.vehicleRidingClient.movePlayer(uuid -> {
                Train.CalculateCarCallback calculateCarCallback = (x, y, z, yaw, pitch, realSpacingRender, doorLeftOpenRender, doorRightOpenRender) -> this.vehicleRidingClient.setOffsets((UUID)uuid, x, y, z, yaw, pitch, this.transportMode.maxLength == 1 ? (double)this.spacing : realSpacingRender, this.width, doorLeftOpenRender, doorRightOpenRender, this.transportMode.hasPitchAscending, this.transportMode.hasPitchDescending, trainProperties.riderOffset, trainProperties.riderOffsetDismounting, this.speed > 0.0f, this.doorValue == 0.0f, () -> {
                    boolean isShifting = clientPlayer.m_6144_();
                    if (Config.shiftToToggleSitting() && !MTRClient.isVivecraft()) {
                        if (isShifting && !this.previousShifting) {
                            this.isSitting = !this.isSitting;
                        }
                        clientPlayer.m_20124_(this.isSitting && !client.f_91063_.m_109153_().m_90594_() ? Pose.CROUCHING : Pose.STANDING);
                    }
                    this.previousShifting = isShifting;
                });
                int currentRidingCar = Mth.m_14045_((int)((int)Math.floor(this.vehicleRidingClient.getPercentageZ((UUID)uuid))), (int)0, (int)(positions.length - 2));
                this.calculateCar(world, positions, currentRidingCar, 0, (x, y, z, yaw, pitch, realSpacingRender, doorLeftOpenRender, doorRightOpenRender) -> {
                    this.vehicleRidingClient.moveSelf(this.id, (UUID)uuid, realSpacingRender, this.width, yaw, currentRidingCar, this.trainCars, doorLeftOpenRender, doorRightOpenRender, !trainProperties.hasGangwayConnection, ticksElapsed);
                    int newRidingCar = Mth.m_14045_((int)((int)Math.floor(this.vehicleRidingClient.getPercentageZ((UUID)uuid))), (int)0, (int)(positions.length - 2));
                    if (currentRidingCar == newRidingCar) {
                        calculateCarCallback.calculateCarCallback(x, y, z, yaw, pitch, realSpacingRender, doorLeftOpenRender, doorRightOpenRender);
                    } else {
                        this.calculateCar(world, positions, newRidingCar, 0, calculateCarCallback);
                    }
                });
            });
        }
        this.vehicleRidingClient.end();
        this.justMounted = false;
        Entity camera = client.f_91075_;
        Vec3 cameraPos = camera == null ? Vec3.f_82478_ : camera.m_20182_();
        double nearestDistance = Double.POSITIVE_INFINITY;
        int nearestCar = 0;
        for (int i = 0; i < this.trainCars; ++i) {
            double checkDistance = cameraPos.m_82557_(positions[i]);
            if (!(checkDistance < nearestDistance)) continue;
            nearestCar = i;
            nearestDistance = checkDistance;
        }
        BlockPos soundPos = RailwayData.newBlockPos(positions[nearestCar].f_82479_, positions[nearestCar].f_82480_, positions[nearestCar].f_82481_);
        this.trainSound.playNearestCar(world, soundPos, nearestCar);
        return true;
    }

    @Override
    protected boolean canDeploy(Depot depot) {
        return false;
    }

    @Override
    protected boolean isRailBlocked(int checkIndex) {
        return false;
    }

    @Override
    protected boolean skipScanBlocks(Level world, double trainX, double trainY, double trainZ) {
        return false;
    }

    @Override
    protected boolean openDoors(Level world, Block block, BlockPos checkPos, int dwellTicks) {
        return true;
    }

    @Override
    protected float getModelZOffset() {
        return this.baseTrainType.startsWith("london_underground_199") || this.trainId.startsWith("london_underground_199") || this.baseTrainType.equals("mpl_85") || this.trainId.equals("mpl_85") || this.baseTrainType.equals("br_423") || this.trainId.equals("br_423") ? (this.reversed ? -0.5f : 0.5f) : 0.0f;
    }

    @Override
    protected double asin(double value) {
        return Math.asin(value);
    }

    public void simulateTrain(Level world, float ticksElapsed, SpeedCallback speedCallback, AnnouncementCallback announcementCallback, AnnouncementCallback lightRailAnnouncementCallback) {
        int stopIndex;
        this.trainTranslucentRenders.clear();
        this.speedCallback = speedCallback;
        this.announcementCallback = announcementCallback;
        this.lightRailAnnouncementCallback = lightRailAnnouncementCallback;
        this.oldSpeed = this.speed;
        this.oldRailProgress = this.railProgress;
        this.oldDoorValue = this.doorValue;
        if (ticksElapsed != 0.0f && !RailwayData.useRoutesAndStationsFromIndex(stopIndex = ((PathData)this.path.get((int)this.getIndex((int)0, (int)this.spacing, (boolean)false))).stopIndex - 1, this.routeIds, ClientData.DATA_CACHE, (currentStationIndex, thisRoute1, nextRoute1, thisStation1, nextStation1, lastStation1) -> {
            this.currentStationIndex = currentStationIndex;
            this.thisRoute = thisRoute1;
            this.nextRoute = nextRoute1;
            this.thisStation = thisStation1;
            this.nextStation = nextStation1;
            this.lastStation = lastStation1;
        })) {
            this.currentStationIndex = 0;
            this.thisRoute = null;
            this.nextRoute = null;
            this.thisStation = null;
            this.nextStation = null;
            this.lastStation = null;
        }
        this.simulateTrain(world, ticksElapsed, null);
        if (this.depot == null || this.routeIds.isEmpty()) {
            Siding siding = (Siding)ClientData.DATA_CACHE.sidingIdMap.get(this.sidingId);
            this.depot = siding == null ? null : (Depot)ClientData.DATA_CACHE.sidingIdToDepot.get(siding.id);
            List<Object> list = this.routeIds = this.depot == null ? new ArrayList() : this.depot.routeIds;
            if (this.depot != null) {
                this.depot.lastDeployedMillis = System.currentTimeMillis();
            }
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (this.isManualAllowed && Train.isHoldingKey((Player)player) && this.isPlayerRiding((Player)player)) {
            RenderDrivingOverlay.setData(this.manualNotch, this);
        }
    }

    public void renderTranslucent() {
        this.trainTranslucentRenders.forEach(Runnable::run);
        this.trainTranslucentRenders.clear();
    }

    public Vec3 getViewOffset() {
        return this.vehicleRidingClient.getViewOffset();
    }

    public int getCurrentStationIndex() {
        return this.currentStationIndex;
    }

    public Route getThisRoute() {
        return this.thisRoute;
    }

    public Route getNextRoute() {
        return this.nextRoute;
    }

    public Station getThisStation() {
        return this.thisStation;
    }

    public Station getNextStation() {
        return this.nextStation;
    }

    public Station getLastStation() {
        return this.lastStation;
    }

    public void startRidingClient(UUID uuid, float percentageX, float percentageZ) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_20148_().equals(uuid)) {
            this.justMounted = true;
            this.isSitting = false;
        }
        this.vehicleRidingClient.startRiding(uuid, percentageX, percentageZ);
    }

    public void updateRiderPercentages(UUID uuid, float percentageX, float percentageZ) {
        this.vehicleRidingClient.updateRiderPercentages(uuid, percentageX, percentageZ);
    }

    public void copyFromTrain(Train train) {
        this.path.clear();
        this.distances.clear();
        this.ridingEntities.clear();
        this.path.addAll(train.path);
        this.distances.addAll(train.distances);
        this.ridingEntities.addAll(train.ridingEntities);
        this.speed = train.speed;
        this.railProgress = train.railProgress;
        this.doorTarget = train.doorTarget;
        this.elapsedDwellTicks = train.elapsedDwellTicks;
        this.nextStoppingIndex = train.nextStoppingIndex;
        this.nextPlatformIndex = train.nextPlatformIndex;
        this.reversed = train.reversed;
        this.isOnRoute = train.isOnRoute;
        this.isCurrentlyManual = train.isCurrentlyManual;
        this.manualNotch = train.manualNotch;
    }

    public final float speedChange() {
        return this.speed - this.oldSpeed;
    }

    public boolean justOpening() {
        return this.oldDoorValue == 0.0f && this.doorValue > 0.0f;
    }

    public boolean justClosing(float doorCloseTime) {
        return this.oldDoorValue >= doorCloseTime && this.doorValue < doorCloseTime;
    }

    public final boolean isDoorOpening() {
        return this.doorOpening;
    }

    public final List<Long> getRouteIds() {
        return this.routeIds;
    }

    private int getPreviousStoppingIndex(int headIndex) {
        for (int i = headIndex; i >= 0; --i) {
            if (((PathData)this.path.get((int)i)).dwellTime <= 0 || ((PathData)this.path.get((int)i)).rail.railType != RailType.PLATFORM) continue;
            return i;
        }
        return 0;
    }

    @FunctionalInterface
    public static interface SpeedCallback {
        public void speedCallback(float var1, int var2, List<Long> var3);
    }

    @FunctionalInterface
    public static interface AnnouncementCallback {
        public void announcementCallback(int var1, List<Long> var2);
    }
}

