/*
 * Decompiled with CFR 0.152.
 */
package mtr.item;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import mtr.CreativeModeTabs;
import mtr.block.BlockLiftTrack;
import mtr.block.BlockLiftTrackFloor;
import mtr.block.IBlock;
import mtr.data.LiftServer;
import mtr.data.RailwayData;
import mtr.item.ItemWithCreativeTabBase;
import mtr.mappings.Text;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ItemLiftRefresher
extends ItemWithCreativeTabBase {
    public ItemLiftRefresher() {
        super(CreativeModeTabs.ESCALATORS_LIFTS, properties -> properties.m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (!context.m_43725_().f_46443_) {
            return ItemLiftRefresher.refreshLift(context.m_43725_(), context.m_8083_(), context.m_43723_(), 0, 0, 2, 2, false, null);
        }
        return super.m_6225_(context);
    }

    public static void refreshLift(Level world, BlockPos clickedPos, int offsetX, int offsetZ, int width, int depth, boolean isDoubleSided, Direction forceFacing) {
        ItemLiftRefresher.refreshLift(world, clickedPos, null, offsetX, offsetZ, width, depth, isDoubleSided, forceFacing);
    }

    private static InteractionResult refreshLift(Level world, BlockPos clickedPos, Player player, int offsetX, int offsetZ, int width, int depth, boolean isDoubleSided, Direction forceFacing) {
        RailwayData railwayData = RailwayData.getInstance(world);
        if (world.m_8055_(clickedPos).m_60734_() instanceof BlockLiftTrack && railwayData != null) {
            InteractionResult result;
            ArrayList<BlockPos> floors = new ArrayList<BlockPos>();
            HashSet liftsToModify = new HashSet();
            int i = 0;
            boolean scanForFloors = false;
            BlockPos firstFloor = null;
            Direction facing = null;
            railwayData.lifts.removeIf(lift -> lift.isInvalidLift(world));
            while (true) {
                BlockPos checkPos;
                Block checkBlock;
                if (!((checkBlock = world.m_8055_(checkPos = clickedPos.m_6625_(i)).m_60734_()) instanceof BlockLiftTrack)) {
                    if (scanForFloors) break;
                    scanForFloors = true;
                }
                if (scanForFloors && checkBlock instanceof BlockLiftTrackFloor) {
                    BlockEntity blockEntity = world.m_7702_(checkPos);
                    if (blockEntity instanceof BlockLiftTrackFloor.TileEntityLiftTrackFloor) {
                        floors.add(checkPos);
                        if (firstFloor == null || facing == null) {
                            firstFloor = checkPos;
                            facing = (Direction)IBlock.getStatePropertySafe((BlockGetter)world, checkPos, HorizontalDirectionalBlock.f_54117_);
                        }
                    }
                    railwayData.lifts.forEach(lift -> {
                        if (lift.hasFloor(checkPos)) {
                            liftsToModify.add(lift);
                        }
                    });
                }
                i += scanForFloors ? -1 : 1;
            }
            if (floors.isEmpty() || firstFloor == null || facing == null) {
                if (player != null) {
                    player.m_5661_((Component)Text.translatable("gui.mtr.no_lift_tracks_floor_found", new Object[0]), true);
                }
                result = InteractionResult.FAIL;
            } else {
                boolean hasSetFloors = false;
                long liftId = 0L;
                for (LiftServer lift2 : liftsToModify) {
                    if (hasSetFloors) {
                        railwayData.lifts.remove(lift2);
                        continue;
                    }
                    liftId = ItemLiftRefresher.setLiftData(lift2, floors, offsetX, offsetZ, width, depth, isDoubleSided);
                    hasSetFloors = true;
                }
                if (!hasSetFloors) {
                    LiftServer newLift = new LiftServer(firstFloor, forceFacing == null ? facing : forceFacing);
                    liftId = ItemLiftRefresher.setLiftData(newLift, floors, offsetX, offsetZ, width, depth, isDoubleSided);
                    railwayData.lifts.add(newLift);
                }
                if (player != null) {
                    PacketTrainDataGuiServer.openLiftCustomizationScreenS2C((ServerPlayer)player, liftId);
                }
                result = InteractionResult.SUCCESS;
            }
            railwayData.dataCache.sync();
            return result;
        }
        if (player != null) {
            player.m_5661_((Component)Text.translatable("gui.mtr.lift_track_required", new Object[0]), true);
        }
        return InteractionResult.FAIL;
    }

    private static long setLiftData(LiftServer lift, List<BlockPos> floors, int offsetX, int offsetZ, int width, int depth, boolean isDoubleSided) {
        lift.setFloors(floors);
        lift.liftOffsetX = offsetX;
        lift.liftOffsetZ = offsetZ;
        lift.liftWidth = width;
        lift.liftDepth = depth;
        lift.isDoubleSided = isDoubleSided;
        return lift.id;
    }
}

