/*
 * Decompiled with CFR 0.152.
 */
package mtr.mappings;

import dev.architectury.networking.NetworkManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public interface NetworkUtilities {
    public static void registerReceiverS2C(ResourceLocation id, NetworkManager.NetworkReceiver receiver) {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)id, (NetworkManager.NetworkReceiver)receiver);
    }

    public static void registerReceiverC2S(ResourceLocation id, PacketCallback packetCallback) {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)id, (packet, context) -> {
            Player player = context.getPlayer();
            if (player != null) {
                packetCallback.packetCallback(player.m_20194_(), (ServerPlayer)player, packet);
            }
        });
    }

    public static void sendToPlayer(ServerPlayer player, ResourceLocation id, FriendlyByteBuf packet) {
        packet.resetReaderIndex();
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)id, (FriendlyByteBuf)packet);
    }

    public static void sendToServer(ResourceLocation id, FriendlyByteBuf packet) {
        NetworkManager.sendToServer((ResourceLocation)id, (FriendlyByteBuf)packet);
    }

    @FunctionalInterface
    public static interface PacketCallback {
        public void packetCallback(MinecraftServer var1, ServerPlayer var2, FriendlyByteBuf var3);
    }
}

