/*
 * Decompiled with CFR 0.152.
 */
package mtr.mappings;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.Utilities;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public interface RegistryUtilities {
    public static <T extends BlockEntityMapper> BlockEntityType<T> getBlockEntityType(Utilities.TileEntitySupplier<T> supplier, Block block) {
        return new BlockEntityType(supplier::supplier, Collections.singleton(block), null);
    }

    public static void registerCommand(Consumer<CommandDispatcher<CommandSourceStack>> callback) {
        CommandRegistrationEvent.EVENT.register((dispatcher, dedicated, commandSelection) -> callback.accept(dispatcher));
    }

    public static void registerPlayerJoinEvent(Consumer<ServerPlayer> consumer) {
        PlayerEvent.PLAYER_JOIN.register(consumer::accept);
    }

    public static void registerPlayerQuitEvent(Consumer<ServerPlayer> consumer) {
        PlayerEvent.PLAYER_QUIT.register(consumer::accept);
    }

    public static void registerPlayerChangeDimensionEvent(Consumer<ServerPlayer> consumer) {
        PlayerEvent.CHANGE_DIMENSION.register((player, oldWorld, newWorld) -> consumer.accept(player));
    }

    public static void registerServerStartingEvent(Consumer<MinecraftServer> consumer) {
        LifecycleEvent.SERVER_STARTING.register(consumer::accept);
    }

    public static void registerServerStoppingEvent(Consumer<MinecraftServer> consumer) {
        LifecycleEvent.SERVER_STOPPING.register(consumer::accept);
    }

    public static void registerTickEvent(Consumer<MinecraftServer> consumer) {
        TickEvent.SERVER_PRE.register(consumer::accept);
    }

    public static SoundEvent createSoundEvent(ResourceLocation resourceLocation) {
        return SoundEvent.m_262824_((ResourceLocation)resourceLocation);
    }

    public static Item.Properties createItemProperties(Supplier<CreativeModeTab> creativeModeTab) {
        return new Item.Properties();
    }

    public static DefaultedRegistry<Item> registryGetItem() {
        return BuiltInRegistries.f_257033_;
    }

    public static DefaultedRegistry<Block> registryGetBlock() {
        return BuiltInRegistries.f_256975_;
    }

    public static Registry<BlockEntityType<?>> registryGetBlockEntityType() {
        return BuiltInRegistries.f_257049_;
    }

    public static DefaultedRegistry<EntityType<?>> registryGetEntityType() {
        return BuiltInRegistries.f_256780_;
    }

    public static Registry<SoundEvent> registryGetSoundEvent() {
        return BuiltInRegistries.f_256894_;
    }

    public static Registry<ParticleType<?>> registryGetParticleType() {
        return BuiltInRegistries.f_257034_;
    }
}

