/*
 * Decompiled with CFR 0.152.
 */
package mtr.mappings;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.io.File;
import java.io.IOException;
import java.util.List;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.MinecartModel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import org.joml.Matrix4f;

public interface UtilitiesClient {
    public static void beginDrawingRectangle(BufferBuilder buffer) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
    }

    public static void finishDrawingRectangle() {
    }

    public static void beginDrawingTexture(ResourceLocation textureId) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)textureId);
    }

    public static int drawInBatch(Font textRenderer, FormattedCharSequence formattedCharSequence, float x, float y, int color, boolean shadow, Matrix4f matrix4f, MultiBufferSource immediate, int overlay, int light) {
        return textRenderer.m_252916_(formattedCharSequence, x, y, color, shadow, matrix4f, immediate, false, overlay, light);
    }

    public static void setScreen(Minecraft client, ScreenMapper screen) {
        client.m_91152_((Screen)screen);
    }

    public static EntityModel<Minecart> getMinecartModel() {
        return new MinecartModel(MinecartModel.m_170738_().m_171564_());
    }

    public static EntityModel<Boat> getBoatModel() {
        return new BoatModel(BoatModel.m_246613_().m_171564_());
    }

    public static void setPacketCoordinates(Entity entity, double x, double y, double z) {
        entity.m_217006_(x, y, z);
    }

    public static float getPacketYaw(ClientboundAddEntityPacket packet) {
        return packet.m_237567_();
    }

    public static int getRenderDistance() {
        return (Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_();
    }

    public static List<Resource> getResources(ResourceManager resourceManager, ResourceLocation resourceLocation) throws IOException {
        return resourceManager.m_213829_(resourceLocation);
    }

    public static boolean hasResource(ResourceLocation resourceLocation) {
        return Minecraft.m_91087_().m_91098_().m_213713_(resourceLocation).isPresent();
    }

    public static boolean isHovered(AbstractWidget widget) {
        return widget.m_198029_();
    }

    public static File getResourcePackDirectory(Minecraft minecraft) {
        return minecraft.m_245161_().toFile();
    }

    public static Button newButton(Button.OnPress onPress) {
        return UtilitiesClient.newButton((Component)Text.literal(""), onPress);
    }

    public static Button newButton(Component component, Button.OnPress onPress) {
        return Button.m_253074_((Component)component, (Button.OnPress)onPress).m_253136_();
    }

    public static Button newButton(int height, Component component, Button.OnPress onPress) {
        return Button.m_253074_((Component)component, (Button.OnPress)onPress).m_253046_(0, height).m_253136_();
    }

    public static int getWidgetX(AbstractWidget widget) {
        return widget.m_252754_();
    }

    public static void setWidgetX(AbstractWidget widget, int x) {
        widget.m_252865_(x);
    }

    public static void setWidgetY(AbstractWidget widget, int y) {
        widget.m_252888_(y);
    }

    public static int getWidgetY(AbstractWidget widget) {
        return widget.m_252907_();
    }

    public static void rotateX(PoseStack matrices, float angle) {
        matrices.m_252781_(Axis.f_252529_.m_252961_(angle));
    }

    public static void rotateXDegrees(PoseStack matrices, float angle) {
        matrices.m_252781_(Axis.f_252529_.m_252977_(angle));
    }

    public static void rotateY(PoseStack matrices, float angle) {
        matrices.m_252781_(Axis.f_252436_.m_252961_(angle));
    }

    public static void rotateYDegrees(PoseStack matrices, float angle) {
        matrices.m_252781_(Axis.f_252436_.m_252977_(angle));
    }

    public static void rotateZ(PoseStack matrices, float angle) {
        matrices.m_252781_(Axis.f_252403_.m_252961_(angle));
    }

    public static void rotateZDegrees(PoseStack matrices, float angle) {
        matrices.m_252781_(Axis.f_252403_.m_252977_(angle));
    }
}

