/*
 * Decompiled with CFR 0.152.
 */
package mtr.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mtr.client.DoorAnimationType;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.mappings.UtilitiesClient;
import mtr.model.ModelDoorOverlay;
import mtr.model.ModelDoorOverlayTopBase;
import mtr.model.ModelTrainBase;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;

public abstract class ModelSimpleTrainBase<T>
extends ModelTrainBase {
    public ModelSimpleTrainBase(DoorAnimationType doorAnimationType, boolean renderDoorOverlay) {
        super(doorAnimationType, renderDoorOverlay);
    }

    @Override
    protected final void render(PoseStack matrices, VertexConsumer vertices, ModelTrainBase.RenderStage renderStage, int light, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ, int car, int totalCars, boolean head1IsFront, boolean renderDetails) {
        boolean isEnd1Head = car == 0;
        boolean isEnd2Head = car == totalCars - 1;
        for (int position : this.getWindowPositions()) {
            this.renderWindowPositions(matrices, vertices, renderStage, light, position, renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ, isEnd1Head, isEnd2Head);
        }
        for (int position : this.getDoorPositions()) {
            this.renderDoorPositions(matrices, vertices, renderStage, light, position, renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ, isEnd1Head, isEnd2Head);
        }
        if (isEnd1Head) {
            this.renderHeadPosition1(matrices, vertices, renderStage, light, this.getEndPositions()[0], renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ, head1IsFront);
        } else {
            this.renderEndPosition1(matrices, vertices, renderStage, light, this.getEndPositions()[0], renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ);
        }
        if (isEnd2Head) {
            this.renderHeadPosition2(matrices, vertices, renderStage, light, this.getEndPositions()[1], renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ, !head1IsFront);
        } else {
            this.renderEndPosition2(matrices, vertices, renderStage, light, this.getEndPositions()[1], renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ);
        }
    }

    @Override
    protected void renderExtraDetails(PoseStack matrices, MultiBufferSource vertexConsumers, int light, int lightOnInteriorLevel, boolean lightsOn, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ) {
        for (int position : this.getDoorPositions()) {
            ModelDoorOverlayTopBase modelDoorOverlayTop;
            ModelDoorOverlay modelDoorOverlay;
            ModelDoorOverlay modelDoorOverlay2 = modelDoorOverlay = this.renderDoorOverlay ? this.getModelDoorOverlay() : null;
            if (modelDoorOverlay != null) {
                modelDoorOverlay.render(matrices, vertexConsumers, ModelTrainBase.RenderStage.INTERIOR, lightOnInteriorLevel, position, doorLeftX, doorRightX, doorLeftZ, doorRightZ, lightsOn);
                modelDoorOverlay.render(matrices, vertexConsumers, ModelTrainBase.RenderStage.EXTERIOR, light, position, doorLeftX, doorRightX, doorLeftZ, doorRightZ, lightsOn);
            }
            ModelDoorOverlayTopBase modelDoorOverlayTopBase = modelDoorOverlayTop = this.renderDoorOverlay ? this.getModelDoorOverlayTop() : null;
            if (modelDoorOverlayTop == null) continue;
            modelDoorOverlayTop.render(matrices, vertexConsumers, light, position, doorLeftX, doorRightX, doorLeftZ, doorRightZ);
        }
    }

    protected void renderFrontDestination(PoseStack matrices, Font font, MultiBufferSource.BufferSource immediate, float x1, float y1, float z1, float x2, float y2, float z2, float rotationX, float rotationY, float maxWidth, float maxHeight, int colorCjk, int color, float fontSizeRatio, String text, boolean padOneLine, int car, int totalCars) {
        boolean isEnd1Head = car == 0;
        boolean isEnd2Head = car == totalCars - 1;
        for (int i = 0; i < 2; ++i) {
            if ((i != 0 || !isEnd1Head) && (i != 1 || !isEnd2Head)) continue;
            matrices.m_85836_();
            if (i == 1) {
                UtilitiesClient.rotateYDegrees(matrices, 180.0f);
            }
            matrices.m_252880_(x1, y1, z1);
            if (rotationY != 0.0f) {
                UtilitiesClient.rotateYDegrees(matrices, rotationY);
            }
            if (rotationX != 0.0f) {
                UtilitiesClient.rotateXDegrees(matrices, rotationX);
            }
            matrices.m_252880_(x2, y2, z2);
            IDrawing.drawStringWithFont(matrices, font, immediate, text, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, IGui.HorizontalAlignment.CENTER, 0.0f, 0.0f, maxWidth, (padOneLine && !text.contains("|") ? (IGui.isCjk(text) ? fontSizeRatio / (fontSizeRatio + 1.0f) : 0.5f) : 1.0f) * maxHeight, 1.0f, colorCjk, color, fontSizeRatio, false, 0xF000F0, null);
            matrices.m_85849_();
        }
    }

    public abstract T createNew(DoorAnimationType var1, boolean var2);

    protected abstract void renderWindowPositions(PoseStack var1, VertexConsumer var2, ModelTrainBase.RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10, boolean var11, boolean var12);

    protected abstract void renderDoorPositions(PoseStack var1, VertexConsumer var2, ModelTrainBase.RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10, boolean var11, boolean var12);

    protected abstract void renderHeadPosition1(PoseStack var1, VertexConsumer var2, ModelTrainBase.RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10, boolean var11);

    protected abstract void renderHeadPosition2(PoseStack var1, VertexConsumer var2, ModelTrainBase.RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10, boolean var11);

    protected abstract void renderEndPosition1(PoseStack var1, VertexConsumer var2, ModelTrainBase.RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10);

    protected abstract void renderEndPosition2(PoseStack var1, VertexConsumer var2, ModelTrainBase.RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10);

    protected abstract ModelDoorOverlay getModelDoorOverlay();

    protected abstract ModelDoorOverlayTopBase getModelDoorOverlayTop();

    protected abstract int[] getWindowPositions();

    protected abstract int[] getDoorPositions();

    protected abstract int[] getEndPositions();
}

