/*
 * Decompiled with CFR 0.152.
 */
package mtr.packet;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import mtr.RegistryClient;
import mtr.block.BlockTrainAnnouncer;
import mtr.block.BlockTrainScheduleSensor;
import mtr.block.BlockTrainSensorBase;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.Depot;
import mtr.data.EnumHelper;
import mtr.data.LiftClient;
import mtr.data.NameColorDataBase;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.Siding;
import mtr.data.Train;
import mtr.data.TransportMode;
import mtr.mappings.RegistryUtilities;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.packet.PacketTrainDataBase;
import mtr.screen.ArrivalProjectorConfigScreen;
import mtr.screen.DashboardScreen;
import mtr.screen.LiftCustomizationScreen;
import mtr.screen.LiftTrackFloorScreen;
import mtr.screen.PIDSConfigScreen;
import mtr.screen.RailwaySignScreen;
import mtr.screen.ResourcePackCreatorScreen;
import mtr.screen.TicketMachineScreen;
import mtr.screen.TrainAnnouncerScreen;
import mtr.screen.TrainBasicSensorScreen;
import mtr.screen.TrainScheduleSensorScreen;
import mtr.screen.TrainSensorScreenBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PacketTrainDataGuiClient
extends PacketTrainDataBase {
    private static final Map<Integer, ByteBuf> TEMP_PACKETS_RECEIVER = new HashMap<Integer, ByteBuf>();
    private static long tempPacketId = 0L;
    private static int expectedSize = 0;

    public static void openVersionCheckS2C(Minecraft minecraftClient, FriendlyByteBuf packet) {
        String version = packet.m_130277_();
        minecraftClient.execute(() -> {
            ClientPacketListener connection;
            if (!"1.19.3-3.2.1-hotfix-1".split("-hotfix-")[0].equals(version) && (connection = minecraftClient.m_91403_()) != null) {
                int i;
                int widthDifference1 = minecraftClient.f_91062_.m_92852_((FormattedText)Text.translatable("gui.mtr.mismatched_versions_your_version", new Object[0])) - minecraftClient.f_91062_.m_92852_((FormattedText)Text.translatable("gui.mtr.mismatched_versions_server_version", new Object[0]));
                int widthDifference2 = minecraftClient.f_91062_.m_92895_("1.19.3-3.2.1-hotfix-1") - minecraftClient.f_91062_.m_92895_(version);
                int spaceWidth = minecraftClient.f_91062_.m_92895_(" ");
                StringBuilder text = new StringBuilder();
                for (i = 0; i < -widthDifference1 / spaceWidth; ++i) {
                    text.append(" ");
                }
                text.append(Text.translatable("gui.mtr.mismatched_versions_your_version", "1.19.3-3.2.1-hotfix-1").getString());
                for (i = 0; i < -widthDifference2 / spaceWidth; ++i) {
                    text.append(" ");
                }
                text.append("\n");
                for (i = 0; i < widthDifference1 / spaceWidth; ++i) {
                    text.append(" ");
                }
                text.append(Text.translatable("gui.mtr.mismatched_versions_server_version", version).getString());
                for (i = 0; i < widthDifference2 / spaceWidth; ++i) {
                    text.append(" ");
                }
                text.append("\n\n");
                connection.m_6198_().m_129507_((Component)Text.literal(text.toString()).m_7220_((Component)Text.translatable("gui.mtr.mismatched_versions", new Object[0])));
            }
        });
    }

    public static void openDashboardScreenS2C(Minecraft minecraftClient, FriendlyByteBuf packet) {
        TransportMode transportMode = EnumHelper.valueOf(TransportMode.TRAIN, packet.m_130277_());
        boolean useTimeAndWindSync = packet.readBoolean();
        minecraftClient.execute(() -> {
            if (!(minecraftClient.f_91080_ instanceof DashboardScreen)) {
                UtilitiesClient.setScreen(minecraftClient, new DashboardScreen(transportMode, useTimeAndWindSync));
            }
        });
    }

    public static void openRailwaySignScreenS2C(Minecraft minecraftClient, FriendlyByteBuf packet) {
        BlockPos pos = packet.m_130135_();
        minecraftClient.execute(() -> {
            if (!(minecraftClient.f_91080_ instanceof RailwaySignScreen)) {
                UtilitiesClient.setScreen(minecraftClient, new RailwaySignScreen(pos));
            }
        });
    }

    public static void openTrainSensorScreenS2C(Minecraft minecraftClient, FriendlyByteBuf packet) {
        BlockPos pos = packet.m_130135_();
        minecraftClient.execute(() -> {
            if (minecraftClient.f_91073_ != null && !(minecraftClient.f_91080_ instanceof TrainSensorScreenBase)) {
                BlockEntity entity = minecraftClient.f_91073_.m_7702_(pos);
                if (entity instanceof BlockTrainAnnouncer.TileEntityTrainAnnouncer) {
                    UtilitiesClient.setScreen(minecraftClient, new TrainAnnouncerScreen(pos));
                } else if (entity instanceof BlockTrainScheduleSensor.TileEntityTrainScheduleSensor) {
                    UtilitiesClient.setScreen(minecraftClient, new TrainScheduleSensorScreen(pos));
                } else if (entity instanceof BlockTrainSensorBase.TileEntityTrainSensorBase) {
                    UtilitiesClient.setScreen(minecraftClient, new TrainBasicSensorScreen(pos));
                }
            }
        });
    }

    public static void openLiftTrackFloorS2C(Minecraft minecraftClient, FriendlyByteBuf packet) {
        BlockPos pos = packet.m_130135_();
        minecraftClient.execute(() -> {
            if (!(minecraftClient.f_91080_ instanceof LiftTrackFloorScreen)) {
                UtilitiesClient.setScreen(minecraftClient, new LiftTrackFloorScreen(pos));
            }
        });
    }

    public static void openLiftCustomizationS2C(Minecraft minecraftClient, FriendlyByteBuf packet) {
        long id = packet.readLong();
        minecraftClient.execute(() -> {
            LiftClient lift = ClientData.DATA_CACHE.liftsClientIdMap.get(id);
            if (!(minecraftClient.f_91080_ instanceof LiftCustomizationScreen) && lift != null) {
                UtilitiesClient.setScreen(minecraftClient, new LiftCustomizationScreen(lift));
            }
        });
    }

    public static void openTicketMachineScreenS2C(Minecraft minecraftClient, FriendlyByteBuf packet) {
        int balance = packet.readInt();
        minecraftClient.execute(() -> {
            if (!(minecraftClient.f_91080_ instanceof TicketMachineScreen)) {
                UtilitiesClient.setScreen(minecraftClient, new TicketMachineScreen(balance));
            }
        });
    }

    public static void openPIDSConfigScreenS2C(Minecraft minecraftClient, FriendlyByteBuf packet) {
        BlockPos pos1 = packet.m_130135_();
        BlockPos pos2 = packet.m_130135_();
        int maxArrivals = packet.readInt();
        minecraftClient.execute(() -> {
            if (!(minecraftClient.f_91080_ instanceof PIDSConfigScreen)) {
                UtilitiesClient.setScreen(minecraftClient, new PIDSConfigScreen(pos1, pos2, maxArrivals));
            }
        });
    }

    public static void openArrivalProjectorConfigScreenS2C(Minecraft minecraftClient, FriendlyByteBuf packet) {
        BlockPos pos = packet.m_130135_();
        minecraftClient.execute(() -> {
            if (!(minecraftClient.f_91080_ instanceof ArrivalProjectorConfigScreen)) {
                UtilitiesClient.setScreen(minecraftClient, new ArrivalProjectorConfigScreen(pos));
            }
        });
    }

    public static void openResourcePackCreatorScreen(Minecraft minecraftClient) {
        minecraftClient.execute(() -> {
            if (!(minecraftClient.f_91080_ instanceof ResourcePackCreatorScreen)) {
                UtilitiesClient.setScreen(minecraftClient, new ResourcePackCreatorScreen());
            }
        });
    }

    public static void announceS2C(Minecraft minecraftClient, FriendlyByteBuf packet) {
        String message = packet.m_130277_();
        String soundIdString = packet.m_130277_();
        minecraftClient.execute(() -> {
            IDrawing.narrateOrAnnounce(message);
            ClientLevel world = minecraftClient.f_91073_;
            LocalPlayer player = minecraftClient.f_91074_;
            if (!soundIdString.isEmpty() && world != null && player != null) {
                world.m_245747_(player.m_20183_(), RegistryUtilities.createSoundEvent(new ResourceLocation(soundIdString)), SoundSource.BLOCKS, 1000000.0f, 1.0f, false);
            }
        });
    }

    public static void createRailS2C(Minecraft minecraftClient, FriendlyByteBuf packet) {
        TransportMode transportMode = EnumHelper.valueOf(TransportMode.TRAIN, packet.m_130277_());
        BlockPos pos1 = packet.m_130135_();
        BlockPos pos2 = packet.m_130135_();
        Rail rail1 = new Rail(packet);
        Rail rail2 = new Rail(packet);
        long savedRailId = packet.readLong();
        minecraftClient.execute(() -> {
            RailwayData.addRail(ClientData.RAILS, ClientData.PLATFORMS, ClientData.SIDINGS, transportMode, pos1, pos2, rail1, 0L);
            RailwayData.addRail(ClientData.RAILS, ClientData.PLATFORMS, ClientData.SIDINGS, transportMode, pos2, pos1, rail2, savedRailId);
        });
    }

    public static void createSignalS2C(Minecraft minecraftClient, FriendlyByteBuf packet) {
        long id = packet.readLong();
        DyeColor dyeColor = DyeColor.values()[packet.readInt()];
        UUID rail = packet.m_130259_();
        minecraftClient.execute(() -> ClientData.SIGNAL_BLOCKS.add(id, dyeColor, rail));
    }

    public static void removeNodeS2C(Minecraft minecraftClient, FriendlyByteBuf packet) {
        BlockPos pos = packet.m_130135_();
        minecraftClient.execute(() -> RailwayData.removeNode(null, ClientData.RAILS, pos));
    }

    public static void removeLiftFloorTrackS2C(Minecraft minecraftClient, FriendlyByteBuf packet) {
        BlockPos pos = packet.m_130135_();
        minecraftClient.execute(() -> RailwayData.removeLiftFloorTrack(null, ClientData.LIFTS, pos));
    }

    public static void removeRailConnectionS2C(Minecraft minecraftClient, FriendlyByteBuf packet) {
        BlockPos pos1 = packet.m_130135_();
        BlockPos pos2 = packet.m_130135_();
        minecraftClient.execute(() -> RailwayData.removeRailConnection(null, ClientData.RAILS, pos1, pos2));
    }

    public static void removeSignalsS2C(Minecraft minecraftClient, FriendlyByteBuf packet) {
        long removeCount = packet.readInt();
        ArrayList<Long> ids = new ArrayList<Long>();
        ArrayList<DyeColor> colors = new ArrayList<DyeColor>();
        ArrayList<UUID> rails = new ArrayList<UUID>();
        int i = 0;
        while ((long)i < removeCount) {
            ids.add(packet.readLong());
            colors.add(DyeColor.values()[packet.readInt()]);
            rails.add(packet.m_130259_());
            ++i;
        }
        minecraftClient.execute(() -> {
            int i = 0;
            while ((long)i < removeCount) {
                ClientData.SIGNAL_BLOCKS.remove((Long)ids.get(i), (DyeColor)colors.get(i), (UUID)rails.get(i));
                ++i;
            }
        });
    }

    public static void receiveChunk(Minecraft minecraftClient, FriendlyByteBuf packet) {
        long id = packet.readLong();
        int chunk = packet.readInt();
        boolean complete = packet.readBoolean();
        if (tempPacketId != id) {
            TEMP_PACKETS_RECEIVER.clear();
            tempPacketId = id;
            expectedSize = Integer.MAX_VALUE;
        }
        if (complete) {
            expectedSize = chunk + 1;
        }
        TEMP_PACKETS_RECEIVER.put(chunk, packet.readBytes(packet.readableBytes()));
        if (TEMP_PACKETS_RECEIVER.size() == expectedSize) {
            FriendlyByteBuf newPacket = new FriendlyByteBuf(Unpooled.buffer());
            for (int i = 0; i < expectedSize; ++i) {
                newPacket.writeBytes(TEMP_PACKETS_RECEIVER.get(i));
            }
            TEMP_PACKETS_RECEIVER.clear();
            try {
                minecraftClient.execute(() -> ClientData.receivePacket(newPacket));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static <T extends NameColorDataBase> void receiveUpdateOrDeleteS2C(Minecraft minecraftClient, FriendlyByteBuf packet, Set<T> dataSet, Map<Long, T> cacheMap, BiFunction<Long, TransportMode, T> createDataWithId, boolean isDelete) {
        PacketTrainDataBase.PacketCallback packetCallback = (updatePacket, fullPacket) -> {
            ClientData.DATA_CACHE.sync();
            ClientData.DATA_CACHE.refreshDynamicResources();
        };
        if (isDelete) {
            PacketTrainDataGuiClient.deleteData(dataSet, cacheMap, minecraftClient, packet, packetCallback, null);
        } else {
            PacketTrainDataGuiClient.updateData(dataSet, cacheMap, minecraftClient, packet, packetCallback, createDataWithId, null);
        }
    }

    public static void sendUpdate(ResourceLocation packetId, FriendlyByteBuf packet) {
        RegistryClient.sendToServer(packetId, packet);
        ClientData.DATA_CACHE.sync();
        ClientData.DATA_CACHE.refreshDynamicResources();
    }

    public static void sendDeleteData(ResourceLocation packetId, long id) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeLong(id);
        PacketTrainDataGuiClient.sendUpdate(packetId, packet);
    }

    public static void sendTrainSensorC2S(BlockPos pos, Set<Long> filterRouteIds, boolean stoppedOnly, boolean movingOnly, int number, String ... strings) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130064_(pos);
        packet.writeInt(filterRouteIds.size());
        filterRouteIds.forEach(arg_0 -> ((FriendlyByteBuf)packet).writeLong(arg_0));
        packet.writeBoolean(stoppedOnly);
        packet.writeBoolean(movingOnly);
        packet.writeInt(number);
        packet.writeInt(strings.length);
        for (String string : strings) {
            packet.m_130070_(string);
        }
        RegistryClient.sendToServer(PACKET_UPDATE_TRAIN_SENSOR, packet);
    }

    public static void sendLiftTrackFloorC2S(BlockPos pos, String floorNumber, String floorDescription, boolean shouldDing) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130064_(pos);
        packet.m_130070_(floorNumber);
        packet.m_130070_(floorDescription);
        packet.writeBoolean(shouldDing);
        RegistryClient.sendToServer(PACKET_UPDATE_LIFT_TRACK_FLOOR, packet);
    }

    public static void generatePathS2C(Minecraft minecraftClient, FriendlyByteBuf packet) {
        long depotId = packet.readLong();
        int successfulSegments = packet.readInt();
        minecraftClient.execute(() -> {
            Depot depot = (Depot)ClientData.DATA_CACHE.depotIdMap.get(depotId);
            if (depot != null) {
                depot.clientPathGenerationSuccessfulSegments = successfulSegments;
            }
        });
    }

    public static void generatePathC2S(long sidingId) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeLong(sidingId);
        RegistryClient.sendToServer(PACKET_GENERATE_PATH, packet);
    }

    public static void clearTrainsC2S(long depotId, Collection<Siding> sidings) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeLong(depotId);
        packet.writeInt(sidings.size());
        sidings.forEach(siding -> packet.writeLong(siding.id));
        RegistryClient.sendToServer(PACKET_CLEAR_TRAINS, packet);
    }

    public static void sendUpdateEntitySeatPassengerPosition(double x, double y, double z) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeDouble(x);
        packet.writeDouble(y);
        packet.writeDouble(z);
        RegistryClient.sendToServer(PACKET_UPDATE_ENTITY_SEAT_POSITION, packet);
    }

    public static void sendSignIdsC2S(BlockPos signPos, Set<Long> selectedIds, String[] signIds) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130064_(signPos);
        packet.writeInt(selectedIds.size());
        selectedIds.forEach(arg_0 -> ((FriendlyByteBuf)packet).writeLong(arg_0));
        packet.writeInt(signIds.length);
        for (String signType : signIds) {
            packet.m_130070_(signType == null ? "" : signType);
        }
        RegistryClient.sendToServer(PACKET_SIGN_TYPES, packet);
    }

    public static void sendDriveTrainC2S(boolean pressingAccelerate, boolean pressingBrake, boolean pressingDoors) {
        if (Train.isHoldingKey((Player)Minecraft.m_91087_().f_91074_) && (pressingAccelerate || pressingBrake || pressingDoors)) {
            FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
            packet.writeBoolean(pressingAccelerate);
            packet.writeBoolean(pressingBrake);
            packet.writeBoolean(pressingDoors);
            RegistryClient.sendToServer(PACKET_DRIVE_TRAIN, packet);
        }
    }

    public static void sendPressLiftButtonC2S(long id, int floor) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeLong(id);
        packet.writeInt(floor);
        RegistryClient.sendToServer(PACKET_PRESS_LIFT_BUTTON, packet);
    }

    public static void addBalanceC2S(int addAmount, int emeralds) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeInt(addAmount);
        packet.writeInt(emeralds);
        RegistryClient.sendToServer(PACKET_ADD_BALANCE, packet);
    }

    public static void sendPIDSConfigC2S(BlockPos pos1, BlockPos pos2, String[] messages, boolean[] hideArrival, Set<Long> filterPlatformIds) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130064_(pos1);
        packet.m_130064_(pos2);
        packet.writeInt(messages.length);
        for (int i = 0; i < messages.length; ++i) {
            packet.m_130070_(messages[i]);
            packet.writeBoolean(hideArrival[i]);
        }
        packet.writeInt(filterPlatformIds.size());
        filterPlatformIds.forEach(arg_0 -> ((FriendlyByteBuf)packet).writeLong(arg_0));
        RegistryClient.sendToServer(PACKET_PIDS_UPDATE, packet);
    }

    public static void sendArrivalProjectorConfigC2S(BlockPos pos, Set<Long> filterPlatformIds, int displayPage) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130064_(pos);
        packet.writeInt(filterPlatformIds.size());
        filterPlatformIds.forEach(arg_0 -> ((FriendlyByteBuf)packet).writeLong(arg_0));
        packet.writeInt(displayPage);
        RegistryClient.sendToServer(PACKET_ARRIVAL_PROJECTOR_UPDATE, packet);
    }

    public static void sendUseTimeAndWindSyncC2S(boolean useTimeAndWindSync) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeBoolean(useTimeAndWindSync);
        RegistryClient.sendToServer(PACKET_USE_TIME_AND_WIND_SYNC, packet);
    }
}

