/*
 * Decompiled with CFR 0.152.
 */
package mtr.packet;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import mtr.Registry;
import mtr.block.BlockArrivalProjectorBase;
import mtr.block.BlockLiftTrackFloor;
import mtr.block.BlockPIDSBase;
import mtr.block.BlockRailwaySign;
import mtr.block.BlockRouteSignBase;
import mtr.block.BlockTrainSensorBase;
import mtr.data.Depot;
import mtr.data.Lift;
import mtr.data.LiftServer;
import mtr.data.NameColorDataBase;
import mtr.data.Platform;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.RailwayDataLoggingModule;
import mtr.data.Route;
import mtr.data.SerializedDataBase;
import mtr.data.Siding;
import mtr.data.SignalBlocks;
import mtr.data.Station;
import mtr.data.TicketSystem;
import mtr.data.TransportMode;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.Utilities;
import mtr.packet.PacketTrainDataBase;
import mtr.packet.UpdateBlueMap;
import mtr.packet.UpdateDynmap;
import mtr.packet.UpdateSquaremap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.scores.Score;

public class PacketTrainDataGuiServer
extends PacketTrainDataBase {
    private static final int PACKET_CHUNK_SIZE = (int)Math.pow(2.0, 14.0);

    public static void versionCheckS2C(ServerPlayer player) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130070_("1.19.3-3.2.1-hotfix-1".split("-hotfix-")[0]);
        Registry.sendToPlayer(player, PACKET_VERSION_CHECK, packet);
    }

    public static void openDashboardScreenS2C(ServerPlayer player, TransportMode transportMode, boolean useTimeAndWindSync) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130070_(transportMode.toString());
        packet.writeBoolean(useTimeAndWindSync);
        Registry.sendToPlayer(player, PACKET_OPEN_DASHBOARD_SCREEN, packet);
    }

    public static void openRailwaySignScreenS2C(ServerPlayer player, BlockPos signPos) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130064_(signPos);
        Registry.sendToPlayer(player, PACKET_OPEN_RAILWAY_SIGN_SCREEN, packet);
    }

    public static void openTicketMachineScreenS2C(Level world, ServerPlayer player) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeInt(TicketSystem.getPlayerScore(world, (Player)player, "mtr_balance").m_83400_());
        Registry.sendToPlayer(player, PACKET_OPEN_TICKET_MACHINE_SCREEN, packet);
    }

    public static void openTrainSensorScreenS2C(ServerPlayer player, BlockPos blockPos) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130064_(blockPos);
        Registry.sendToPlayer(player, PACKET_OPEN_TRAIN_SENSOR_SCREEN, packet);
    }

    public static void openLiftTrackFloorScreenS2C(ServerPlayer player, BlockPos blockPos) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130064_(blockPos);
        Registry.sendToPlayer(player, PACKET_OPEN_LIFT_TRACK_FLOOR_SCREEN, packet);
    }

    public static void openLiftCustomizationScreenS2C(ServerPlayer player, long id) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeLong(id);
        Registry.sendToPlayer(player, PACKET_OPEN_LIFT_CUSTOMIZATION_SCREEN, packet);
    }

    public static void openPIDSConfigScreenS2C(ServerPlayer player, BlockPos pos1, BlockPos pos2, int maxArrivals) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130064_(pos1);
        packet.m_130064_(pos2);
        packet.writeInt(maxArrivals);
        Registry.sendToPlayer(player, PACKET_OPEN_PIDS_CONFIG_SCREEN, packet);
    }

    public static void openArrivalProjectorConfigScreenS2C(ServerPlayer player, BlockPos pos) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130064_(pos);
        Registry.sendToPlayer(player, PACKET_OPEN_ARRIVAL_PROJECTOR_CONFIG_SCREEN, packet);
    }

    public static void openResourcePackCreatorScreenS2C(ServerPlayer player) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        Registry.sendToPlayer(player, PACKET_OPEN_RESOURCE_PACK_CREATOR_SCREEN, packet);
    }

    public static void announceS2C(ServerPlayer player, String message, ResourceLocation soundId) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130070_(message);
        packet.m_130070_(soundId == null ? "" : soundId.toString());
        Registry.sendToPlayer(player, PACKET_ANNOUNCE, packet);
    }

    public static void createRailS2C(Level world, TransportMode transportMode, BlockPos pos1, BlockPos pos2, Rail rail1, Rail rail2, long savedRailId) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130070_(transportMode.toString());
        packet.m_130064_(pos1);
        packet.m_130064_(pos2);
        rail1.writePacket(packet);
        rail2.writePacket(packet);
        packet.writeLong(savedRailId);
        world.m_6907_().forEach(worldPlayer -> Registry.sendToPlayer((ServerPlayer)worldPlayer, PACKET_CREATE_RAIL, packet));
    }

    public static void createSignalS2C(Level world, long id, DyeColor dyeColor, UUID rail) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeLong(id);
        packet.writeInt(dyeColor.ordinal());
        packet.m_130077_(rail);
        world.m_6907_().forEach(worldPlayer -> Registry.sendToPlayer((ServerPlayer)worldPlayer, PACKET_CREATE_SIGNAL, packet));
    }

    public static void updateRailActionsS2C(Level world, List<Rail.RailActions> railActions) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeInt(railActions.size());
        railActions.forEach(railAction -> railAction.writePacket(packet));
        world.m_6907_().forEach(worldPlayer -> Registry.sendToPlayer((ServerPlayer)worldPlayer, PACKET_UPDATE_RAIL_ACTIONS, packet));
    }

    public static void removeNodeS2C(Level world, BlockPos pos) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130064_(pos);
        world.m_6907_().forEach(worldPlayer -> Registry.sendToPlayer((ServerPlayer)worldPlayer, PACKET_REMOVE_NODE, packet));
    }

    public static void removeLiftFloorTrackS2C(Level world, BlockPos pos) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130064_(pos);
        world.m_6907_().forEach(worldPlayer -> Registry.sendToPlayer((ServerPlayer)worldPlayer, PACKET_REMOVE_LIFT_FLOOR_TRACK, packet));
    }

    public static void removeRailConnectionS2C(Level world, BlockPos pos1, BlockPos pos2) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130064_(pos1);
        packet.m_130064_(pos2);
        world.m_6907_().forEach(worldPlayer -> Registry.sendToPlayer((ServerPlayer)worldPlayer, PACKET_REMOVE_RAIL, packet));
    }

    public static void removeSignalS2C(Level world, long id, DyeColor dyeColor, UUID rail) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeInt(1);
        packet.writeLong(id);
        packet.writeInt(dyeColor.ordinal());
        packet.m_130077_(rail);
        world.m_6907_().forEach(worldPlayer -> Registry.sendToPlayer((ServerPlayer)worldPlayer, PACKET_REMOVE_SIGNALS, packet));
    }

    public static void sendAllInChunks(ServerPlayer player, Set<Station> stations, Set<Platform> platforms, Set<Siding> sidings, Set<Route> routes, Set<Depot> depots, Set<LiftServer> lifts, SignalBlocks signalBlocks) {
        long tempPacketId = new Random().nextLong();
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        PacketTrainDataGuiServer.serializeData(packet, stations);
        PacketTrainDataGuiServer.serializeData(packet, platforms);
        PacketTrainDataGuiServer.serializeData(packet, sidings);
        PacketTrainDataGuiServer.serializeData(packet, routes);
        PacketTrainDataGuiServer.serializeData(packet, depots);
        PacketTrainDataGuiServer.serializeData(packet, lifts);
        PacketTrainDataGuiServer.serializeData(packet, signalBlocks.signalBlocks);
        int i = 0;
        while (!PacketTrainDataGuiServer.sendChunk(player, packet, tempPacketId, i)) {
            ++i;
        }
    }

    public static <T extends NameColorDataBase> void receiveUpdateOrDeleteC2S(MinecraftServer minecraftServer, ServerPlayer player, FriendlyByteBuf packet, ResourceLocation packetId, Function<RailwayData, Set<T>> dataSet, Function<RailwayData, Map<Long, T>> cacheMap, BiFunction<Long, TransportMode, T> createDataWithId, boolean isDelete) {
        if (RailwayData.hasNoPermission(player)) {
            return;
        }
        Level world = player.f_19853_;
        RailwayData railwayData = RailwayData.getInstance(world);
        if (railwayData == null) {
            return;
        }
        PacketTrainDataBase.PacketCallback packetCallback = (updatePacket, fullPacket) -> {
            world.m_6907_().forEach(worldPlayer -> {
                if (!worldPlayer.m_20148_().equals(player.m_20148_())) {
                    Registry.sendToPlayer((ServerPlayer)worldPlayer, packetId, fullPacket);
                }
                railwayData.dataCache.sync();
            });
            if (packetId.equals((Object)PACKET_UPDATE_STATION) || packetId.equals((Object)PACKET_DELETE_STATION) || packetId.equals((Object)PACKET_UPDATE_DEPOT) || packetId.equals((Object)PACKET_DELETE_DEPOT)) {
                try {
                    UpdateDynmap.updateDynmap(world, railwayData);
                }
                catch (Exception | NoClassDefFoundError throwable) {
                    // empty catch block
                }
                try {
                    UpdateBlueMap.updateBlueMap(world, railwayData);
                }
                catch (Exception | NoClassDefFoundError throwable) {
                    // empty catch block
                }
                try {
                    UpdateSquaremap.updateSquaremap(world, railwayData);
                }
                catch (Exception | NoClassDefFoundError throwable) {
                    // empty catch block
                }
            }
        };
        if (isDelete) {
            PacketTrainDataGuiServer.deleteData(dataSet.apply(railwayData), cacheMap.apply(railwayData), minecraftServer, packet, packetCallback, data -> railwayData.railwayDataLoggingModule.addEvent(player, data.getClass(), data.id, data.name, RailwayDataLoggingModule.getData(data), new ArrayList<String>(), new BlockPos[0]));
        } else {
            PacketTrainDataGuiServer.updateData(dataSet.apply(railwayData), cacheMap.apply(railwayData), minecraftServer, packet, packetCallback, createDataWithId, (data, oldData) -> railwayData.railwayDataLoggingModule.addEvent(player, data.getClass(), data.id, data.name, (List<String>)oldData, RailwayDataLoggingModule.getData(data), new BlockPos[0]));
        }
    }

    public static void generatePathS2C(Level world, long depotId, int successfulSegments) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.writeLong(depotId);
        packet.writeInt(successfulSegments);
        world.m_6907_().forEach(player -> Registry.sendToPlayer((ServerPlayer)player, PACKET_GENERATE_PATH, packet));
    }

    public static void generatePathC2S(MinecraftServer minecraftServer, ServerPlayer player, FriendlyByteBuf packet) {
        Level world = player.f_19853_;
        RailwayData railwayData = RailwayData.getInstance(world);
        if (railwayData != null) {
            long depotId = packet.readLong();
            minecraftServer.execute(() -> railwayData.railwayDataPathGenerationModule.generatePath(minecraftServer, depotId));
        }
    }

    public static void clearTrainsC2S(MinecraftServer minecraftServer, ServerPlayer player, FriendlyByteBuf packet) {
        if (RailwayData.hasNoPermission(player)) {
            return;
        }
        Level world = player.f_19853_;
        RailwayData railwayData = RailwayData.getInstance(world);
        if (railwayData != null) {
            long depotId = packet.readLong();
            int sidingCount = packet.readInt();
            HashSet<Long> sidingIds = new HashSet<Long>();
            for (int i = 0; i < sidingCount; ++i) {
                sidingIds.add(packet.readLong());
            }
            minecraftServer.execute(() -> {
                Depot depot = railwayData.dataCache.depotIdMap.get(depotId);
                if (depot != null) {
                    railwayData.resetTrainDelays(depot);
                }
                sidingIds.forEach(sidingId -> {
                    Siding siding = railwayData.dataCache.sidingIdMap.get(sidingId);
                    if (siding != null) {
                        siding.clearTrains();
                    }
                });
            });
        }
    }

    public static void receiveTrainSensorC2S(MinecraftServer minecraftServer, ServerPlayer player, FriendlyByteBuf packet) {
        BlockPos pos = packet.m_130135_();
        HashSet<Long> filterIds = new HashSet<Long>();
        int filterLength = packet.readInt();
        for (int i = 0; i < filterLength; ++i) {
            filterIds.add(packet.readLong());
        }
        boolean stoppedOnly = packet.readBoolean();
        boolean movingOnly = packet.readBoolean();
        int number = packet.readInt();
        int stringCount = packet.readInt();
        String[] strings = new String[stringCount];
        for (int i = 0; i < stringCount; ++i) {
            strings[i] = packet.m_130136_(Short.MAX_VALUE);
        }
        minecraftServer.execute(() -> {
            BlockEntity entity = player.f_19853_.m_7702_(pos);
            if (entity instanceof BlockTrainSensorBase.TileEntityTrainSensorBase) {
                PacketTrainDataGuiServer.setTileEntityDataAndWriteUpdate((ServerPlayer)player, (T entity2) -> entity2.setData(filterIds, stoppedOnly, movingOnly, number, strings), (BlockEntityMapper[])new BlockTrainSensorBase.TileEntityTrainSensorBase[]{(BlockTrainSensorBase.TileEntityTrainSensorBase)entity});
            }
        });
    }

    public static void receiveLiftTrackFloorC2S(MinecraftServer minecraftServer, ServerPlayer player, FriendlyByteBuf packet) {
        BlockPos pos = packet.m_130135_();
        String floorNumber = packet.m_130136_(Short.MAX_VALUE);
        String floorDescription = packet.m_130136_(Short.MAX_VALUE);
        boolean shouldDing = packet.readBoolean();
        minecraftServer.execute(() -> {
            BlockEntity entity = player.f_19853_.m_7702_(pos);
            if (entity instanceof BlockLiftTrackFloor.TileEntityLiftTrackFloor) {
                PacketTrainDataGuiServer.setTileEntityDataAndWriteUpdate((ServerPlayer)player, (T entity2) -> entity2.setData(floorNumber, floorDescription, shouldDing), (BlockEntityMapper[])new BlockLiftTrackFloor.TileEntityLiftTrackFloor[]{(BlockLiftTrackFloor.TileEntityLiftTrackFloor)entity});
            }
        });
    }

    public static void receiveSignIdsC2S(MinecraftServer minecraftServer, ServerPlayer player, FriendlyByteBuf packet) {
        BlockPos signPos = packet.m_130135_();
        int selectedIdsLength = packet.readInt();
        HashSet<Long> selectedIds = new HashSet<Long>();
        for (int i = 0; i < selectedIdsLength; ++i) {
            selectedIds.add(packet.readLong());
        }
        int signLength = packet.readInt();
        String[] signIds = new String[signLength];
        for (int i = 0; i < signLength; ++i) {
            String signId = packet.m_130136_(Short.MAX_VALUE);
            signIds[i] = signId.isEmpty() ? null : signId;
        }
        minecraftServer.execute(() -> {
            BlockEntity entity = player.f_19853_.m_7702_(signPos);
            if (entity instanceof BlockRailwaySign.TileEntityRailwaySign) {
                PacketTrainDataGuiServer.setTileEntityDataAndWriteUpdate((ServerPlayer)player, (T entity2) -> entity2.setData(selectedIds, signIds), (BlockEntityMapper[])new BlockRailwaySign.TileEntityRailwaySign[]{(BlockRailwaySign.TileEntityRailwaySign)entity});
            } else if (entity instanceof BlockRouteSignBase.TileEntityRouteSignBase) {
                long platformId = selectedIds.isEmpty() ? 0L : (Long)selectedIds.toArray()[0];
                BlockEntity entityAbove = player.f_19853_.m_7702_(signPos.m_7494_());
                if (entityAbove instanceof BlockRouteSignBase.TileEntityRouteSignBase) {
                    PacketTrainDataGuiServer.setTileEntityDataAndWriteUpdate((ServerPlayer)player, (T entity2) -> entity2.setPlatformId(platformId), (BlockEntityMapper[])new BlockRouteSignBase.TileEntityRouteSignBase[]{(BlockRouteSignBase.TileEntityRouteSignBase)entityAbove, (BlockRouteSignBase.TileEntityRouteSignBase)entity});
                } else {
                    PacketTrainDataGuiServer.setTileEntityDataAndWriteUpdate((ServerPlayer)player, (T entity2) -> entity2.setPlatformId(platformId), (BlockEntityMapper[])new BlockRouteSignBase.TileEntityRouteSignBase[]{(BlockRouteSignBase.TileEntityRouteSignBase)entity});
                }
            }
        });
    }

    public static void receiveDriveTrainC2S(MinecraftServer minecraftServer, ServerPlayer player, FriendlyByteBuf packet) {
        RailwayData railwayData = RailwayData.getInstance(player.f_19853_);
        if (railwayData != null) {
            boolean pressingAccelerate = packet.readBoolean();
            boolean pressingBrake = packet.readBoolean();
            boolean pressingDoors = packet.readBoolean();
            minecraftServer.execute(() -> railwayData.railwayDataDriveTrainModule.drive(player, pressingAccelerate, pressingBrake, pressingDoors));
        }
    }

    public static void receivePressLiftButtonC2S(MinecraftServer minecraftServer, ServerPlayer player, FriendlyByteBuf packet) {
        RailwayData railwayData = RailwayData.getInstance(player.f_19853_);
        if (railwayData != null) {
            long id = packet.readLong();
            int floor = packet.readInt();
            minecraftServer.execute(() -> {
                Lift lift = railwayData.dataCache.liftsServerIdMap.get(id);
                if (lift != null) {
                    lift.pressButton(floor);
                }
            });
        }
    }

    public static void receiveAddBalanceC2S(MinecraftServer minecraftServer, ServerPlayer player, FriendlyByteBuf packet) {
        int addAmount = packet.readInt();
        int emeralds = packet.readInt();
        minecraftServer.execute(() -> {
            Level world = player.f_19853_;
            TicketSystem.addObjectivesIfMissing(world);
            Score balanceScore = TicketSystem.getPlayerScore(world, (Player)player, "mtr_balance");
            balanceScore.m_83402_(balanceScore.m_83400_() + addAmount);
            ContainerHelper.m_18956_((Container)Utilities.getInventory((Player)player), itemStack -> itemStack.m_41720_() == Items.f_42616_, (int)emeralds, (boolean)false);
            world.m_5594_(null, player.m_20183_(), SoundEvents.f_11871_, SoundSource.BLOCKS, 1.0f, 1.0f);
        });
    }

    public static void receivePIDSMessageC2S(MinecraftServer minecraftServer, ServerPlayer player, FriendlyByteBuf packet) {
        BlockPos pos1 = packet.m_130135_();
        BlockPos pos2 = packet.m_130135_();
        int maxArrivals = packet.readInt();
        String[] messages = new String[maxArrivals];
        boolean[] hideArrivals = new boolean[maxArrivals];
        for (int i = 0; i < maxArrivals; ++i) {
            messages[i] = packet.m_130136_(Short.MAX_VALUE);
            hideArrivals[i] = packet.readBoolean();
        }
        int platformIdCount = packet.readInt();
        HashSet<Long> platformIds = new HashSet<Long>();
        for (int i = 0; i < platformIdCount; ++i) {
            platformIds.add(packet.readLong());
        }
        minecraftServer.execute(() -> {
            BlockEntity entity2;
            ArrayList<BlockPIDSBase.TileEntityBlockPIDSBase> entities = new ArrayList<BlockPIDSBase.TileEntityBlockPIDSBase>();
            BlockEntity entity1 = player.f_19853_.m_7702_(pos1);
            if (entity1 instanceof BlockPIDSBase.TileEntityBlockPIDSBase) {
                entities.add((BlockPIDSBase.TileEntityBlockPIDSBase)entity1);
            }
            if ((entity2 = player.f_19853_.m_7702_(pos2)) instanceof BlockPIDSBase.TileEntityBlockPIDSBase) {
                entities.add((BlockPIDSBase.TileEntityBlockPIDSBase)entity2);
            }
            PacketTrainDataGuiServer.setTileEntityDataAndWriteUpdate((ServerPlayer)player, (T entity) -> entity.setData(messages, hideArrivals, platformIds), (BlockEntityMapper[])entities.toArray(new BlockPIDSBase.TileEntityBlockPIDSBase[0]));
        });
    }

    public static void receiveArrivalProjectorMessageC2S(MinecraftServer minecraftServer, ServerPlayer player, FriendlyByteBuf packet) {
        BlockPos pos = packet.m_130135_();
        int platformIdCount = packet.readInt();
        HashSet<Long> platformIds = new HashSet<Long>();
        for (int i = 0; i < platformIdCount; ++i) {
            platformIds.add(packet.readLong());
        }
        int displayPage = packet.readInt();
        minecraftServer.execute(() -> {
            BlockEntity entity = player.f_19853_.m_7702_(pos);
            if (entity instanceof BlockArrivalProjectorBase.TileEntityArrivalProjectorBase) {
                PacketTrainDataGuiServer.setTileEntityDataAndWriteUpdate((ServerPlayer)player, (T entity2) -> entity2.setData(platformIds, displayPage), (BlockEntityMapper[])new BlockArrivalProjectorBase.TileEntityArrivalProjectorBase[]{(BlockArrivalProjectorBase.TileEntityArrivalProjectorBase)entity});
            }
        });
    }

    public static void receiveUseTimeAndWindSyncC2S(MinecraftServer minecraftServer, ServerPlayer player, FriendlyByteBuf packet) {
        if (RailwayData.hasNoPermission(player) || !player.m_20310_(1)) {
            return;
        }
        Level world = player.f_19853_;
        RailwayData railwayData = RailwayData.getInstance(world);
        if (railwayData != null) {
            boolean useTimeAndWindSync = packet.readBoolean();
            minecraftServer.execute(() -> {
                boolean useTimeAndWindSyncOld = railwayData.getUseTimeAndWindSync();
                railwayData.setUseTimeAndWindSync(useTimeAndWindSync);
                String key = "\"use_time_and_wind_sync\":";
                railwayData.railwayDataLoggingModule.addEvent(player, RailwayData.class, Collections.singletonList("\"use_time_and_wind_sync\":" + useTimeAndWindSyncOld), Collections.singletonList("\"use_time_and_wind_sync\":" + useTimeAndWindSync), new BlockPos[0]);
            });
        }
    }

    public static void receiveRemoveRailAction(MinecraftServer minecraftServer, Player player, FriendlyByteBuf packet) {
        Level world = player.f_19853_;
        RailwayData railwayData = RailwayData.getInstance(world);
        if (railwayData != null) {
            long id = packet.readLong();
            minecraftServer.execute(() -> railwayData.railwayDataRailActionsModule.removeRailAction(id));
        }
    }

    public static void receiveUpdateTrainPassengerPosition(MinecraftServer minecraftServer, Player player, FriendlyByteBuf packet) {
        FriendlyByteBuf packetFullCopy = new FriendlyByteBuf(packet.copy());
        minecraftServer.execute(() -> player.f_19853_.m_6907_().forEach(sendPlayer -> {
            if (sendPlayer != player) {
                Registry.sendToPlayer((ServerPlayer)sendPlayer, PACKET_UPDATE_TRAIN_PASSENGER_POSITION, packetFullCopy);
            }
        }));
    }

    public static void receiveUpdateLiftPassengerPosition(MinecraftServer minecraftServer, Player player, FriendlyByteBuf packet) {
        FriendlyByteBuf packetFullCopy = new FriendlyByteBuf(packet.copy());
        minecraftServer.execute(() -> player.f_19853_.m_6907_().forEach(sendPlayer -> {
            if (sendPlayer != player) {
                Registry.sendToPlayer((ServerPlayer)sendPlayer, PACKET_UPDATE_LIFT_PASSENGER_POSITION, packetFullCopy);
            }
        }));
    }

    public static void receiveUpdateEntitySeatPassengerPosition(MinecraftServer minecraftServer, Player player, FriendlyByteBuf packet) {
        RailwayData railwayData = RailwayData.getInstance(player.f_19853_);
        if (railwayData != null) {
            double x = packet.readDouble();
            double y = packet.readDouble();
            double z = packet.readDouble();
            minecraftServer.execute(() -> railwayData.railwayDataCoolDownModule.moveSeat(player, x, y, z));
        }
    }

    private static <T extends SerializedDataBase> void serializeData(FriendlyByteBuf packet, Collection<T> objects) {
        packet.writeInt(objects.size());
        objects.forEach(object -> object.writePacket(packet));
    }

    private static boolean sendChunk(ServerPlayer player, FriendlyByteBuf packet, long tempPacketId, int chunk) {
        FriendlyByteBuf packetChunk = new FriendlyByteBuf(Unpooled.buffer());
        packetChunk.writeLong(tempPacketId);
        packetChunk.writeInt(chunk);
        boolean success = chunk * PACKET_CHUNK_SIZE > packet.readableBytes();
        packetChunk.writeBoolean(success);
        if (!success) {
            packetChunk.writeBytes(packet.copy(chunk * PACKET_CHUNK_SIZE, Math.min(PACKET_CHUNK_SIZE, packet.readableBytes() - chunk * PACKET_CHUNK_SIZE)));
        }
        try {
            Registry.sendToPlayer(player, PACKET_CHUNK_S2C, packetChunk);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return success;
    }

    @SafeVarargs
    private static <T extends BlockEntityMapper> void setTileEntityDataAndWriteUpdate(ServerPlayer player, Consumer<T> setData, T ... entities) {
        RailwayData railwayData = RailwayData.getInstance(player.f_19853_);
        if (railwayData != null && entities.length > 0) {
            CompoundTag compoundTagOld = new CompoundTag();
            ((BlockEntityMapper)((Object)entities[0])).writeCompoundTag(compoundTagOld);
            BlockPos blockPos = null;
            long posLong = 0L;
            for (T entity : entities) {
                setData.accept(entity);
                BlockPos entityPos = entity.m_58899_();
                if (blockPos != null && entityPos.m_121878_() <= posLong) continue;
                blockPos = entityPos;
                posLong = entityPos.m_121878_();
            }
            CompoundTag compoundTagNew = new CompoundTag();
            ((BlockEntityMapper)((Object)entities[0])).writeCompoundTag(compoundTagNew);
            railwayData.railwayDataLoggingModule.addEvent(player, entities[0].getClass(), RailwayDataLoggingModule.getData(compoundTagOld), RailwayDataLoggingModule.getData(compoundTagNew), blockPos);
        }
    }
}

