/*
 * Decompiled with CFR 0.152.
 */
package mtr.packet;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import mtr.data.AreaBase;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.packet.IUpdateWebMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerSet;

public class UpdateDynmap
implements IGui,
IUpdateWebMap {
    private static DynmapCommonAPI dynmapCommonAPI;

    public static void updateDynmap(Level world, RailwayData railwayData) {
        try {
            UpdateDynmap.updateDynmap(world, railwayData.stations, "mtr_stations", "Stations", "mtr_station_areas", "Station Areas", "mtr_station");
            UpdateDynmap.updateDynmap(world, railwayData.depots, "mtr_depots", "Depots", "mtr_depot_areas", "Depot Areas", "mtr_depot");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static <T extends AreaBase> void updateDynmap(Level world, Set<T> areas, String areasId, String areasTitle, String areaAreasId, String areaAreasTitle, String iconKey) {
        if (dynmapCommonAPI != null) {
            String worldId = switch (world.m_46472_().m_135782_().toString()) {
                case "minecraft:overworld" -> {
                    MinecraftServer minecraftServer = world.m_7654_();
                    yield minecraftServer == null ? "world" : minecraftServer.m_129910_().m_5462_();
                }
                case "minecraft:the_nether" -> "DIM-1";
                case "minecraft:the_end" -> "DIM1";
                default -> world.m_46472_().m_135782_().m_135815_();
            };
            int areaY = world.m_5736_();
            MarkerAPI markerAPI = dynmapCommonAPI.getMarkerAPI();
            MarkerSet tempMarkerSetAreas = markerAPI.getMarkerSet(areasId);
            MarkerSet markerSetAreas = tempMarkerSetAreas == null ? markerAPI.createMarkerSet(areasId, areasTitle, Collections.singleton(markerAPI.getMarkerIcon(iconKey)), false) : tempMarkerSetAreas;
            markerSetAreas.getMarkers().forEach(marker -> {
                if (marker.getMarkerID().startsWith(worldId)) {
                    marker.deleteMarker();
                }
            });
            MarkerSet tempMarkerSetAreaAreas = markerAPI.getMarkerSet(areaAreasId);
            MarkerSet markerSetAreaAreas = tempMarkerSetAreaAreas == null ? markerAPI.createMarkerSet(areaAreasId, areaAreasTitle, new HashSet(), false) : tempMarkerSetAreaAreas;
            markerSetAreaAreas.setHideByDefault(true);
            markerSetAreaAreas.getAreaMarkers().forEach(marker -> {
                if (marker.getMarkerID().startsWith(worldId)) {
                    marker.deleteMarker();
                }
            });
            IUpdateWebMap.iterateAreas(areas, (id, name, color, areaCorner1X, areaCorner1Z, areaCorner2X, areaCorner2Z, areaX, areaZ) -> {
                markerSetAreas.createMarker(worldId + id, name, worldId, (double)areaX, (double)areaY, (double)areaZ, markerAPI.getMarkerIcon(iconKey), false);
                AreaMarker areaMarker = markerSetAreaAreas.createAreaMarker(worldId + id, name, false, worldId, new double[]{areaCorner1X, areaCorner2X}, new double[]{areaCorner1Z, areaCorner2Z}, false);
                areaMarker.setFillStyle(0.5, color.getRGB() & 0xFFFFFF);
                areaMarker.setLineStyle(1, 1.0, color.darker().getRGB() & 0xFFFFFF);
            });
        }
    }

    static {
        try {
            DynmapCommonAPIListener.register((DynmapCommonAPIListener)new DynmapCommonAPIListener(){

                public void apiEnabled(DynmapCommonAPI dynmapCommonAPI) {
                    UpdateDynmap.dynmapCommonAPI = dynmapCommonAPI;
                    try {
                        MarkerAPI markerAPI = dynmapCommonAPI.getMarkerAPI();
                        IUpdateWebMap.readResource("/assets/mtr/textures/block/sign/logo.png", inputStream -> markerAPI.createMarkerIcon("mtr_station", "mtr_station", inputStream));
                        IUpdateWebMap.readResource("/assets/mtr/textures/block/sign/logo_grayscale.png", inputStream -> markerAPI.createMarkerIcon("mtr_depot", "mtr_depot", inputStream));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

