/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mtr.block.BlockClock;
import mtr.block.IBlock;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.UtilitiesClient;
import mtr.render.MoreRenderLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class RenderClock
extends BlockEntityRendererMapper<BlockClock.TileEntityClock>
implements IGui,
IBlock {
    public RenderClock(BlockEntityRenderDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(BlockClock.TileEntityClock entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        Level world = entity.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.m_58899_();
        BlockState state = world.m_8055_(pos);
        boolean rotated = (Boolean)IBlock.getStatePropertySafe(state, BlockClock.FACING);
        matrices.m_85836_();
        matrices.m_85837_(0.5, 0.3125, 0.5);
        if (rotated) {
            UtilitiesClient.rotateYDegrees(matrices, 90.0f);
        }
        long time = world.m_46468_() + 6000L;
        RenderClock.drawHand(matrices, vertexConsumers, (float)time * 360.0f / 12000.0f, true);
        RenderClock.drawHand(matrices, vertexConsumers, (float)time * 360.0f / 1000.0f, false);
        UtilitiesClient.rotateYDegrees(matrices, 180.0f);
        RenderClock.drawHand(matrices, vertexConsumers, (float)time * 360.0f / 12000.0f, true);
        RenderClock.drawHand(matrices, vertexConsumers, (float)time * 360.0f / 1000.0f, false);
        matrices.m_85849_();
    }

    private static void drawHand(PoseStack matrices, MultiBufferSource vertexConsumers, float rotation, boolean isHourHand) {
        matrices.m_85836_();
        UtilitiesClient.rotateZDegrees(matrices, -rotation);
        VertexConsumer vertexConsumer = vertexConsumers.m_6299_(MoreRenderLayers.getLight(new ResourceLocation("mtr:textures/block/white.png"), false));
        IDrawing.drawTexture(matrices, vertexConsumer, -0.01f, isHourHand ? 0.15f : 0.24f, isHourHand ? 0.1f : 0.105f, 0.01f, -0.03f, isHourHand ? 0.1f : 0.105f, Direction.UP, -5592406, 0xF000B0);
        matrices.m_85849_();
    }
}

