/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import mtr.MTRClient;
import mtr.block.BlockLiftPanelBase;
import mtr.block.BlockLiftTrackFloor;
import mtr.block.IBlock;
import mtr.block.ITripleBlock;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.Lift;
import mtr.item.ItemLiftButtonsLinkModifier;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderLiftButtons;
import mtr.render.RenderTrains;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;

public class RenderLiftPanel<T extends BlockLiftPanelBase.TileEntityLiftPanel1Base>
extends BlockEntityRendererMapper<T> {
    private final boolean isOdd;
    private final boolean isFlat;
    private static final ResourceLocation ARROW_TEXTURE = new ResourceLocation("mtr:textures/block/lift_arrow.png");
    private static final float ARROW_SPEED = 0.04f;
    private static final int SLIDE_TIME = 5;
    private static final int SLIDE_INTERVAL = 50;
    private static final float PANEL_WIDTH = 1.125f;

    public RenderLiftPanel(BlockEntityRenderDispatcher dispatcher, boolean isOdd, boolean isFlat) {
        super(dispatcher);
        this.isOdd = isOdd;
        this.isFlat = isFlat;
    }

    public void render(T entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int combinedOverlay) {
        Level world = entity.m_58904_();
        if (world == null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        BlockPos pos = entity.m_58899_();
        if (RenderTrains.shouldNotRender(pos, RenderTrains.maxTrainRenderDistance, null)) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        if (!this.isOdd && IBlock.getStatePropertySafe(state, IBlock.SIDE) == IBlock.EnumSide.RIGHT || this.isOdd && !((Boolean)IBlock.getStatePropertySafe(state, ITripleBlock.ODD)).booleanValue()) {
            return;
        }
        Font textRenderer = Minecraft.m_91087_().f_91062_;
        if (textRenderer == null) {
            return;
        }
        BlockPos trackPosition = ((BlockLiftPanelBase.TileEntityLiftPanel1Base)entity).getTrackPosition(world);
        if (trackPosition == null) {
            return;
        }
        BlockLiftTrackFloor.TileEntityLiftTrackFloor trackFloorTileEntity = (BlockLiftTrackFloor.TileEntityLiftTrackFloor)world.m_7702_(trackPosition);
        if (trackFloorTileEntity == null) {
            return;
        }
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, HorizontalDirectionalBlock.f_54117_);
        boolean holdingLinker = Utilities.isHolding((Player)player, item -> item instanceof ItemLiftButtonsLinkModifier || Block.m_49814_((Item)item) instanceof BlockLiftPanelBase);
        matrices.m_85836_();
        matrices.m_85837_(0.5, 0.0, 0.5);
        RenderLiftButtons.renderLiftObjectLink(matrices, vertexConsumers, world, pos, trackPosition, facing, holdingLinker);
        Lift lift = null;
        for (Lift lift2 : ClientData.LIFTS) {
            if (!lift2.hasFloor(trackPosition)) continue;
            lift = lift2;
            break;
        }
        if (lift != null) {
            String[] text = ClientData.DATA_CACHE.requestLiftFloorText(lift.getCurrentFloorBlockPos());
            UtilitiesClient.rotateYDegrees(matrices, -facing.m_122435_());
            UtilitiesClient.rotateZDegrees(matrices, 180.0f);
            matrices.m_85837_(this.isOdd ? 0.0 : 0.5, 0.0, 0.0);
            matrices.m_85836_();
            matrices.m_252880_(0.0f, 0.0f, (this.isFlat ? 0.4375f : 0.25f) - 0.00625f);
            MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            IDrawing.drawStringWithFont(matrices, textRenderer, bufferSource, ClientData.DATA_CACHE.requestLiftFloorText(trackPosition)[0], IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0.0f, -0.47f, 0.1875f, 0.1875f, 1.0f, -16777216, false, 0xF000F0, null);
            bufferSource.m_109911_();
            matrices.m_85849_();
            this.renderLiftDisplay(matrices, vertexConsumers, this.isFlat ? 0.4375f : 0.25f, text[0], text[1], lift.getLiftDirection());
        }
        matrices.m_85849_();
    }

    private void renderLiftDisplay(PoseStack matrices, MultiBufferSource vertexConsumers, float zOffset, String floorNumber, String floorDisplay, Lift.LiftDirection liftDirection) {
        matrices.m_85836_();
        matrices.m_252880_(0.0f, 0.0f, zOffset - 0.00625f);
        boolean noFloorNumber = floorNumber.isEmpty();
        boolean noFloorDisplay = floorDisplay.isEmpty();
        int lineCount = (noFloorNumber ? 0 : floorNumber.split("\\|").length) + (noFloorDisplay ? 0 : floorDisplay.split("\\|").length);
        float lineHeight = 1.0f / (float)lineCount;
        float gameTick = MTRClient.getGameTick();
        boolean goingUp = liftDirection == Lift.LiftDirection.UP;
        float arrowSize = 0.1875f;
        float y = -0.3125f;
        if (liftDirection != Lift.LiftDirection.NONE) {
            float uv = gameTick * 0.04f % 1.0f;
            int color = goingUp ? -16711936 : -65536;
            IDrawing.drawTexture(matrices, vertexConsumers.m_6299_(MoreRenderLayers.getLight(ARROW_TEXTURE, false)), -0.75f, -0.3125f, 0.1875f, 0.1875f, 0.0f, (float)(!goingUp ? 1 : 0) + uv, 1.0f, (float)(goingUp ? 1 : 0) + uv, Direction.UP, color, 0xF000F0);
            IDrawing.drawTexture(matrices, vertexConsumers.m_6299_(MoreRenderLayers.getLight(ARROW_TEXTURE, false)), 0.5625f, -0.3125f, 0.1875f, 0.1875f, 0.0f, (float)(!goingUp ? 1 : 0) + uv, 1.0f, (float)(goingUp ? 1 : 0) + uv, Direction.UP, color, 0xF000F0);
        }
        if (!noFloorNumber || !noFloorDisplay) {
            float uvOffset = 0.0f;
            if (lineCount > 1) {
                uvOffset = (float)Math.floor(gameTick % (float)(50 * lineCount) / 50.0f) * lineHeight;
                if (gameTick % 50.0f > 45.0f) {
                    uvOffset += lineHeight * (gameTick % 50.0f - 50.0f + 5.0f) / 5.0f;
                }
            }
            float uv = (float)(goingUp ? -1 : 1) * uvOffset;
            String text = String.format("%s%s%s", floorNumber, noFloorNumber || noFloorDisplay ? "" : "|", floorDisplay);
            IDrawing.drawTexture(matrices, vertexConsumers.m_6299_(MoreRenderLayers.getLight(ClientData.DATA_CACHE.getLiftPanelDisplay((String)text, (int)0xFFAA00).resourceLocation, false)), -0.5625f, -0.3125f, 1.125f, 0.1875f, 0.0f, uv, 1.0f, lineHeight + uv, Direction.UP, -1, 0xF000F0);
        }
        matrices.m_85849_();
    }
}

