/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mtr.block.BlockRailwaySign;
import mtr.block.BlockStationNameBase;
import mtr.block.IBlock;
import mtr.client.ClientCache;
import mtr.client.ClientData;
import mtr.client.CustomResources;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.Station;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.UtilitiesClient;
import mtr.render.RenderTrains;
import mtr.render.StoredMatrixTransformations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class RenderRailwaySign<T extends BlockRailwaySign.TileEntityRailwaySign>
extends BlockEntityRendererMapper<T>
implements IBlock,
IGui,
IDrawing {
    public RenderRailwaySign(BlockEntityRenderDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(T entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        Level world = entity.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.m_58899_();
        BlockState state = world.m_8055_(pos);
        if (!(state.m_60734_() instanceof BlockRailwaySign)) {
            return;
        }
        BlockRailwaySign block = (BlockRailwaySign)state.m_60734_();
        if (((BlockRailwaySign.TileEntityRailwaySign)((Object)entity)).getSignIds().length != block.length) {
            return;
        }
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, BlockStationNameBase.f_54117_);
        String[] signIds = ((BlockRailwaySign.TileEntityRailwaySign)((Object)entity)).getSignIds();
        boolean renderBackground = false;
        int backgroundColor = 0;
        for (String signId : signIds) {
            CustomResources.CustomSign sign;
            if (signId == null || (sign = RenderRailwaySign.getSign(signId)) == null) continue;
            renderBackground = true;
            if (sign.backgroundColor == 0) continue;
            backgroundColor = sign.backgroundColor;
            break;
        }
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations();
        storedMatrixTransformations.add(matricesNew -> {
            matricesNew.m_85837_(0.5 + (double)entity.m_58899_().m_123341_(), 0.53125 + (double)entity.m_58899_().m_123342_(), 0.5 + (double)entity.m_58899_().m_123343_());
            UtilitiesClient.rotateYDegrees(matricesNew, -facing.m_122435_());
            UtilitiesClient.rotateZDegrees(matricesNew, 180.0f);
            matricesNew.m_85837_((double)((float)block.getXStart() / 16.0f) - 0.5, 0.0, -0.06875000009313226);
        });
        matrices.m_85836_();
        matrices.m_85837_(0.5, 0.53125, 0.5);
        UtilitiesClient.rotateYDegrees(matrices, -facing.m_122435_());
        UtilitiesClient.rotateZDegrees(matrices, 180.0f);
        matrices.m_85837_((double)((float)block.getXStart() / 16.0f) - 0.5, 0.0, -0.06875000009313226);
        if (renderBackground) {
            int newBackgroundColor = backgroundColor | 0xFF000000;
            RenderTrains.scheduleRender(new ResourceLocation("mtr:textures/block/white.png"), false, RenderTrains.QueuedRenderLayer.LIGHT, (matricesNew, vertexConsumer) -> {
                storedMatrixTransformations.transform((PoseStack)matricesNew);
                IDrawing.drawTexture(matricesNew, vertexConsumer, 0.0f, 0.0f, 0.003125f, 0.5f * (float)signIds.length, 0.5f, 0.003125f, facing, newBackgroundColor, 0xF000F0);
                matricesNew.m_85849_();
            });
        }
        for (int i = 0; i < signIds.length; ++i) {
            if (signIds[i] == null) continue;
            RenderRailwaySign.drawSign(matrices, vertexConsumers, storedMatrixTransformations, Minecraft.m_91087_().f_91062_, pos, signIds[i], 0.5f * (float)i, 0.0f, 0.5f, RenderRailwaySign.getMaxWidth(signIds, i, false), RenderRailwaySign.getMaxWidth(signIds, i, true), ((BlockRailwaySign.TileEntityRailwaySign)((Object)entity)).getSelectedIds(), facing, backgroundColor | 0xFF000000, (textureId, x, y, size, flipTexture) -> RenderTrains.scheduleRender(new ResourceLocation(textureId.toString()), true, RenderTrains.QueuedRenderLayer.LIGHT_TRANSLUCENT, (matricesNew, vertexConsumer) -> {
                storedMatrixTransformations.transform((PoseStack)matricesNew);
                IDrawing.drawTexture(matricesNew, vertexConsumer, x, y, size, size, flipTexture ? 1.0f : 0.0f, 0.0f, flipTexture ? 0.0f : 1.0f, 1.0f, facing, -1, 0xF000F0);
                matricesNew.m_85849_();
            }));
        }
        matrices.m_85849_();
    }

    public boolean shouldRenderOffScreen(T blockEntity) {
        return true;
    }

    public static void drawSign(PoseStack matrices, MultiBufferSource vertexConsumers, StoredMatrixTransformations storedMatrixTransformations, Font textRenderer, BlockPos pos, String signId, float x, float y, float size, float maxWidthLeft, float maxWidthRight, Set<Long> selectedIds, Direction facing, int backgroundColor, DrawTexture drawTexture) {
        MultiBufferSource.BufferSource immediate;
        if (RenderTrains.shouldNotRender(pos, RenderTrains.maxTrainRenderDistance, facing)) {
            return;
        }
        CustomResources.CustomSign sign = RenderRailwaySign.getSign(signId);
        if (sign == null) {
            return;
        }
        float signSize = (sign.small ? 0.75f : 1.0f) * size;
        float margin = (size - signSize) / 2.0f;
        boolean hasCustomText = sign.hasCustomText();
        boolean flipCustomText = sign.flipCustomText;
        boolean flipTexture = sign.flipTexture;
        boolean isExit = signId.equals(BlockRailwaySign.SignType.EXIT_LETTER.toString()) || signId.equals(BlockRailwaySign.SignType.EXIT_LETTER_FLIPPED.toString());
        boolean isLine = signId.equals(BlockRailwaySign.SignType.LINE.toString()) || signId.equals(BlockRailwaySign.SignType.LINE_FLIPPED.toString());
        boolean isPlatform = signId.equals(BlockRailwaySign.SignType.PLATFORM.toString()) || signId.equals(BlockRailwaySign.SignType.PLATFORM_FLIPPED.toString());
        boolean isStation = signId.equals(BlockRailwaySign.SignType.STATION.toString()) || signId.equals(BlockRailwaySign.SignType.STATION_FLIPPED.toString());
        MultiBufferSource.BufferSource bufferSource = immediate = RenderTrains.shouldNotRender(pos, RenderTrains.maxTrainRenderDistance / 2, null) ? null : MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        if (vertexConsumers != null && isExit) {
            Station station = RailwayData.getStation(ClientData.STATIONS, ClientData.DATA_CACHE, pos);
            if (station == null) {
                return;
            }
            Map<String, List<String>> exits = station.getGeneratedExits();
            List selectedExitsSorted = selectedIds.stream().map(Station::deserializeExit).filter(exits::containsKey).sorted(String::compareTo).collect(Collectors.toList());
            matrices.m_85836_();
            matrices.m_252880_(x + margin + (flipCustomText ? signSize : 0.0f), y + margin, 0.0f);
            float maxWidth = ((flipCustomText ? maxWidthLeft : maxWidthRight) + 1.0f) * size - margin * 2.0f;
            float exitWidth = signSize * (float)selectedExitsSorted.size();
            matrices.m_85841_(Math.min(1.0f, maxWidth / exitWidth), 1.0f, 1.0f);
            for (int i = 0; i < selectedExitsSorted.size(); ++i) {
                String selectedExit = (String)selectedExitsSorted.get(flipCustomText ? selectedExitsSorted.size() - i - 1 : i);
                float offset = (float)(flipCustomText ? -1 : 1) * signSize * (float)i - (flipCustomText ? signSize : 0.0f);
                RenderTrains.scheduleRender(ClientData.DATA_CACHE.getExitSignLetter((String)selectedExit.substring((int)0, (int)1), (String)selectedExit.substring((int)1), (int)backgroundColor).resourceLocation, true, RenderTrains.QueuedRenderLayer.LIGHT_TRANSLUCENT, (matricesNew, vertexConsumer) -> {
                    storedMatrixTransformations.transform((PoseStack)matricesNew);
                    matricesNew.m_252880_(x + margin + (flipCustomText ? signSize : 0.0f), y + margin, 0.0f);
                    matricesNew.m_85841_(Math.min(1.0f, maxWidth / exitWidth), 1.0f, 1.0f);
                    IDrawing.drawTexture(matricesNew, vertexConsumer, offset, 0.0f, signSize, signSize, facing, 0xF000F0);
                    matricesNew.m_85849_();
                });
                if (!(maxWidth > exitWidth) || selectedExitsSorted.size() != 1 || exits.get(selectedExit).isEmpty()) continue;
                RenderRailwaySign.renderCustomText(exits.get(selectedExit).get(0), storedMatrixTransformations, facing, size, flipCustomText ? x : x + size, flipCustomText, maxWidth - exitWidth - margin * 2.0f, backgroundColor);
            }
            matrices.m_85849_();
        } else if (vertexConsumers != null && isLine) {
            Station station = RailwayData.getStation(ClientData.STATIONS, ClientData.DATA_CACHE, pos);
            if (station == null) {
                return;
            }
            Map<Integer, ClientCache.ColorNameTuple> routesInStation = ClientData.DATA_CACHE.getAllRoutesIncludingConnectingStations(station);
            List selectedIdsSorted = selectedIds.stream().filter(selectedId -> RailwayData.isBetween(selectedId.longValue(), -2.147483648E9, 2.147483647E9)).map(Math::toIntExact).filter(routesInStation::containsKey).map(routesInStation::get).sorted(Comparator.comparingInt(route -> route.color)).collect(Collectors.toList());
            float maxWidth = Math.max(0.0f, ((flipCustomText ? maxWidthLeft : maxWidthRight) + 1.0f) * size - margin * 2.0f);
            float height = size - margin * 2.0f;
            ArrayList<ClientCache.DynamicResource> resourceLocationDataList = new ArrayList<ClientCache.DynamicResource>();
            float totalTextWidth = 0.0f;
            for (ClientCache.ColorNameTuple route2 : selectedIdsSorted) {
                ClientCache.DynamicResource resourceLocationData = ClientData.DATA_CACHE.getRouteSquare(route2.color, route2.name, flipCustomText ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.LEFT);
                resourceLocationDataList.add(resourceLocationData);
                totalTextWidth += height * (float)resourceLocationData.width / (float)resourceLocationData.height + margin / 2.0f;
            }
            StoredMatrixTransformations storedMatrixTransformations2 = storedMatrixTransformations.copy();
            storedMatrixTransformations2.add(matricesNew -> matricesNew.m_252880_(flipCustomText ? x + size - margin : x + margin, 0.0f, 0.0f));
            if (totalTextWidth > margin / 2.0f) {
                totalTextWidth -= margin / 2.0f;
            }
            if (totalTextWidth > maxWidth) {
                float finalTotalTextWidth = totalTextWidth;
                storedMatrixTransformations2.add(matricesNew -> matricesNew.m_85841_(maxWidth / finalTotalTextWidth, 1.0f, 1.0f));
            }
            float xOffset = 0.0f;
            for (ClientCache.DynamicResource resourceLocationData : resourceLocationDataList) {
                float width = height * (float)resourceLocationData.width / (float)resourceLocationData.height;
                float finalXOffset = xOffset;
                RenderTrains.scheduleRender(resourceLocationData.resourceLocation, true, RenderTrains.QueuedRenderLayer.LIGHT, (matricesNew, vertexConsumer) -> {
                    storedMatrixTransformations2.transform((PoseStack)matricesNew);
                    IDrawing.drawTexture(matricesNew, vertexConsumer, flipCustomText ? -finalXOffset - width : finalXOffset, margin, width, height, Direction.UP, 0xF000F0);
                    matricesNew.m_85849_();
                });
                xOffset += width + margin / 2.0f;
            }
        } else if (vertexConsumers != null && isPlatform) {
            Station station = RailwayData.getStation(ClientData.STATIONS, ClientData.DATA_CACHE, pos);
            if (station == null) {
                return;
            }
            Map<Long, Platform> platformPositions = ClientData.DATA_CACHE.requestStationIdToPlatforms(station.id);
            if (platformPositions != null) {
                List selectedIdsSorted = selectedIds.stream().filter(platformPositions::containsKey).sorted(Comparator.comparing(platformPositions::get)).collect(Collectors.toList());
                int selectedCount = selectedIdsSorted.size();
                float extraMargin = margin - margin / (float)selectedCount;
                float height = (size - extraMargin * 2.0f) / (float)selectedCount;
                for (int i = 0; i < selectedIdsSorted.size(); ++i) {
                    float topOffset = (float)i * height + extraMargin;
                    float bottomOffset = (float)(i + 1) * height + extraMargin;
                    float left = flipCustomText ? x - maxWidthLeft * size : x + margin;
                    float right = flipCustomText ? x + size - margin : x + (maxWidthRight + 1.0f) * size;
                    RenderTrains.scheduleRender(ClientData.DATA_CACHE.getDirectionArrow((long)((Long)selectedIdsSorted.get((int)i)).longValue(), (boolean)false, (boolean)false, (IGui.HorizontalAlignment)(flipCustomText ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.LEFT), (boolean)false, (float)(margin / size), (float)((right - left) / (bottomOffset - topOffset)), (int)backgroundColor, (int)-1, (int)backgroundColor).resourceLocation, true, RenderTrains.QueuedRenderLayer.LIGHT_TRANSLUCENT, (matricesNew, vertexConsumer) -> {
                        storedMatrixTransformations.transform((PoseStack)matricesNew);
                        IDrawing.drawTexture(matricesNew, vertexConsumer, left, topOffset, 0.0f, right, bottomOffset, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, facing, -1, 0xF000F0);
                        matricesNew.m_85849_();
                    });
                }
            }
        } else {
            drawTexture.drawTexture(sign.textureId, x + margin, y + margin, signSize, flipTexture);
            if (hasCustomText) {
                float start;
                float fixedMargin = size * 0.25f / 2.0f;
                boolean isSmall = sign.small;
                float maxWidth = Math.max(0.0f, (flipCustomText ? maxWidthLeft : maxWidthRight) * size - fixedMargin * (float)(isSmall ? 1 : 2));
                float f = flipCustomText ? x - (isSmall ? 0.0f : fixedMargin) : (start = x + size + (isSmall ? 0.0f : fixedMargin));
                if (vertexConsumers == null) {
                    IDrawing.drawStringWithFont(matrices, textRenderer, immediate, isExit || isLine ? "..." : sign.customText, flipCustomText ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.TOP, start, y + fixedMargin, maxWidth, size - fixedMargin * 2.0f, 0.01f, -1, false, 0xF000F0, null);
                } else {
                    String signText = isStation ? IGui.mergeStations(selectedIds.stream().filter(ClientData.DATA_CACHE.stationIdMap::containsKey).sorted(Long::compareTo).map(stationId -> IGui.insertTranslation("gui.mtr.station_cjk", "gui.mtr.station", 1, ((Station)ClientData.DATA_CACHE.stationIdMap.get((Object)stationId)).name)).collect(Collectors.toList())) : sign.customText;
                    RenderRailwaySign.renderCustomText(signText, storedMatrixTransformations, facing, size, start, flipCustomText, maxWidth, backgroundColor);
                }
            }
        }
        if (immediate != null) {
            immediate.m_109911_();
        }
    }

    private static void renderCustomText(String signText, StoredMatrixTransformations storedMatrixTransformations, Direction facing, float size, float start, boolean flipCustomText, float maxWidth, int backgroundColor) {
        ClientCache.DynamicResource dynamicResource = ClientData.DATA_CACHE.getSignText(signText, flipCustomText ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.LEFT, 0.125f, backgroundColor, -1);
        float width = Math.min(size * (float)dynamicResource.width / (float)dynamicResource.height, maxWidth);
        RenderTrains.scheduleRender(dynamicResource.resourceLocation, true, RenderTrains.QueuedRenderLayer.LIGHT_TRANSLUCENT, (matricesNew, vertexConsumer) -> {
            storedMatrixTransformations.transform((PoseStack)matricesNew);
            IDrawing.drawTexture(matricesNew, vertexConsumer, start - (flipCustomText ? width : 0.0f), 0.0f, 0.0f, start + (flipCustomText ? 0.0f : width), size, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, facing, -1, 0xF000F0);
            matricesNew.m_85849_();
        });
    }

    public static CustomResources.CustomSign getSign(String signId) {
        try {
            BlockRailwaySign.SignType sign = BlockRailwaySign.SignType.valueOf(signId);
            return new CustomResources.CustomSign(sign.textureId, sign.flipTexture, sign.customText, sign.flipCustomText, sign.small, sign.backgroundColor);
        }
        catch (Exception ignored) {
            return signId == null ? null : CustomResources.CUSTOM_SIGNS.get(signId);
        }
    }

    public static float getMaxWidth(String[] signIds, int index, boolean right) {
        float maxWidthLeft = 0.0f;
        int i = index + (right ? 1 : -1);
        while (right ? i < signIds.length : i >= 0) {
            if (signIds[i] != null) {
                CustomResources.CustomSign sign = RenderRailwaySign.getSign(signIds[i]);
                if (sign != null && sign.hasCustomText() && right == sign.flipCustomText) {
                    maxWidthLeft /= 2.0f;
                }
                return maxWidthLeft;
            }
            maxWidthLeft += 1.0f;
            i += right ? 1 : -1;
        }
        return maxWidthLeft;
    }

    @FunctionalInterface
    public static interface DrawTexture {
        public void drawTexture(ResourceLocation var1, float var2, float var3, float var4, boolean var5);
    }
}

