/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import mtr.MTRClient;
import mtr.client.Config;
import mtr.data.RailwayData;
import mtr.data.TrainClient;
import mtr.entity.EntitySeat;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import mtr.render.RenderTrains;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class TrainRendererBase {
    protected static Camera camera;
    protected static Level world;
    protected static float lastFrameDuration;
    protected static PoseStack matrices;
    protected static MultiBufferSource vertexConsumers;
    protected static boolean isTranslucentBatch;
    private static Entity cameraEntity;
    private static boolean hasEntity;
    private static double entityX;
    private static double entityY;
    private static double entityZ;
    private static EntityRenderDispatcher entityRenderDispatcher;
    private static LocalPlayer player;
    private static Vec3 playerEyePosition;

    public abstract TrainRendererBase createTrainInstance(TrainClient var1);

    public abstract void renderCar(int var1, double var2, double var4, double var6, float var8, float var9, boolean var10, boolean var11);

    public abstract void renderConnection(Vec3 var1, Vec3 var2, Vec3 var3, Vec3 var4, Vec3 var5, Vec3 var6, Vec3 var7, Vec3 var8, double var9, double var11, double var13, float var15, float var16);

    public abstract void renderBarrier(Vec3 var1, Vec3 var2, Vec3 var3, Vec3 var4, Vec3 var5, Vec3 var6, Vec3 var7, Vec3 var8, double var9, double var11, double var13, float var15, float var16);

    public static void renderRidingPlayer(Vec3 viewOffset, UUID playerId, Vec3 playerPositionOffset) {
        BlockPos posAverage = TrainRendererBase.applyAverageTransform(viewOffset, playerPositionOffset.f_82479_, playerPositionOffset.f_82480_, playerPositionOffset.f_82481_);
        if (posAverage == null) {
            return;
        }
        matrices.m_252880_(0.0f, 1000.0f, 0.0f);
        Player renderPlayer = world.m_46003_(playerId);
        if (renderPlayer != null && (!playerId.equals(player.m_20148_()) || camera.m_90594_())) {
            entityRenderDispatcher.m_114384_((Entity)renderPlayer, playerPositionOffset.f_82479_, playerPositionOffset.f_82480_, playerPositionOffset.f_82481_, 0.0f, 1.0f, matrices, vertexConsumers, 0xF000F0);
        }
        matrices.m_85849_();
    }

    public static void setupStaticInfo(PoseStack matrices, MultiBufferSource vertexConsumers, EntitySeat entity, float tickDelta) {
        Minecraft client = Minecraft.m_91087_();
        camera = client.f_91063_.m_109153_();
        entityRenderDispatcher = client.m_91290_();
        world = client.f_91073_;
        player = client.f_91074_;
        lastFrameDuration = MTRClient.getLastFrameDuration();
        TrainRendererBase.matrices = matrices;
        TrainRendererBase.vertexConsumers = vertexConsumers;
        cameraEntity = client.f_91075_;
        hasEntity = entity != null;
        entityX = hasEntity ? Mth.m_14139_((double)tickDelta, (double)entity.f_19790_, (double)entity.m_20185_()) : 0.0;
        entityY = hasEntity ? Mth.m_14139_((double)tickDelta, (double)entity.f_19791_, (double)entity.m_20186_()) : 0.0;
        entityZ = hasEntity ? Mth.m_14139_((double)tickDelta, (double)entity.f_19792_, (double)entity.m_20189_()) : 0.0;
        playerEyePosition = player == null ? Vec3.f_82478_ : player.m_20299_(client.m_91296_());
    }

    public static void setBatch(boolean isTranslucentBatch) {
        TrainRendererBase.isTranslucentBatch = isTranslucentBatch;
    }

    public static BlockPos applyAverageTransform(Vec3 viewOffset, double x, double y, double z) {
        boolean noOffset = viewOffset == null;
        Vec3 cameraPos = cameraEntity == null ? null : cameraEntity.m_20182_();
        BlockPos posAverage = RailwayData.newBlockPos(x + (noOffset || cameraPos == null ? 0.0 : cameraPos.f_82479_), y + (noOffset || cameraPos == null ? 0.0 : cameraPos.f_82480_), z + (noOffset || cameraPos == null ? 0.0 : cameraPos.f_82481_));
        if (RenderTrains.shouldNotRender(posAverage, UtilitiesClient.getRenderDistance() * (Config.trainRenderDistanceRatio() + 1), null)) {
            return null;
        }
        matrices.m_85836_();
        if (viewOffset != null) {
            double offsetZ;
            double offsetY;
            double offsetX;
            if (MTRClient.isVivecraft() && hasEntity) {
                offsetX = entityX;
                offsetY = entityY;
                offsetZ = entityZ;
            } else {
                Vec3 cameraOffset = camera.m_90594_() ? playerEyePosition : camera.m_90583_();
                offsetX = cameraOffset.f_82479_;
                offsetY = cameraOffset.f_82480_;
                offsetZ = cameraOffset.f_82481_;
            }
            float cameraYaw = camera.m_90590_();
            matrices.m_85837_(offsetX, offsetY, offsetZ);
            UtilitiesClient.rotateYDegrees(matrices, Utilities.getYaw((Entity)player) - cameraYaw + (float)(Math.abs(Utilities.getYaw((Entity)player) - cameraYaw) > 90.0f ? 180 : 0));
            matrices.m_85837_(-viewOffset.f_82479_, -viewOffset.f_82480_, -viewOffset.f_82481_);
        }
        return posAverage;
    }
}

