/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Locale;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.Lift;
import mtr.data.LiftClient;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.WidgetBetterCheckbox;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class LiftCustomizationScreen
extends ScreenMapper
implements IGui,
IPacket {
    private final LiftClient lift;
    private final Button buttonHeightMinus;
    private final Button buttonHeightAdd;
    private final Button buttonWidthMinus;
    private final Button buttonWidthAdd;
    private final Button buttonDepthMinus;
    private final Button buttonDepthAdd;
    private final Button buttonOffsetXMinus;
    private final Button buttonOffsetXAdd;
    private final Button buttonOffsetYMinus;
    private final Button buttonOffsetYAdd;
    private final Button buttonOffsetZMinus;
    private final Button buttonOffsetZAdd;
    private final WidgetBetterCheckbox buttonIsDoubleSided;
    private final Button buttonLiftStyle;
    private final Button buttonRotateAnticlockwise;
    private final Button buttonRotateClockwise;
    private final int width1;
    private final int width2;
    private static final int MIN_DIMENSION = 2;
    private static final int MAX_DIMENSION = 16;
    private static final int MAX_OFFSET = 16;

    public LiftCustomizationScreen(LiftClient lift) {
        super((Component)Text.literal(""));
        this.lift = lift;
        this.buttonHeightMinus = UtilitiesClient.newButton((Component)Text.literal("-"), button -> {
            lift.liftHeight = Math.max(4, lift.liftHeight - 1);
            this.updateControls();
        });
        this.buttonHeightAdd = UtilitiesClient.newButton((Component)Text.literal("+"), button -> {
            lift.liftHeight = Math.min(32, lift.liftHeight + 1);
            this.updateControls();
        });
        this.buttonWidthMinus = UtilitiesClient.newButton((Component)Text.literal("-"), button -> {
            lift.liftWidth = Math.max(2, lift.liftWidth - 1);
            this.updateControls();
        });
        this.buttonWidthAdd = UtilitiesClient.newButton((Component)Text.literal("+"), button -> {
            lift.liftWidth = Math.min(16, lift.liftWidth + 1);
            this.updateControls();
        });
        this.buttonDepthMinus = UtilitiesClient.newButton((Component)Text.literal("-"), button -> {
            lift.liftDepth = Math.max(2, lift.liftDepth - 1);
            this.updateControls();
        });
        this.buttonDepthAdd = UtilitiesClient.newButton((Component)Text.literal("+"), button -> {
            lift.liftDepth = Math.min(16, lift.liftDepth + 1);
            this.updateControls();
        });
        this.buttonOffsetXMinus = UtilitiesClient.newButton((Component)Text.literal("-"), button -> {
            lift.liftOffsetX = Math.max(-32, lift.liftOffsetX - 1);
            this.updateControls();
        });
        this.buttonOffsetXAdd = UtilitiesClient.newButton((Component)Text.literal("+"), button -> {
            lift.liftOffsetX = Math.min(32, lift.liftOffsetX + 1);
            this.updateControls();
        });
        this.buttonOffsetYMinus = UtilitiesClient.newButton((Component)Text.literal("-"), button -> {
            lift.liftOffsetY = Math.max(-16, lift.liftOffsetY - 1);
            this.updateControls();
        });
        this.buttonOffsetYAdd = UtilitiesClient.newButton((Component)Text.literal("+"), button -> {
            lift.liftOffsetY = Math.min(16, lift.liftOffsetY + 1);
            this.updateControls();
        });
        this.buttonOffsetZMinus = UtilitiesClient.newButton((Component)Text.literal("-"), button -> {
            lift.liftOffsetZ = Math.max(-32, lift.liftOffsetZ - 1);
            this.updateControls();
        });
        this.buttonOffsetZAdd = UtilitiesClient.newButton((Component)Text.literal("+"), button -> {
            lift.liftOffsetZ = Math.min(32, lift.liftOffsetZ + 1);
            this.updateControls();
        });
        MutableComponent doubleSidedText = Text.translatable("gui.mtr.lift_is_double_sided", new Object[0]);
        MutableComponent rotateAnticlockwiseText = Text.translatable("gui.mtr.rotate_anticlockwise", new Object[0]);
        MutableComponent rotateClockwiseText = Text.translatable("gui.mtr.rotate_clockwise", new Object[0]);
        this.buttonIsDoubleSided = new WidgetBetterCheckbox(0, 0, 0, 20, (Component)doubleSidedText, checked -> {
            lift.isDoubleSided = checked;
        });
        this.buttonLiftStyle = UtilitiesClient.newButton(button -> {
            lift.liftStyle = Lift.LiftStyle.values()[(lift.liftStyle.ordinal() + 1) % Lift.LiftStyle.values().length];
            this.updateControls();
        });
        this.buttonRotateAnticlockwise = UtilitiesClient.newButton((Component)rotateAnticlockwiseText, button -> {
            lift.facing = lift.facing.m_122428_();
        });
        this.buttonRotateClockwise = UtilitiesClient.newButton((Component)rotateClockwiseText, button -> {
            lift.facing = lift.facing.m_122427_();
        });
        this.f_96547_ = Minecraft.m_91087_().f_91062_;
        this.width1 = Math.max(Math.max(60, this.f_96547_.m_92852_((FormattedText)doubleSidedText)), Math.max(this.f_96547_.m_92852_((FormattedText)rotateAnticlockwiseText), this.f_96547_.m_92852_((FormattedText)rotateClockwiseText))) + 12;
        this.width2 = this.width1 + 20;
    }

    protected void m_7856_() {
        super.m_7856_();
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonHeightMinus, 0, 0, 20);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonHeightAdd, this.width1, 0, 20);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonWidthMinus, 0, 20, 20);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonWidthAdd, this.width1, 20, 20);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonDepthMinus, 0, 40, 20);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonDepthAdd, this.width1, 40, 20);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonOffsetXMinus, 0, 60, 20);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonOffsetXAdd, this.width1, 60, 20);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonOffsetYMinus, 0, 80, 20);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonOffsetYAdd, this.width1, 80, 20);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonOffsetZMinus, 0, 100, 20);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonOffsetZAdd, this.width1, 100, 20);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonIsDoubleSided, 0, 140, this.width2);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonLiftStyle, 0, 160, this.width2);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonRotateAnticlockwise, 0, 180, this.width2);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonRotateClockwise, 0, 200, this.width2);
        this.addDrawableChild(this.buttonHeightMinus);
        this.addDrawableChild(this.buttonHeightAdd);
        this.addDrawableChild(this.buttonWidthMinus);
        this.addDrawableChild(this.buttonWidthAdd);
        this.addDrawableChild(this.buttonDepthMinus);
        this.addDrawableChild(this.buttonDepthAdd);
        this.addDrawableChild(this.buttonOffsetXMinus);
        this.addDrawableChild(this.buttonOffsetXAdd);
        this.addDrawableChild(this.buttonOffsetYMinus);
        this.addDrawableChild(this.buttonOffsetYAdd);
        this.addDrawableChild(this.buttonOffsetZMinus);
        this.addDrawableChild(this.buttonOffsetZAdd);
        this.addDrawableChild(this.buttonIsDoubleSided);
        this.addDrawableChild(this.buttonRotateAnticlockwise);
        this.addDrawableChild(this.buttonRotateClockwise);
        this.updateControls();
    }

    public void m_86412_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        try {
            Gui.m_93172_((PoseStack)matrices, (int)0, (int)0, (int)this.width2, (int)this.f_96544_, (int)-15592942);
            super.m_86412_(matrices, mouseX, mouseY, delta);
            LiftCustomizationScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)Text.translatable("tooltip.mtr.rail_action_height", Float.valueOf((float)this.lift.liftHeight / 2.0f)), (int)(this.width2 / 2), (int)6, (int)-1);
            LiftCustomizationScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)Text.translatable("tooltip.mtr.rail_action_width", this.lift.liftWidth), (int)(this.width2 / 2), (int)26, (int)-1);
            LiftCustomizationScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)Text.translatable("tooltip.mtr.rail_action_depth", this.lift.liftDepth), (int)(this.width2 / 2), (int)46, (int)-1);
            LiftCustomizationScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)Text.translatable("gui.mtr.offset_x", Float.valueOf((float)this.lift.liftOffsetX / 2.0f)), (int)(this.width2 / 2), (int)66, (int)-1);
            LiftCustomizationScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)Text.translatable("gui.mtr.offset_y", this.lift.liftOffsetY), (int)(this.width2 / 2), (int)86, (int)-1);
            LiftCustomizationScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)Text.translatable("gui.mtr.offset_z", Float.valueOf((float)this.lift.liftOffsetZ / 2.0f)), (int)(this.width2 / 2), (int)106, (int)-1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void m_7379_() {
        super.m_7379_();
        this.lift.setExtraData(packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_LIFT, packet));
    }

    public boolean m_7043_() {
        return false;
    }

    private void updateControls() {
        this.buttonHeightMinus.f_93623_ = this.lift.liftHeight > 4;
        this.buttonHeightAdd.f_93623_ = this.lift.liftHeight < 32;
        this.buttonWidthMinus.f_93623_ = this.lift.liftWidth > 2;
        this.buttonWidthAdd.f_93623_ = this.lift.liftWidth < 16;
        this.buttonDepthMinus.f_93623_ = this.lift.liftDepth > 2;
        this.buttonDepthAdd.f_93623_ = this.lift.liftDepth < 16;
        this.buttonOffsetXMinus.f_93623_ = this.lift.liftOffsetX > -32;
        this.buttonOffsetXAdd.f_93623_ = this.lift.liftOffsetX < 32;
        this.buttonOffsetYMinus.f_93623_ = this.lift.liftOffsetY > -16;
        this.buttonOffsetYAdd.f_93623_ = this.lift.liftOffsetY < 16;
        this.buttonOffsetZMinus.f_93623_ = this.lift.liftOffsetZ > -32;
        this.buttonOffsetZAdd.f_93623_ = this.lift.liftOffsetZ < 32;
        this.buttonIsDoubleSided.setChecked(this.lift.isDoubleSided);
        this.buttonLiftStyle.m_93666_((Component)Text.translatable("gui.mtr.lift_style", Text.translatable("gui.mtr.lift_style_" + this.lift.liftStyle.toString().toLowerCase(Locale.ENGLISH), new Object[0])));
    }
}

