/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import mtr.block.BlockLiftTrackFloor;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.WidgetBetterCheckbox;
import mtr.screen.WidgetBetterTextField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LiftTrackFloorScreen
extends ScreenMapper
implements IGui,
IPacket {
    private final WidgetBetterTextField textFieldFloorNumber;
    private final WidgetBetterTextField textFieldFloorDescription;
    private final WidgetBetterCheckbox checkboxShouldDing;
    private final BlockPos pos;
    private final String initialFloorNumber;
    private final String initialFloorDescription;
    private final boolean initialShouldDing;
    private final int textWidth;
    private static final Component TEXT_FLOOR_NUMBER = Text.translatable("gui.mtr.lift_floor_number", new Object[0]);
    private static final Component TEXT_FLOOR_DESCRIPTION = Text.translatable("gui.mtr.lift_floor_description", new Object[0]);
    private static final int TEXT_FIELD_WIDTH = 240;

    public LiftTrackFloorScreen(BlockPos pos) {
        super((Component)Text.literal(""));
        this.pos = pos;
        this.textFieldFloorNumber = new WidgetBetterTextField("1", 8);
        this.textFieldFloorDescription = new WidgetBetterTextField("Concourse");
        this.checkboxShouldDing = new WidgetBetterCheckbox(0, 0, 0, 20, (Component)Text.translatable("gui.mtr.lift_should_ding", new Object[0]), checked -> {});
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            this.initialFloorNumber = "1";
            this.initialFloorDescription = "";
            this.initialShouldDing = false;
        } else {
            BlockEntity entity = world.m_7702_(pos);
            if (entity instanceof BlockLiftTrackFloor.TileEntityLiftTrackFloor) {
                this.initialFloorNumber = ((BlockLiftTrackFloor.TileEntityLiftTrackFloor)entity).getFloorNumber();
                this.initialFloorDescription = ((BlockLiftTrackFloor.TileEntityLiftTrackFloor)entity).getFloorDescription();
                this.initialShouldDing = ((BlockLiftTrackFloor.TileEntityLiftTrackFloor)entity).getShouldDing();
            } else {
                this.initialFloorNumber = "1";
                this.initialFloorDescription = "";
                this.initialShouldDing = false;
            }
        }
        this.f_96547_ = Minecraft.m_91087_().f_91062_;
        this.textWidth = Math.max(this.f_96547_.m_92852_((FormattedText)TEXT_FLOOR_NUMBER), this.f_96547_.m_92852_((FormattedText)TEXT_FLOOR_DESCRIPTION));
    }

    protected void m_7856_() {
        super.m_7856_();
        int startX = (this.f_96543_ - this.textWidth - 6 - 240) / 2;
        int startY = (this.f_96544_ - 60 - 8) / 2;
        IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldFloorNumber, startX + this.textWidth + 6 + 2, startY + 2, 236);
        IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldFloorDescription, startX + this.textWidth + 6 + 2, startY + 20 + 6, 236);
        IDrawing.setPositionAndWidth((AbstractWidget)this.checkboxShouldDing, startX, startY + 40 + 8, 240);
        this.textFieldFloorNumber.m_94144_(this.initialFloorNumber);
        this.textFieldFloorDescription.m_94144_(this.initialFloorDescription);
        this.checkboxShouldDing.setChecked(this.initialShouldDing);
        this.addDrawableChild(this.textFieldFloorNumber);
        this.addDrawableChild(this.textFieldFloorDescription);
        this.addDrawableChild(this.checkboxShouldDing);
    }

    public void m_86600_() {
        this.textFieldFloorNumber.m_94120_();
        this.textFieldFloorDescription.m_94120_();
    }

    public void m_86412_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        try {
            this.m_7333_(matrices);
            int startX = (this.f_96543_ - this.textWidth - 6 - 240) / 2;
            int startY = (this.f_96544_ - 60 - 8) / 2;
            this.f_96547_.m_92889_(matrices, TEXT_FLOOR_NUMBER, (float)startX, (float)startY + 2.0f + 6.0f, -1);
            this.f_96547_.m_92889_(matrices, TEXT_FLOOR_DESCRIPTION, (float)startX, (float)(startY + 20) + 6.0f + 6.0f, -1);
            super.m_86412_(matrices, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void m_7379_() {
        PacketTrainDataGuiClient.sendLiftTrackFloorC2S(this.pos, this.textFieldFloorNumber.m_94155_(), this.textFieldFloorDescription.m_94155_(), this.checkboxShouldDing.m_93840_());
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }
}

