/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiClient;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;

public class TicketMachineScreen
extends ScreenMapper
implements IGui,
IPacket {
    private final Button[] buttons = new Button[10];
    private final Component balanceText;
    private static final int EMERALD_TO_DOLLAR = 10;
    private static final int BUTTON_COUNT = 10;
    private static final int BUTTON_WIDTH = 80;

    public TicketMachineScreen(int balance) {
        super((Component)Text.literal(""));
        for (int i = 0; i < 10; ++i) {
            int index = i;
            this.buttons[i] = UtilitiesClient.newButton((Component)Text.translatable("gui.mtr.add_value", new Object[0]), button -> {
                PacketTrainDataGuiClient.addBalanceC2S(TicketMachineScreen.getAddAmount(index), (int)Math.pow(2.0, index));
                if (this.f_96541_ != null) {
                    UtilitiesClient.setScreen(this.f_96541_, null);
                }
            });
        }
        this.balanceText = Text.translatable("gui.mtr.balance", balance);
    }

    protected void m_7856_() {
        super.m_7856_();
        for (int i = 0; i < 10; ++i) {
            IDrawing.setPositionAndWidth((AbstractWidget)this.buttons[i], this.f_96543_ - 80, 20 * (i + 1), 76);
        }
        for (Button button : this.buttons) {
            this.addDrawableChild(button);
        }
    }

    public void m_86600_() {
        int emeraldCount = this.getEmeraldCount();
        for (int i = 0; i < 10; ++i) {
            this.buttons[i].f_93623_ = (double)emeraldCount >= Math.pow(2.0, i);
        }
    }

    public void m_86412_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        try {
            this.m_7333_(matrices);
            MutableComponent emeraldsText = Text.translatable("gui.mtr.emeralds", this.getEmeraldCount());
            this.f_96547_.m_92889_(matrices, this.balanceText, 6.0f, 6.0f, -1);
            this.f_96547_.m_92889_(matrices, (Component)emeraldsText, (float)(this.f_96543_ - 6 - this.f_96547_.m_92852_((FormattedText)emeraldsText)), 6.0f, -1);
            for (int i = 0; i < 10; ++i) {
                this.f_96547_.m_92889_(matrices, (Component)Text.translatable("gui.mtr.add_balance_for_emeralds", TicketMachineScreen.getAddAmount(i), (int)Math.pow(2.0, i)), 6.0f, (float)((i + 1) * 20 + 6), -1);
            }
            super.m_86412_(matrices, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private int getEmeraldCount() {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            return Utilities.getInventory((Player)this.f_96541_.f_91074_).m_18947_(Items.f_42616_);
        }
        return 0;
    }

    private static int getAddAmount(int index) {
        return (int)Math.ceil(Math.pow(2.0, index) * (double)(10 + index));
    }
}

