/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import mtr.block.BlockTrainSensorBase;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.NameColorDataBase;
import mtr.data.Route;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.DashboardListSelectorScreen;
import mtr.screen.WidgetBetterCheckbox;
import mtr.screen.WidgetBetterTextField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class TrainSensorScreenBase
extends ScreenMapper
implements IGui,
IPacket {
    private boolean stoppedOnly;
    private boolean movingOnly;
    protected final BlockPos pos;
    protected final WidgetBetterTextField[] textFields;
    private final Set<Long> filterRouteIds;
    private final int textFieldCount;
    private final Component[] textFieldLabels;
    private final WidgetBetterCheckbox stoppedOnlyCheckbox;
    private final WidgetBetterCheckbox movingOnlyCheckbox;
    private final Button filterButton;
    private final boolean hasSpeedCheckboxes;
    private final int yStart;

    @SafeVarargs
    public TrainSensorScreenBase(BlockPos pos, boolean hasSpeedCheckboxes, Tuple<WidgetBetterTextField, Component> ... textFieldsAndLabels) {
        super((Component)Text.literal(""));
        this.pos = pos;
        this.textFieldCount = textFieldsAndLabels.length;
        this.textFields = new WidgetBetterTextField[this.textFieldCount];
        this.textFieldLabels = new Component[this.textFieldCount];
        for (int i = 0; i < this.textFieldCount; ++i) {
            this.textFields[i] = (WidgetBetterTextField)textFieldsAndLabels[i].m_14418_();
            this.textFieldLabels[i] = (Component)textFieldsAndLabels[i].m_14419_();
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            this.filterRouteIds = new HashSet<Long>();
        } else {
            BlockEntity entity = world.m_7702_(pos);
            if (entity instanceof BlockTrainSensorBase.TileEntityTrainSensorBase) {
                this.filterRouteIds = ((BlockTrainSensorBase.TileEntityTrainSensorBase)entity).getRouteIds();
                this.stoppedOnly = ((BlockTrainSensorBase.TileEntityTrainSensorBase)entity).getStoppedOnly();
                this.movingOnly = ((BlockTrainSensorBase.TileEntityTrainSensorBase)entity).getMovingOnly();
            } else {
                this.filterRouteIds = new HashSet<Long>();
            }
        }
        this.stoppedOnlyCheckbox = new WidgetBetterCheckbox(0, 0, 0, 20, (Component)Text.translatable("gui.mtr.stopped_only", new Object[0]), checked -> this.setChecked(checked, this.movingOnly));
        this.movingOnlyCheckbox = new WidgetBetterCheckbox(0, 0, 0, 20, (Component)Text.translatable("gui.mtr.moving_only", new Object[0]), checked -> this.setChecked(this.stoppedOnly, checked));
        this.filterButton = UtilitiesClient.newButton(button -> {
            if (this.f_96541_ != null) {
                ArrayList<NameColorDataBase> routes = new ArrayList<NameColorDataBase>(ClientData.ROUTES);
                Collections.sort(routes);
                UtilitiesClient.setScreen(this.f_96541_, new DashboardListSelectorScreen(this, routes, this.filterRouteIds, false, false));
            }
        });
        this.hasSpeedCheckboxes = hasSpeedCheckboxes;
        this.yStart = (this.textFieldCount == 0 ? 20 : 84) + (hasSpeedCheckboxes ? 40 : 0);
    }

    protected void m_7856_() {
        super.m_7856_();
        int textFieldWidth = this.textFieldCount == 0 ? 0 : (this.f_96543_ - 40) / this.textFieldCount;
        for (int i = 0; i < this.textFieldCount; ++i) {
            IDrawing.setPositionAndWidth((AbstractWidget)this.textFields[i], 22 + textFieldWidth * i, 36, textFieldWidth - 4);
            this.addDrawableChild(this.textFields[i]);
        }
        if (this.hasSpeedCheckboxes) {
            IDrawing.setPositionAndWidth((AbstractWidget)this.stoppedOnlyCheckbox, 20, this.yStart - 40, 144);
            IDrawing.setPositionAndWidth((AbstractWidget)this.movingOnlyCheckbox, 20, this.yStart - 20, 144);
            this.addDrawableChild(this.stoppedOnlyCheckbox);
            this.addDrawableChild(this.movingOnlyCheckbox);
            this.setChecked(this.stoppedOnly, this.movingOnly);
        }
        IDrawing.setPositionAndWidth((AbstractWidget)this.filterButton, 20, this.yStart + 40, 72);
        this.filterButton.m_93666_((Component)Text.translatable("selectWorld.edit", new Object[0]));
        this.addDrawableChild(this.filterButton);
    }

    public void m_86600_() {
        for (WidgetBetterTextField textField : this.textFields) {
            textField.m_94120_();
        }
    }

    public void m_86412_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        try {
            int i;
            this.m_7333_(matrices);
            for (i = 0; i < this.textFieldCount; ++i) {
                this.f_96547_.m_92889_(matrices, this.textFieldLabels[i], 20.0f + (float)(this.f_96543_ / 2 - 20) * (float)i, 20.0f, -1);
            }
            this.f_96547_.m_92889_(matrices, (Component)Text.translatable("gui.mtr.filtered_routes", this.filterRouteIds.size()), 20.0f, (float)(this.yStart + 6), -1);
            this.f_96547_.m_92889_(matrices, (Component)Text.translatable(this.filterRouteIds.isEmpty() ? "gui.mtr.filtered_routes_empty" : "gui.mtr.filtered_routes_condition", new Object[0]), 20.0f, (float)(this.yStart + 20 + 6), -1);
            i = 0;
            for (long routeId : this.filterRouteIds) {
                Route route = (Route)ClientData.DATA_CACHE.routeIdMap.get(routeId);
                if (route != null) {
                    this.f_96547_.m_92889_(matrices, (Component)Text.literal(IGui.formatStationName(route.name)), 20.0f, (float)(this.yStart + 60 + 6 + i), -1);
                }
                i += 8;
            }
            this.renderAdditional(matrices);
            super.m_86412_(matrices, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void m_7379_() {
        String[] strings = new String[this.textFieldCount];
        for (int i = 0; i < this.textFieldCount; ++i) {
            strings[i] = this.textFields[i].m_94155_();
        }
        PacketTrainDataGuiClient.sendTrainSensorC2S(this.pos, this.filterRouteIds, this.stoppedOnly, this.movingOnly, this.getNumber(), strings);
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }

    protected void renderAdditional(PoseStack matrices) {
    }

    protected int getNumber() {
        return 0;
    }

    private void setChecked(boolean newStoppedOnly, boolean newMovingOnly) {
        this.stoppedOnly = newMovingOnly && this.stoppedOnly ? false : newStoppedOnly;
        this.movingOnly = newStoppedOnly && this.movingOnly ? false : newMovingOnly;
        this.stoppedOnlyCheckbox.setChecked(this.stoppedOnly);
        this.movingOnlyCheckbox.setChecked(this.movingOnly);
    }
}

