/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import java.util.function.Function;
import mtr.data.IGui;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class WidgetShorterSlider
extends AbstractSliderButton
implements IGui {
    private final int maxValue;
    private final int markerFrequency;
    private final int markerDisplayedRatio;
    private final Function<Integer, String> setMessage;
    private final Consumer<Integer> shiftClickAction;
    private static final int SLIDER_WIDTH = 6;
    private static final int TICK_HEIGHT = 10;

    public WidgetShorterSlider(int x, int width, int maxValue, int markerFrequency, int markerDisplayedRatio, Function<Integer, String> setMessage, Consumer<Integer> shiftClickAction) {
        super(x, 0, width, 0, (Component)Text.literal(""), 0.0);
        this.maxValue = maxValue;
        this.setMessage = setMessage;
        this.shiftClickAction = shiftClickAction;
        this.markerFrequency = markerFrequency;
        this.markerDisplayedRatio = markerDisplayedRatio;
    }

    public WidgetShorterSlider(int x, int width, int maxValue, Function<Integer, String> setMessage, Consumer<Integer> shiftClickAction) {
        this(x, width, maxValue, 0, 0, setMessage, shiftClickAction);
    }

    public void m_5716_(double d, double e) {
        super.m_5716_(d, e);
        this.checkShiftClick();
    }

    public void m_93674_(int width) {
        super.m_93674_(Math.min(width, 380));
    }

    protected void m_5695_() {
        this.m_93666_((Component)Text.literal(this.setMessage.apply(this.getIntValue())));
    }

    protected void m_7212_(double d, double e, double f, double g) {
        super.m_7212_(d, e, f, g);
        this.checkShiftClick();
    }

    protected void m_5697_() {
    }

    public void renderWidget(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.render(matrices);
    }

    public void m_6303_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.render(matrices);
    }

    public void setValue(int valueInt) {
        this.f_93577_ = (double)valueInt / (double)this.maxValue;
        this.m_5695_();
    }

    public void setHeight(int height) {
        this.f_93619_ = height;
    }

    public int getIntValue() {
        return (int)Math.round(this.f_93577_ * (double)this.maxValue);
    }

    private void render(PoseStack matrices) {
        Minecraft client = Minecraft.m_91087_();
        UtilitiesClient.beginDrawingTexture(f_93617_);
        this.m_93228_(matrices, UtilitiesClient.getWidgetX((AbstractWidget)this), UtilitiesClient.getWidgetY((AbstractWidget)this), 0, 46, this.f_93618_ / 2, this.f_93619_ / 2);
        this.m_93228_(matrices, UtilitiesClient.getWidgetX((AbstractWidget)this), UtilitiesClient.getWidgetY((AbstractWidget)this) + this.f_93619_ / 2, 0, 66 - this.f_93619_ / 2, this.f_93618_ / 2, this.f_93619_ / 2);
        this.m_93228_(matrices, UtilitiesClient.getWidgetX((AbstractWidget)this) + this.f_93618_ / 2, UtilitiesClient.getWidgetY((AbstractWidget)this), 200 - this.f_93618_ / 2, 46, this.f_93618_ / 2, this.f_93619_ / 2);
        this.m_93228_(matrices, UtilitiesClient.getWidgetX((AbstractWidget)this) + this.f_93618_ / 2, UtilitiesClient.getWidgetY((AbstractWidget)this) + this.f_93619_ / 2, 200 - this.f_93618_ / 2, 66 - this.f_93619_ / 2, this.f_93618_ / 2, this.f_93619_ / 2);
        int v = UtilitiesClient.isHovered((AbstractWidget)this) ? 86 : 66;
        int xOffset = (this.f_93618_ - 6) * this.getIntValue() / this.maxValue;
        this.m_93228_(matrices, UtilitiesClient.getWidgetX((AbstractWidget)this) + xOffset, UtilitiesClient.getWidgetY((AbstractWidget)this), 0, v, 3, this.f_93619_ / 2);
        this.m_93228_(matrices, UtilitiesClient.getWidgetX((AbstractWidget)this) + xOffset, UtilitiesClient.getWidgetY((AbstractWidget)this) + this.f_93619_ / 2, 0, v + 20 - this.f_93619_ / 2, 3, this.f_93619_ / 2);
        this.m_93228_(matrices, UtilitiesClient.getWidgetX((AbstractWidget)this) + xOffset + 3, UtilitiesClient.getWidgetY((AbstractWidget)this), 197, v, 3, this.f_93619_ / 2);
        this.m_93228_(matrices, UtilitiesClient.getWidgetX((AbstractWidget)this) + xOffset + 3, UtilitiesClient.getWidgetY((AbstractWidget)this) + this.f_93619_ / 2, 197, v + 20 - this.f_93619_ / 2, 3, this.f_93619_ / 2);
        WidgetShorterSlider.m_93236_((PoseStack)matrices, (Font)client.f_91062_, (String)this.m_6035_().getString(), (int)(UtilitiesClient.getWidgetX((AbstractWidget)this) + this.f_93618_ + 6), (int)(UtilitiesClient.getWidgetY((AbstractWidget)this) + (this.f_93619_ - 8) / 2), (int)-1);
        if (this.markerFrequency > 0) {
            for (int i = 1; i <= this.maxValue / this.markerFrequency; ++i) {
                UtilitiesClient.beginDrawingTexture(f_93617_);
                int xOffset1 = (this.f_93618_ - 6) * i * this.markerFrequency / this.maxValue;
                this.m_93228_(matrices, UtilitiesClient.getWidgetX((AbstractWidget)this) + xOffset1 + 2, UtilitiesClient.getWidgetY((AbstractWidget)this) + this.f_93619_, 10, 68, 2, 10);
                WidgetShorterSlider.m_93208_((PoseStack)matrices, (Font)client.f_91062_, (String)String.valueOf(i * this.markerFrequency / this.markerDisplayedRatio), (int)(UtilitiesClient.getWidgetX((AbstractWidget)this) + xOffset1 + 3), (int)(UtilitiesClient.getWidgetY((AbstractWidget)this) + this.f_93619_ + 10 + 2), (int)-1);
            }
        }
    }

    private void checkShiftClick() {
        if (this.shiftClickAction != null && Screen.m_96638_()) {
            this.shiftClickAction.accept(this.getIntValue());
        }
    }
}

