/*
 * Decompiled with CFR 0.152.
 */
package mtr.servlet;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import mtr.data.RouteType;
import mtr.data.TransportMode;
import mtr.libraries.javax.servlet.AsyncContext;
import mtr.libraries.javax.servlet.ServletOutputStream;
import mtr.libraries.javax.servlet.WriteListener;
import mtr.libraries.javax.servlet.http.HttpServletResponse;

public interface IServletHandler {
    public static void sendResponse(final HttpServletResponse response, final AsyncContext asyncContext, String content) {
        final ByteBuffer contentBytes = ByteBuffer.wrap(content.getBytes(StandardCharsets.UTF_8));
        try {
            response.addHeader("Access-Control-Allow-Origin", "*");
            response.addHeader("Content-Type", "application/json");
            final ServletOutputStream servletOutputStream = response.getOutputStream();
            servletOutputStream.setWriteListener(new WriteListener(){

                @Override
                public void onWritePossible() throws IOException {
                    while (servletOutputStream.isReady()) {
                        if (!contentBytes.hasRemaining()) {
                            response.setStatus(200);
                            asyncContext.complete();
                            return;
                        }
                        servletOutputStream.write(contentBytes.get());
                    }
                }

                @Override
                public void onError(Throwable t) {
                    asyncContext.complete();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String createRouteKey(TransportMode transportMode, RouteType routeType) {
        return (transportMode.toString() + "_" + routeType.toString()).toLowerCase(Locale.ENGLISH);
    }
}

