/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.LockCode;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import org.apache.commons.lang3.mutable.MutableBoolean;
import snownee.jade.JadeCommonConfig;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.ui.HorizontalLineElement;
import snownee.jade.impl.ui.ScaledTextElement;
import snownee.jade.util.PlatformProxy;

public enum ItemStorageProvider implements IBlockComponentProvider,
IServerDataProvider<BlockEntity>,
IServerExtensionProvider<Object, ItemStack>,
IClientExtensionProvider<ItemStack, ItemView>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (accessor.getBlockEntity() instanceof AbstractFurnaceBlockEntity) {
            return;
        }
        ItemStorageProvider.append(tooltip, accessor, config);
    }

    public static void append(ITooltip tooltip, Accessor<?> accessor, IPluginConfig config) {
        if (accessor.getServerData().m_128441_("JadeItemStorage")) {
            Optional<IClientExtensionProvider> provider = Optional.ofNullable(ResourceLocation.m_135820_((String)accessor.getServerData().m_128461_("JadeItemStorageUid"))).map(WailaClientRegistration.INSTANCE.itemStorageProviders::get);
            if (provider.isPresent()) {
                List groups = provider.get().getClientGroups(accessor, ViewGroup.readList(accessor.getServerData(), "JadeItemStorage", itemTag -> {
                    ItemStack item = ItemStack.m_41712_((CompoundTag)itemTag);
                    if (!item.m_41619_() && itemTag.m_128441_("NewCount")) {
                        item.m_41764_(itemTag.m_128451_("NewCount"));
                    }
                    return item;
                }));
                if (groups.isEmpty()) {
                    return;
                }
                MutableBoolean showName = new MutableBoolean();
                int totalSize = 0;
                for (ClientViewGroup clientViewGroup : groups) {
                    for (ItemView view : clientViewGroup.views) {
                        if (view.text != null) {
                            showName.setTrue();
                        }
                        if (view.item.m_41619_()) continue;
                        ++totalSize;
                    }
                }
                if (showName.isFalse()) {
                    showName.setValue(totalSize < PluginConfig.INSTANCE.getInt(Identifiers.MC_BLOCK_INVENTORY_SHOW_NAME_AMOUNT));
                }
                IElementHelper helper = IElementHelper.get();
                boolean renderGroup = groups.size() > 1 || groups.get(0).shouldRenderGroup();
                ClientViewGroup.tooltip(tooltip, groups, renderGroup, (theTooltip, group) -> {
                    if (renderGroup) {
                        theTooltip.add(new HorizontalLineElement());
                        if (group.title != null) {
                            theTooltip.append(new ScaledTextElement(group.title, 0.5f));
                            theTooltip.append(new HorizontalLineElement());
                        }
                    }
                    int drawnCount = 0;
                    int realSize = PluginConfig.INSTANCE.getInt(accessor.showDetails() ? Identifiers.MC_BLOCK_INVENTORY_DETAILED_AMOUNT : Identifiers.MC_BLOCK_INVENTORY_NORMAL_AMOUNT);
                    realSize = Math.min(group.views.size(), realSize);
                    ArrayList elements = Lists.newArrayList();
                    for (int i = 0; i < realSize; ++i) {
                        ItemView itemView = (ItemView)group.views.get(i);
                        ItemStack stack = itemView.item;
                        if (stack.m_41619_()) continue;
                        if (i > 0 && (showName.isTrue() || drawnCount >= PluginConfig.INSTANCE.getInt(Identifiers.MC_BLOCK_INVENTORY_ITEMS_PER_LINE))) {
                            theTooltip.add(elements);
                            elements.clear();
                            drawnCount = 0;
                        }
                        if (showName.isTrue()) {
                            ItemStack copy = stack.m_41777_();
                            copy.m_41764_(1);
                            elements.add(helper.smallItem(copy).clearCachedMessage());
                            elements.add(helper.text((Component)Component.m_237113_((String)IDisplayHelper.get().humanReadableNumber(stack.m_41613_(), "", false)).m_130946_("\u00d7 ").m_7220_((Component)IDisplayHelper.get().stripColor(stack.m_41786_()))).message(null));
                        } else if (itemView.text != null) {
                            elements.add(helper.item(stack, 1.0f, itemView.text));
                        } else {
                            elements.add(helper.item(stack));
                        }
                        ++drawnCount;
                    }
                    if (!elements.isEmpty()) {
                        theTooltip.add(elements);
                    }
                });
            }
        } else if (accessor.getServerData().m_128471_("Loot")) {
            tooltip.add((Component)Component.m_237115_((String)"jade.not_generated"));
        } else if (accessor.getServerData().m_128471_("Locked")) {
            tooltip.add((Component)Component.m_237115_((String)"jade.locked"));
        }
    }

    @Override
    public void appendServerData(CompoundTag tag, ServerPlayer player, Level world, BlockEntity te, boolean showDetails) {
        if (JadeCommonConfig.shouldIgnoreTE(tag.m_128461_("id")) || te instanceof AbstractFurnaceBlockEntity) {
            return;
        }
        ItemStorageProvider.putData(tag, player, te, showDetails);
    }

    public static void putData(CompoundTag tag, ServerPlayer player, Object target, boolean showDetails) {
        List<IServerExtensionProvider<Object, ItemStack>> list = WailaCommonRegistration.INSTANCE.itemStorageProviders.get(target);
        for (IServerExtensionProvider<Object, ItemStack> provider : list) {
            List groups = provider.getGroups(player, player.m_9236_(), target, showDetails);
            if (groups == null) continue;
            if (ViewGroup.saveList(tag, "JadeItemStorage", groups, item -> {
                CompoundTag itemTag = new CompoundTag();
                int count = item.m_41613_();
                if (count > 64) {
                    item.m_41764_(1);
                }
                item.m_41739_(itemTag);
                if (count > 64) {
                    itemTag.m_128405_("NewCount", count);
                }
                return itemTag;
            })) {
                tag.m_128359_("JadeItemStorageUid", provider.getUid().toString());
            } else {
                ContainerEntity containerEntity;
                RandomizableContainerBlockEntity te;
                if (target instanceof RandomizableContainerBlockEntity) {
                    te = (RandomizableContainerBlockEntity)target;
                    if (te.f_59605_ != null) {
                        tag.m_128379_("Loot", true);
                        return;
                    }
                }
                if (target instanceof ContainerEntity && (containerEntity = (ContainerEntity)target).m_214142_() != null) {
                    tag.m_128379_("Loot", true);
                    return;
                }
                if (!JadeCommonConfig.bypassLockedContainer && !player.m_7500_() && !player.m_5833_() && target instanceof BaseContainerBlockEntity) {
                    te = (BaseContainerBlockEntity)target;
                    if (te.f_58621_ != LockCode.f_19102_) {
                        tag.m_128379_("Locked", true);
                        return;
                    }
                }
            }
            return;
        }
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.UNIVERSAL_ITEM_STORAGE;
    }

    @Override
    public int getDefaultPriority() {
        return 1000;
    }

    @Override
    public List<ViewGroup<ItemStack>> getGroups(ServerPlayer player, ServerLevel world, Object target, boolean showDetails) {
        ContainerEntity containerEntity;
        RandomizableContainerBlockEntity te;
        if (target instanceof RandomizableContainerBlockEntity) {
            te = (RandomizableContainerBlockEntity)target;
            if (te.f_59605_ != null) {
                return List.of();
            }
        }
        if (target instanceof ContainerEntity && (containerEntity = (ContainerEntity)target).m_214142_() != null) {
            return List.of();
        }
        if (!JadeCommonConfig.bypassLockedContainer && !player.m_7500_() && !player.m_5833_() && target instanceof BaseContainerBlockEntity) {
            te = (BaseContainerBlockEntity)target;
            if (te.f_58621_ != LockCode.f_19102_) {
                return List.of();
            }
        }
        return PlatformProxy.wrapItemStorage(target, (Player)player);
    }

    @Override
    public List<ClientViewGroup<ItemView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<ItemStack>> groups) {
        return ClientViewGroup.map(groups, ItemView::new, null);
    }
}

