/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.overlay.DisplayHelper;

public enum HorseStatsProvider implements IEntityComponentProvider
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        AbstractHorse horse = (AbstractHorse)accessor.getEntity();
        if (horse instanceof AbstractChestedHorse) {
            if (horse instanceof Llama) {
                Llama llama = (Llama)horse;
                tooltip.add((Component)Component.m_237110_((String)"jade.llamaStrength", (Object[])new Object[]{llama.m_30823_()}));
            }
            return;
        }
        double jumpStrength = horse.m_30626_();
        double jumpHeight = -0.1817584952 * jumpStrength * jumpStrength * jumpStrength + 3.689713992 * jumpStrength * jumpStrength + 2.128599134 * jumpStrength - 0.343930367;
        double speed = horse.m_21133_(Attributes.f_22279_) * 43.17;
        tooltip.add((Component)Component.m_237110_((String)"jade.horseStat.jump", (Object[])new Object[]{DisplayHelper.dfCommas.format(jumpHeight)}));
        tooltip.add((Component)Component.m_237110_((String)"jade.horseStat.speed", (Object[])new Object[]{DisplayHelper.dfCommas.format(speed)}));
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_HORSE_STATS;
    }
}

