/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.view;

import com.google.common.math.IntMath;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.view.ViewGroup;

@ApiStatus.Experimental
public class FluidView {
    public static final Component EMPTY_FLUID = Component.m_237115_((String)"jade.fluid.empty");
    public IElement overlay;
    public String current;
    public String max;
    public float ratio;
    @Nullable
    public Component fluidName;
    @Nullable
    public Component overrideText;

    public FluidView(IElement overlay) {
        this.overlay = overlay;
        Objects.requireNonNull(overlay);
    }

    @Nullable
    public static FluidView read(CompoundTag tag) {
        int capacity = tag.m_128451_("Capacity");
        if (capacity <= 0) {
            return null;
        }
        FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)tag);
        FluidView fluidView = new FluidView(IElementHelper.get().fluid(fluid));
        fluidView.fluidName = fluid.getDisplayName();
        if (fluid.isEmpty()) {
            fluidView.overrideText = EMPTY_FLUID;
        }
        fluidView.current = IDisplayHelper.get().humanReadableNumber(fluid.getAmount(), "B", true);
        fluidView.max = IDisplayHelper.get().humanReadableNumber(capacity, "B", true);
        fluidView.ratio = (float)fluid.getAmount() / (float)capacity;
        return fluidView;
    }

    public static CompoundTag fromFluidStack(FluidStack fluidStack, int capacity) {
        CompoundTag tag = fluidStack.writeToNBT(new CompoundTag());
        tag.m_128405_("Capacity", capacity);
        return tag;
    }

    public static List<ViewGroup<CompoundTag>> fromFluidHandler(IFluidHandler fluidHandler) {
        ArrayList<CompoundTag> list = new ArrayList<CompoundTag>(fluidHandler.getTanks());
        int emptyCapacity = 0;
        for (int i = 0; i < fluidHandler.getTanks(); ++i) {
            int capacity = fluidHandler.getTankCapacity(i);
            if (capacity <= 0) continue;
            FluidStack fluidStack = fluidHandler.getFluidInTank(i);
            if (fluidStack.isEmpty()) {
                emptyCapacity = IntMath.saturatedAdd((int)emptyCapacity, (int)capacity);
                continue;
            }
            list.add(FluidView.fromFluidStack(fluidStack, capacity));
        }
        if (list.isEmpty() && emptyCapacity > 0) {
            list.add(FluidView.fromFluidStack(FluidStack.EMPTY, emptyCapacity));
        }
        if (!list.isEmpty()) {
            return List.of(new ViewGroup(list));
        }
        return List.of();
    }
}

