/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import snownee.jade.Jade;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.gui.config.OptionButton;
import snownee.jade.gui.config.WailaOptionsList;
import snownee.jade.gui.config.value.OptionValue;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.util.PlatformProxy;

public class WailaConfigScreen
extends BaseOptionsScreen {
    public WailaConfigScreen(Screen parent) {
        super(parent, (Component)Component.m_237110_((String)"gui.jade.configuration", (Object[])new Object[]{"Jade"}), Jade.CONFIG::save, Jade.CONFIG::invalidate);
    }

    @Override
    public WailaOptionsList createOptions() {
        WailaOptionsList options = new WailaOptionsList(this, this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 30, Jade.CONFIG::save);
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        if (PlatformProxy.isDevEnv()) {
            options.choices("debug_mode", general.isDebug(), general::setDebug);
        }
        options.title("general");
        options.choices("display_tooltip", general.shouldDisplayTooltip(), general::setDisplayTooltip);
        options.choices("display_entities", general.getDisplayEntities(), general::setDisplayEntities);
        options.choices("display_blocks", general.getDisplayBlocks(), general::setDisplayBlocks);
        options.choices("display_fluids", general.getDisplayFluids(), general::setDisplayFluids);
        options.choices("display_mode", general.getDisplayMode(), general::setDisplayMode, builder -> builder.m_232498_(mode -> {
            String key = "display_mode_" + mode.name().toLowerCase(Locale.ENGLISH) + "_desc";
            if (mode == IWailaConfig.DisplayMode.LITE && "fabric".equals(PlatformProxy.getPlatformIdentifier())) {
                key = key + ".fabric";
            }
            return Tooltip.m_257550_((Component)WailaOptionsList.Entry.makeTitle(key));
        }));
        OptionValue<?> value = options.choices("item_mod_name", general.showItemModNameTooltip(), general::setItemModNameTooltip);
        if (!WailaConfig.ConfigGeneral.itemModNameTooltipDisabledByMods.isEmpty()) {
            value.setDisabled(true);
            value.appendDescription(I18n.m_118938_((String)"gui.jade.disabled_by_mods", (Object[])new Object[0]));
            WailaConfig.ConfigGeneral.itemModNameTooltipDisabledByMods.forEach(value::appendDescription);
            if (value.getListener() != null) {
                value.getListener().m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)value.getDescription())));
            }
        }
        options.choices("hide_from_debug", general.shouldHideFromDebug(), general::setHideFromDebug);
        options.choices("hide_from_tab_list", general.shouldHideFromTabList(), general::setHideFromTabList);
        options.choices("boss_bar_overlap", general.getBossBarOverlapMode(), general::setBossBarOverlapMode);
        options.slider("reach_distance", general.getReachDistance(), general::setReachDistance, 0.0f, 20.0f, FloatUnaryOperator.identity());
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        options.title("overlay");
        options.slider("overlay_alpha", overlay.getAlpha(), overlay::setAlpha);
        options.choices("overlay_theme", overlay.getTheme().id, overlay.getThemes().stream().map($ -> $.id).collect(Collectors.toList()), overlay::applyTheme);
        options.choices("overlay_square", overlay.getSquare(), overlay::setSquare);
        options.slider("overlay_scale", overlay.getOverlayScale(), overlay::setOverlayScale, 0.2f, 2.0f, FloatUnaryOperator.identity());
        options.slider("overlay_pos_x", overlay.getOverlayPosX(), overlay::setOverlayPosX);
        options.slider("overlay_pos_y", overlay.getOverlayPosY(), overlay::setOverlayPosY);
        options.slider("overlay_anchor_x", overlay.getAnchorX(), overlay::setAnchorX);
        options.slider("overlay_anchor_y", overlay.getAnchorY(), overlay::setAnchorY);
        options.choices("display_item", overlay.getIconMode(), overlay::setIconMode);
        options.choices("animation", overlay.getAnimation(), overlay::setAnimation);
        options.title("accessibility");
        options.choices("flip_main_hand", overlay.getFlipMainHand(), overlay::setFlipMainHand);
        options.choices("tts_mode", general.getTTSMode(), general::setTTSMode);
        options.title("danger_zone").m_130940_(ChatFormatting.RED);
        MutableComponent reset = Component.m_237115_((String)"controls.reset").m_130940_(ChatFormatting.RED);
        MutableComponent title = Component.m_237115_((String)WailaOptionsList.Entry.makeKey("reset_settings")).m_130940_(ChatFormatting.RED);
        options.add(new OptionButton((Component)title, Button.m_253074_((Component)reset, arg_0 -> this.lambda$createOptions$4((Component)title, (Component)reset, arg_0)).m_253046_(100, 20).m_253136_()));
        return options;
    }

    private /* synthetic */ void lambda$createOptions$4(Component title, Component reset, Button w) {
        this.f_96541_.m_91152_((Screen)new ConfirmScreen(bl -> {
            if (bl) {
                try {
                    Jade.CONFIG.getFile().delete();
                    PluginConfig.INSTANCE.getFile().delete();
                    Jade.CONFIG.invalidate();
                    PluginConfig.INSTANCE.reload();
                    this.m_232761_();
                }
                catch (Throwable e) {
                    Jade.LOGGER.catching(e);
                }
            }
            this.f_96541_.m_91152_((Screen)this);
            this.options.m_93410_(this.options.m_93518_());
        }, title, (Component)Component.m_237115_((String)WailaOptionsList.Entry.makeKey("reset_settings.confirm")), reset, (Component)Component.m_237115_((String)"gui.cancel")));
    }
}

