/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IBoxElement;
import snownee.jade.api.ui.IBoxStyle;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.ITooltipRenderer;
import snownee.jade.impl.Tooltip;
import snownee.jade.overlay.TooltipRenderer;

public class BoxElement
extends Element
implements IBoxElement {
    private final TooltipRenderer tooltip;
    private final IBoxStyle box;

    public BoxElement(Tooltip tooltip, IBoxStyle box) {
        this.tooltip = new TooltipRenderer(tooltip, false);
        this.box = box;
    }

    @Override
    public Vec2 getSize() {
        if (this.tooltip.getTooltip().isEmpty()) {
            return Vec2.f_82462_;
        }
        Vec2 size = this.tooltip.getSize();
        return new Vec2(size.f_82470_, size.f_82471_ + 1.0f);
    }

    @Override
    public void render(PoseStack matrixStack, float x, float y, float maxX, float maxY) {
        if (this.tooltip.getTooltip().isEmpty()) {
            return;
        }
        RenderSystem.m_69478_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(x, y, 0.0f);
        this.box.render(matrixStack, 0.0f, 0.0f, maxX - x, maxY - y - 2.0f);
        this.tooltip.setSize(new Vec2(maxX - x, this.tooltip.getSize().f_82471_));
        this.tooltip.draw(matrixStack);
        matrixStack.m_85849_();
    }

    @Override
    public IElement tag(ResourceLocation tag) {
        this.box.tag(tag);
        return super.tag(tag);
    }

    @Override
    @Nullable
    public Component getMessage() {
        if (this.tooltip.getTooltip().isEmpty()) {
            return null;
        }
        return Component.m_237113_((String)this.tooltip.getTooltip().getMessage());
    }

    @Override
    public ITooltipRenderer getTooltipRenderer() {
        return this.tooltip;
    }
}

