/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import snownee.jade.api.callback.JadeItemModNameCallback;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.util.ClientPlatformProxy;
import snownee.jade.util.PlatformProxy;

public class ModIdentification
implements ResourceManagerReloadListener {
    public static final Map<String, String> NAMES = Maps.newConcurrentMap();
    public static final ModIdentification INSTANCE = new ModIdentification();

    public static void init() {
        NAMES.clear();
        ClientPlatformProxy.initModNames(NAMES);
    }

    public static String getModName(String namespace) {
        return NAMES.computeIfAbsent(namespace, $ -> {
            String key = "jade.modName." + namespace;
            if (I18n.m_118936_((String)key)) {
                return I18n.m_118938_((String)key, (Object[])new Object[0]);
            }
            return namespace;
        });
    }

    public static String getModName(ResourceLocation id) {
        return ModIdentification.getModName(id.m_135827_());
    }

    public static String getModName(Block block) {
        return ModIdentification.getModName(PlatformProxy.getId(block));
    }

    public static String getModName(ItemStack stack) {
        for (JadeItemModNameCallback callback : WailaClientRegistration.INSTANCE.itemModNameCallback.callbacks()) {
            String s = callback.gatherItemModName(stack);
            if (Strings.isNullOrEmpty((String)s)) continue;
            return s;
        }
        return ModIdentification.getModName(PlatformProxy.getModIdFromItem(stack));
    }

    public static String getModName(Entity entity) {
        if (entity instanceof Painting) {
            PaintingVariant motive = (PaintingVariant)((Painting)entity).m_262365_().m_203334_();
            return ModIdentification.getModName(PlatformProxy.getId(motive).m_135827_());
        }
        if (entity instanceof ItemEntity) {
            return ModIdentification.getModName(((ItemEntity)entity).m_32055_());
        }
        if (entity instanceof FallingBlockEntity) {
            return ModIdentification.getModName(((FallingBlockEntity)entity).m_31980_().m_60734_());
        }
        return ModIdentification.getModName(PlatformProxy.getId(entity.m_6095_()));
    }

    public void m_6213_(ResourceManager manager) {
        ModIdentification.init();
    }

    static {
        ModIdentification.init();
    }
}

