/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.flashyreese.mods.sodiumextra.client.SodiumExtraClientMod;
import me.flashyreese.mods.sodiumextra.client.gui.SodiumExtraGameOptions;
import me.flashyreese.mods.sodiumextra.client.gui.options.control.SliderControlExtended;
import me.flashyreese.mods.sodiumextra.client.gui.options.storage.SodiumExtraOptionsStorage;
import me.flashyreese.mods.sodiumextra.common.util.ControlValueFormatterExtended;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpl;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.gui.options.control.CyclingControl;
import me.jellysquid.mods.sodium.client.gui.options.control.SliderControl;
import me.jellysquid.mods.sodium.client.gui.options.control.TickBoxControl;
import me.jellysquid.mods.sodium.client.gui.options.storage.MinecraftOptionsStorage;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.WorldDimensions;

public class SodiumExtraGameOptionPages {
    public static final SodiumExtraOptionsStorage sodiumExtraOpts = new SodiumExtraOptionsStorage();
    public static final MinecraftOptionsStorage vanillaOpts = new MinecraftOptionsStorage();

    private static Component parseVanillaString(String key) {
        return Component.m_237113_((String)Component.m_237115_((String)key).getString().replaceAll("\u00a7.", ""));
    }

    public static OptionPage animation() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName(SodiumExtraGameOptionPages.parseVanillaString("gui.socialInteractions.tab_all")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.animations_all.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.animationSettings.animation = value;
        }, opts -> opts.animationSettings.animation).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_ASSET_RELOAD}).build()).build());
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName(SodiumExtraGameOptionPages.parseVanillaString("block.minecraft.water")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.animate_water.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.animationSettings.water = value;
        }, opts -> opts.animationSettings.water).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_ASSET_RELOAD}).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName(SodiumExtraGameOptionPages.parseVanillaString("block.minecraft.lava")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.animate_lava.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.animationSettings.lava = value;
        }, opts -> opts.animationSettings.lava).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_ASSET_RELOAD}).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName(SodiumExtraGameOptionPages.parseVanillaString("block.minecraft.fire")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.animate_fire.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.animationSettings.fire = value;
        }, opts -> opts.animationSettings.fire).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_ASSET_RELOAD}).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName(SodiumExtraGameOptionPages.parseVanillaString("block.minecraft.nether_portal")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.animate_portal.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.animationSettings.portal = value;
        }, opts -> opts.animationSettings.portal).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_ASSET_RELOAD}).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.block_animations")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.block_animations.tooltip")).setControl(TickBoxControl::new).setBinding((options, value) -> {
            options.animationSettings.blockAnimations = value;
        }, options -> options.animationSettings.blockAnimations).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_ASSET_RELOAD}).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName(SodiumExtraGameOptionPages.parseVanillaString("block.minecraft.sculk_sensor")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.animate_sculk_sensor.tooltip")).setControl(TickBoxControl::new).setBinding((options, value) -> {
            options.animationSettings.sculkSensor = value;
        }, options -> options.animationSettings.sculkSensor).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_ASSET_RELOAD}).build()).build());
        return new OptionPage((Component)Component.m_237115_((String)"sodium-extra.option.animations"), ImmutableList.copyOf(groups));
    }

    public static OptionPage particle() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName(SodiumExtraGameOptionPages.parseVanillaString("gui.socialInteractions.tab_all")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.particles_all.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.particleSettings.particles = value;
        }, opts -> opts.particleSettings.particles).build()).build());
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName(SodiumExtraGameOptionPages.parseVanillaString("subtitles.entity.generic.splash")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.rain_splash.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.particleSettings.rainSplash = value;
        }, opts -> opts.particleSettings.rainSplash).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName(SodiumExtraGameOptionPages.parseVanillaString("subtitles.block.generic.break")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.block_break.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.particleSettings.blockBreak = value;
        }, opts -> opts.particleSettings.blockBreak).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName(SodiumExtraGameOptionPages.parseVanillaString("subtitles.block.generic.hit")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.block_breaking.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.particleSettings.blockBreaking = value;
        }, opts -> opts.particleSettings.blockBreaking).build()).build());
        Map<String, List<ResourceLocation>> otherParticles = BuiltInRegistries.f_257034_.m_6566_().stream().collect(Collectors.groupingBy(ResourceLocation::m_135827_));
        otherParticles.forEach((namespace, identifiers) -> groups.add(identifiers.stream().map(identifier -> OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName(SodiumExtraGameOptionPages.translatableName(identifier, "particles")).setTooltip(SodiumExtraGameOptionPages.translatableTooltip(identifier, "particles")).setControl(TickBoxControl::new).setBinding((opts, val) -> opts.particleSettings.otherMap.put((ResourceLocation)identifier, (Boolean)val), opts -> opts.particleSettings.otherMap.getOrDefault(identifier, true)).build()).sorted(Comparator.comparing(o -> o.getName().getString())).collect(OptionGroup::createBuilder, OptionGroup.Builder::add, (b1, b2) -> {}).build()));
        return new OptionPage(SodiumExtraGameOptionPages.parseVanillaString("options.particles"), ImmutableList.copyOf(groups));
    }

    public static OptionPage detail() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.sky")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.sky.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.detailSettings.sky = value;
        }, opts -> opts.detailSettings.sky).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.stars")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.stars.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.detailSettings.stars = value;
        }, opts -> opts.detailSettings.stars).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.sun_moon")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.sun_moon.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.detailSettings.sunMoon = value;
        }, opts -> opts.detailSettings.sunMoon).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_RENDERER_RELOAD}).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName(SodiumExtraGameOptionPages.parseVanillaString("soundCategory.weather")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.rain_snow.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.detailSettings.rainSnow = value;
        }, opts -> opts.detailSettings.rainSnow).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.biome_colors")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.biome_colors.tooltip")).setControl(TickBoxControl::new).setBinding((options, value) -> {
            options.detailSettings.biomeColors = value;
        }, options -> options.detailSettings.biomeColors).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_RENDERER_RELOAD}).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.sky_colors")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.sky_colors.tooltip")).setControl(TickBoxControl::new).setBinding((options, value) -> {
            options.detailSettings.skyColors = value;
        }, options -> options.detailSettings.skyColors).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_RENDERER_RELOAD}).build()).build());
        return new OptionPage((Component)Component.m_237115_((String)"sodium-extra.option.details"), ImmutableList.copyOf(groups));
    }

    public static OptionPage render() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.multi_dimension_fog")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.multi_dimension_fog.tooltip")).setControl(TickBoxControl::new).setBinding((options, value) -> {
            options.renderSettings.multiDimensionFogControl = value;
        }, options -> options.renderSettings.multiDimensionFogControl).build()).add((Option)OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.fog_start")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.fog_start.tooltip")).setControl(option -> new SliderControlExtended((Option<Integer>)option, 20, 100, 1, ControlValueFormatter.percentage(), false)).setBinding((options, value) -> {
            options.renderSettings.fogStart = value;
        }, options -> options.renderSettings.fogStart).build()).build());
        if (SodiumExtraClientMod.options().renderSettings.multiDimensionFogControl) {
            WorldDimensions.m_247421_(Stream.empty()).filter(dim -> !SodiumExtraClientMod.options().renderSettings.dimensionFogDistanceMap.containsKey(dim.m_135782_())).forEach(dim -> SodiumExtraClientMod.options().renderSettings.dimensionFogDistanceMap.put(dim.m_135782_(), 0));
            groups.add(SodiumExtraClientMod.options().renderSettings.dimensionFogDistanceMap.keySet().stream().map(identifier -> OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237110_((String)"sodium-extra.option.fog", (Object[])new Object[]{SodiumExtraGameOptionPages.translatableName(identifier, "dimensions").getString()})).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.fog.tooltip")).setControl(option -> new SliderControlExtended((Option<Integer>)option, 0, 33, 1, ControlValueFormatterExtended.fogDistance(), false)).setBinding((opts, val) -> opts.renderSettings.dimensionFogDistanceMap.put((ResourceLocation)identifier, (Integer)val), opts -> opts.renderSettings.dimensionFogDistanceMap.getOrDefault(identifier, 0)).build()).collect(OptionGroup::createBuilder, OptionGroup.Builder::add, (b1, b2) -> {}).build());
        } else {
            groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.single_fog")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.single_fog.tooltip")).setControl(option -> new SliderControlExtended((Option<Integer>)option, 0, 33, 1, ControlValueFormatterExtended.fogDistance(), false)).setBinding((options, value) -> {
                options.renderSettings.fogDistance = value;
            }, options -> options.renderSettings.fogDistance).build()).build());
        }
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.linear_flat_color_blender")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.linear_flat_color_blender.tooltip")).setControl(TickBoxControl::new).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_RENDERER_RELOAD}).setImpact(OptionImpact.VARIES).setBinding((options, value) -> {
            options.renderSettings.useLinearFlatColorBlender = value;
        }, options -> options.renderSettings.useLinearFlatColorBlender).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.light_updates")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.light_updates.tooltip")).setControl(TickBoxControl::new).setBinding((options, value) -> {
            options.renderSettings.lightUpdates = value;
        }, options -> options.renderSettings.lightUpdates).build()).build());
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName(SodiumExtraGameOptionPages.parseVanillaString("entity.minecraft.item_frame")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.item_frames.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.renderSettings.itemFrame = value;
        }, opts -> opts.renderSettings.itemFrame).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName(SodiumExtraGameOptionPages.parseVanillaString("entity.minecraft.armor_stand")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.armor_stands.tooltip")).setControl(TickBoxControl::new).setBinding((options, value) -> {
            options.renderSettings.armorStand = value;
        }, options -> options.renderSettings.armorStand).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName(SodiumExtraGameOptionPages.parseVanillaString("entity.minecraft.painting")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.paintings.tooltip")).setControl(TickBoxControl::new).setBinding((options, value) -> {
            options.renderSettings.painting = value;
        }, options -> options.renderSettings.painting).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_RENDERER_RELOAD}).build()).build());
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.beacon_beam")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.beacon_beam.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.renderSettings.beaconBeam = value;
        }, opts -> opts.renderSettings.beaconBeam).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.enchanting_table_book")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.enchanting_table_book.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.renderSettings.enchantingTableBook = value;
        }, opts -> opts.renderSettings.enchantingTableBook).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName(SodiumExtraGameOptionPages.parseVanillaString("block.minecraft.piston")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.piston.tooltip")).setControl(TickBoxControl::new).setBinding((options, value) -> {
            options.renderSettings.piston = value;
        }, options -> options.renderSettings.piston).build()).build());
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.item_frame_name_tag")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.item_frame_name_tag.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.renderSettings.itemFrameNameTag = value;
        }, opts -> opts.renderSettings.itemFrameNameTag).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.player_name_tag")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.player_name_tag.tooltip")).setControl(TickBoxControl::new).setBinding((options, value) -> {
            options.renderSettings.playerNameTag = value;
        }, options -> options.renderSettings.playerNameTag).build()).build());
        return new OptionPage((Component)Component.m_237115_((String)"sodium-extra.option.render"), ImmutableList.copyOf(groups));
    }

    public static OptionPage extra() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.reduce_resolution_on_mac")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.reduce_resolution_on_mac.tooltip")).setEnabled(Minecraft.f_91002_).setImpact(OptionImpact.HIGH).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.extraSettings.reduceResolutionOnMac = value;
        }, opts -> opts.extraSettings.reduceResolutionOnMac).build()).build());
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(SodiumExtraGameOptions.OverlayCorner.class, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.overlay_corner")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.overlay_corner.tooltip")).setControl(option -> new CyclingControl((Option)option, SodiumExtraGameOptions.OverlayCorner.class)).setBinding((opts, value) -> {
            opts.extraSettings.overlayCorner = value;
        }, opts -> opts.extraSettings.overlayCorner).build()).add((Option)OptionImpl.createBuilder(SodiumExtraGameOptions.TextContrast.class, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.text_contrast")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.text_contrast.tooltip")).setControl(option -> new CyclingControl((Option)option, SodiumExtraGameOptions.TextContrast.class)).setBinding((opts, value) -> {
            opts.extraSettings.textContrast = value;
        }, opts -> opts.extraSettings.textContrast).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.show_fps")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.show_fps.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.extraSettings.showFps = value;
        }, opts -> opts.extraSettings.showFps).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.show_fps_extended")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.show_fps_extended.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.extraSettings.showFPSExtended = value;
        }, opts -> opts.extraSettings.showFPSExtended).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.show_coordinates")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.show_coordinates.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.extraSettings.showCoords = value;
        }, opts -> opts.extraSettings.showCoords).build()).add((Option)OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.cloud_height")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.cloud_height.tooltip")).setControl(option -> new SliderControl((Option)option, -64, 319, 1, ControlValueFormatter.number())).setBinding((options, value) -> {
            options.extraSettings.cloudHeight = value;
        }, options -> options.extraSettings.cloudHeight).build()).build());
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)vanillaOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.advanced_item_tooltips")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.advanced_item_tooltips.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.f_92125_ = value;
        }, opts -> opts.f_92125_).build()).build());
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.toasts")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.toasts.tooltip")).setControl(TickBoxControl::new).setBinding((options, value) -> {
            options.extraSettings.toasts = value;
        }, options -> options.extraSettings.toasts).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.advancement_toast")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.advancement_toast.tooltip")).setControl(TickBoxControl::new).setBinding((options, value) -> {
            options.extraSettings.advancementToast = value;
        }, options -> options.extraSettings.advancementToast).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.recipe_toast")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.recipe_toast.tooltip")).setControl(TickBoxControl::new).setBinding((options, value) -> {
            options.extraSettings.recipeToast = value;
        }, options -> options.extraSettings.recipeToast).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.system_toast")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.system_toast.tooltip")).setControl(TickBoxControl::new).setBinding((options, value) -> {
            options.extraSettings.systemToast = value;
        }, options -> options.extraSettings.systemToast).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.tutorial_toast")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.tutorial_toast.tooltip")).setControl(TickBoxControl::new).setBinding((options, value) -> {
            options.extraSettings.tutorialToast = value;
        }, options -> options.extraSettings.tutorialToast).build()).build());
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.instant_sneak")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.instant_sneak.tooltip")).setControl(TickBoxControl::new).setBinding((options, value) -> {
            options.extraSettings.instantSneak = value;
        }, options -> options.extraSettings.instantSneak).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)sodiumExtraOpts).setName((Component)Component.m_237115_((String)"sodium-extra.option.prevent_shaders")).setTooltip((Component)Component.m_237115_((String)"sodium-extra.option.prevent_shaders.tooltip")).setControl(TickBoxControl::new).setBinding((options, value) -> {
            options.extraSettings.preventShaders = value;
        }, options -> options.extraSettings.preventShaders).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_RENDERER_RELOAD}).build()).build());
        return new OptionPage((Component)Component.m_237115_((String)"sodium-extra.option.extras"), ImmutableList.copyOf(groups));
    }

    private static Component translatableName(ResourceLocation identifier, String category) {
        String key = identifier.m_214296_("options.".concat(category));
        MutableComponent translatable = Component.m_237115_((String)key);
        if (!ComponentUtils.m_237134_((Component)translatable)) {
            translatable = Component.m_237113_((String)Arrays.stream(key.substring(key.lastIndexOf(46) + 1).split("_")).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1)).collect(Collectors.joining(" ")));
        }
        return translatable;
    }

    private static Component translatableTooltip(ResourceLocation identifier, String category) {
        String key = identifier.m_214296_("options.".concat(category)).concat(".tooltip");
        MutableComponent translatable = Component.m_237115_((String)key);
        if (!ComponentUtils.m_237134_((Component)translatable)) {
            translatable = Component.m_237110_((String)"sodium-extra.option.".concat(category).concat(".tooltips"), (Object[])new Object[]{SodiumExtraGameOptionPages.translatableName(identifier, category)});
        }
        return translatable;
    }
}

