/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.client.gui.scrollable_page;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import me.flashyreese.mods.sodiumextra.client.gui.scrollable_page.AbstractFrame;
import me.flashyreese.mods.sodiumextra.client.gui.scrollable_page.ScrollBarComponent;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class OptionPageScrollFrame
extends AbstractFrame {
    protected final OptionPage page;
    private boolean canScroll;
    private ScrollBarComponent scrollBar = null;

    public OptionPageScrollFrame(Dim2i dim, OptionPage page) {
        super(dim);
        this.page = page;
        this.setupFrame();
        this.buildFrame();
    }

    public void setupFrame() {
        this.children.clear();
        this.drawable.clear();
        this.controlElements.clear();
        int y = 0;
        if (!this.page.getGroups().isEmpty()) {
            OptionGroup lastGroup = (OptionGroup)this.page.getGroups().get(this.page.getGroups().size() - 1);
            for (OptionGroup group : this.page.getGroups()) {
                y += group.getOptions().size() * 18;
                if (group == lastGroup) continue;
                y += 4;
            }
        }
        boolean bl = this.canScroll = this.dim.height() < y;
        if (this.canScroll) {
            this.scrollBar = new ScrollBarComponent(new Dim2i(this.dim.getLimitX() - 10, this.dim.y(), 10, this.dim.height()), y, this.dim.height(), this::buildFrame, this.dim);
        }
    }

    @Override
    public void buildFrame() {
        if (this.page == null) {
            return;
        }
        this.children.clear();
        this.drawable.clear();
        this.controlElements.clear();
        int y = 0;
        for (OptionGroup group : this.page.getGroups()) {
            for (Option option : group.getOptions()) {
                Control control = option.getControl();
                ControlElement element = control.createElement(new Dim2i(this.dim.x(), this.dim.y() + y - (this.canScroll ? this.scrollBar.getOffset() : 0), this.dim.width() - (this.canScroll ? 11 : 0), 18));
                this.children.add(element);
                y += 18;
            }
            y += 4;
        }
        if (this.canScroll) {
            this.scrollBar.updateThumbPosition();
        }
        super.buildFrame();
    }

    @Override
    public void m_86412_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        ControlElement hoveredElement = this.controlElements.stream().filter(ControlElement::isHovered).findFirst().orElse(null);
        matrices.m_85836_();
        this.applyScissor(this.dim.x(), this.dim.y(), this.dim.width(), this.dim.height(), () -> super.m_86412_(matrices, mouseX, mouseY, delta));
        matrices.m_85849_();
        if (this.canScroll) {
            this.scrollBar.m_86412_(matrices, mouseX, mouseY, delta);
        }
        if (this.dim.containsCursor((double)mouseX, (double)mouseY) && hoveredElement != null) {
            this.renderOptionTooltip(matrices, hoveredElement);
        }
    }

    private void renderOptionTooltip(PoseStack matrixStack, ControlElement<?> element) {
        int boxYCutoff;
        int boxHeight;
        int boxYLimit;
        Dim2i dim = element.getDimensions();
        int textPadding = 3;
        int boxPadding = 3;
        int boxWidth = 200;
        int boxY = Math.max(dim.y(), this.dim.y());
        int boxX = this.dim.getLimitX() + boxPadding;
        Option option = element.getOption();
        ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>(Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)option.getTooltip(), boxWidth - textPadding * 2));
        OptionImpact impact = option.getImpact();
        if (impact != null) {
            tooltip.add(Language.m_128107_().m_5536_((FormattedText)Component.m_237110_((String)"sodium.options.performance_impact_string", (Object[])new Object[]{impact.getLocalizedName()}).m_130940_(ChatFormatting.GRAY)));
        }
        if ((boxYLimit = boxY + (boxHeight = tooltip.size() * 12 + boxPadding)) > (boxYCutoff = this.dim.getLimitY() - 25)) {
            boxY -= boxYLimit - boxYCutoff;
        }
        this.drawRect(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -536870912);
        for (int i = 0; i < tooltip.size(); ++i) {
            Minecraft.m_91087_().f_91062_.m_92877_(matrixStack, (FormattedCharSequence)tooltip.get(i), (float)(boxX + textPadding), (float)(boxY + textPadding + i * 12), -1);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.dim.containsCursor(mouseX, mouseY) && super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.canScroll) {
            return this.scrollBar.m_6375_(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.m_7979_(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (this.canScroll) {
            return this.scrollBar.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (super.m_6348_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.canScroll) {
            return this.scrollBar.m_6348_(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (super.m_6050_(mouseX, mouseY, amount)) {
            return true;
        }
        if (this.canScroll) {
            return this.scrollBar.m_6050_(mouseX, mouseY, amount);
        }
        return false;
    }
}

