/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.mtrsteamloco;

import cn.zbx1425.mtrsteamloco.Main;
import cn.zbx1425.mtrsteamloco.render.ShadersModHandler;
import cn.zbx1425.sowcer.ContextCapability;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;

public class ClientConfig {
    private static Path path;
    public static boolean disableOptimization;
    public static boolean enableRail3D;
    public static boolean enableRailRender;
    public static boolean enableTrainRender;
    public static boolean enableSmoke;
    public static boolean hideRidingTrain;

    public static void load(Path path) {
        ClientConfig.path = path;
        try {
            JsonObject configObject = Main.JSON_PARSER.parse(Files.readString(path)).getAsJsonObject();
            disableOptimization = configObject.get("shaderCompatMode").getAsBoolean();
            enableRail3D = configObject.get("enableRail3D").getAsBoolean();
            enableRailRender = configObject.get("enableRailRender").getAsBoolean();
            enableTrainRender = configObject.get("enableTrainRender").getAsBoolean();
            enableSmoke = configObject.get("enableSmoke").getAsBoolean();
            hideRidingTrain = configObject.get("hideRidingTrain").getAsBoolean();
        }
        catch (Exception ex) {
            Main.LOGGER.warn("Failed loading client config:", (Throwable)ex);
            ex.printStackTrace();
            ClientConfig.save();
        }
    }

    public static int getRailRenderLevel() {
        boolean cannotInstance;
        boolean bl = cannotInstance = ShadersModHandler.isShaderPackInUse() || !ContextCapability.supportVertexAttribDivisor;
        if (!ClientConfig.useRenderOptimization()) {
            return enableRailRender ? 1 : 0;
        }
        return enableRailRender ? (enableRail3D ? (cannotInstance ? 2 : 3) : 1) : 0;
    }

    public static boolean useRenderOptimization() {
        return !disableOptimization && ShadersModHandler.canUseOptimization();
    }

    public static void save() {
        try {
            if (path == null) {
                return;
            }
            JsonObject configObject = new JsonObject();
            configObject.addProperty("shaderCompatMode", Boolean.valueOf(disableOptimization));
            configObject.addProperty("enableRail3D", Boolean.valueOf(enableRail3D));
            configObject.addProperty("enableRailRender", Boolean.valueOf(enableRailRender));
            configObject.addProperty("enableTrainRender", Boolean.valueOf(enableTrainRender));
            configObject.addProperty("enableSmoke", Boolean.valueOf(enableSmoke));
            configObject.addProperty("hideRidingTrain", Boolean.valueOf(hideRidingTrain));
            Files.writeString(path, (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)configObject), new OpenOption[0]);
        }
        catch (Exception ex) {
            Main.LOGGER.warn("Failed loading client config:", (Throwable)ex);
        }
    }

    public static void load() {
        ClientConfig.load(Minecraft.m_91087_().f_91069_.toPath().resolve("config").resolve("mtrsteamloco.json"));
    }

    static {
        disableOptimization = false;
        enableRail3D = true;
        enableRailRender = true;
        enableTrainRender = true;
        enableSmoke = true;
        hideRidingTrain = false;
    }
}

