/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.mtrsteamloco;

import cn.zbx1425.mtrsteamloco.Main;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JOptionPane;

public class DialogEntryPoint {
    private static final JsonParser JSON_PARSER = new JsonParser();

    public static void main(String[] args) {
        try {
            ZipEntry ze;
            JsonObject paramObj = (JsonObject)JSON_PARSER.parse(new String(Base64.getDecoder().decode(args[0]), StandardCharsets.UTF_8));
            String langKey = paramObj.get("key").getAsString();
            ArrayList<String> langArgs = new ArrayList<String>(paramObj.get("args").getAsJsonArray().size());
            for (int i = 0; i < paramObj.get("args").getAsJsonArray().size(); ++i) {
                langArgs.add(paramObj.get("args").getAsJsonArray().get(i).getAsString());
            }
            CodeSource codeSource = DialogEntryPoint.class.getProtectionDomain().getCodeSource();
            if (codeSource == null) {
                return;
            }
            HashMap<String, String> langEntries = new HashMap<String, String>();
            ZipInputStream zip = new ZipInputStream(codeSource.getLocation().openStream());
            while ((ze = zip.getNextEntry()) != null) {
                String entryName = ze.getName();
                if (!entryName.startsWith("assets/mtrsteamloco/lang") || !entryName.endsWith(".json")) continue;
                String langName = entryName.substring(entryName.lastIndexOf(47) + 1).replace(".json", "");
                JsonObject langObj = (JsonObject)JSON_PARSER.parse(new String(zip.readAllBytes(), StandardCharsets.UTF_8));
                langEntries.put(langName, String.format(langObj.get(langKey).getAsString(), langArgs.toArray(new String[0])));
            }
            String msg = String.join((CharSequence)"\n", Stream.concat(Stream.of((String)langEntries.get("zh_cn")), langEntries.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("zh_cn")).sorted((a, b) -> ((String)b.getKey()).compareTo((String)a.getKey())).map(Map.Entry::getValue)).toList());
            JOptionPane.showMessageDialog(null, msg, "NTE Startup Error", 0);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.toString(), "NTE Startup Error", 0);
        }
    }

    public static void startDialog(String key, String[] args) {
        JsonObject argObj = new JsonObject();
        JsonArray fmtArgsArray = new JsonArray();
        for (String arg : args) {
            fmtArgsArray.add(arg);
        }
        argObj.addProperty("key", key);
        argObj.add("args", (JsonElement)fmtArgsArray);
        try {
            new ProcessBuilder(DialogEntryPoint.getJvmPath(), "-cp", DialogEntryPoint.getClassPaths(), "cn.zbx1425.mtrsteamloco.DialogEntryPoint", Base64.getEncoder().encodeToString(argObj.toString().getBytes(StandardCharsets.UTF_8))).start();
        }
        catch (Exception ex) {
            Main.LOGGER.warn((Object)ex);
        }
    }

    private static String getJvmPath() {
        boolean isRunningOnWindowsPlatform = System.getProperties().getProperty("os.name").toUpperCase().contains("WINDOWS");
        if (isRunningOnWindowsPlatform) {
            return System.getProperties().getProperty("java.home") + File.separator + "bin" + File.separator + "java.exe";
        }
        return System.getProperties().getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    }

    private static String getClassPaths() throws URISyntaxException {
        boolean isRunningOnWindowsPlatform = System.getProperties().getProperty("os.name").toUpperCase().contains("WINDOWS");
        char delimiter = isRunningOnWindowsPlatform ? (char)';' : ':';
        return new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath() + delimiter + new File(JsonObject.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
    }
}

