/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.mtrsteamloco;

import cn.zbx1425.mtrsteamloco.ClientConfig;
import cn.zbx1425.mtrsteamloco.DialogEntryPoint;
import cn.zbx1425.mtrsteamloco.MtrVersion;
import cn.zbx1425.mtrsteamloco.block.BlockDepartureBell;
import cn.zbx1425.mtrsteamloco.block.BlockEyeCandy;
import cn.zbx1425.mtrsteamloco.block.BlockFeedbackBox;
import cn.zbx1425.mtrsteamloco.block.BlockStatisticTurnstile;
import cn.zbx1425.mtrsteamloco.network.PacketUpdateBlockEntity;
import cn.zbx1425.mtrsteamloco.network.PacketVersionCheck;
import com.google.gson.JsonParser;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.function.BiConsumer;
import mtr.CreativeModeTabs;
import mtr.Registry;
import mtr.RegistryObject;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.RegistryUtilities;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Main {
    public static final String MOD_ID = "mtrsteamloco";
    public static final Logger LOGGER;
    public static final JsonParser JSON_PARSER;
    public static final String REQUIRED_MTR_VERSION = "3.1.12";
    public static final boolean enableRegistry;
    public static final RegistryObject<Block> BLOCK_DEPARTURE_BELL;
    public static final RegistryObject<Block> BLOCK_EYE_CANDY;
    public static final RegistryObject<BlockEntityType<BlockEyeCandy.BlockEntityEyeCandy>> BLOCK_ENTITY_TYPE_EYE_CANDY;
    public static final RegistryObject<Block> BLOCK_STATISTIC_TURNSTILE;
    public static final RegistryObject<BlockEntityType<BlockStatisticTurnstile.BlockEntityStatisticTurnstile>> BLOCK_ENTITY_TYPE_STATISTIC_TURNSTILE;
    public static final RegistryObject<Block> BLOCK_FEEDBACK_BOX;
    public static final RegistryObject<BlockEntityType<BlockFeedbackBox.BlockEntityFeedbackBox>> BLOCK_ENTITY_TYPE_FEEDBACK_BOX;
    public static final SoundEvent SOUND_EVENT_BELL;
    public static SimpleParticleType PARTICLE_STEAM_SMOKE;

    public static void init(RegisterBlockItem registerBlockItem, BiConsumer<String, RegistryObject<? extends BlockEntityType<? extends BlockEntityMapper>>> registerBlockEntityType, BiConsumer<String, SoundEvent> registerSoundEvent) {
        if (MtrVersion.parse("1.19.3-3.2.0").compareTo(MtrVersion.parse("-3.1.12")) < 0) {
            DialogEntryPoint.startDialog("gui.mtrsteamloco.mtr_version_low", new String[]{"1.19.3-0.2.3", REQUIRED_MTR_VERSION, "1.19.3-3.2.0"});
            System.exit(1);
        }
        if (enableRegistry) {
            registerBlockItem.accept("departure_bell", BLOCK_DEPARTURE_BELL, CreativeModeTabs.RAILWAY_FACILITIES);
            registerBlockItem.accept("eye_candy", BLOCK_EYE_CANDY, CreativeModeTabs.STATION_BUILDING_BLOCKS);
            registerBlockEntityType.accept("eye_candy", BLOCK_ENTITY_TYPE_EYE_CANDY);
            registerSoundEvent.accept("bell", SOUND_EVENT_BELL);
            Registry.registerNetworkReceiver((ResourceLocation)PacketUpdateBlockEntity.PACKET_UPDATE, PacketUpdateBlockEntity::receiveUpdateC2S);
            Registry.registerPlayerJoinEvent(PacketVersionCheck::sendVersionCheckS2C);
        }
    }

    static {
        boolean enableRegistry1;
        LOGGER = LogManager.getLogger((String)MOD_ID);
        JSON_PARSER = new JsonParser();
        try {
            String jarPath = ClientConfig.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath().toLowerCase(Locale.ROOT);
            enableRegistry1 = !jarPath.endsWith("-client.jar");
        }
        catch (URISyntaxException ignored) {
            enableRegistry1 = true;
        }
        enableRegistry = enableRegistry1;
        BLOCK_DEPARTURE_BELL = new RegistryObject(BlockDepartureBell::new);
        BLOCK_EYE_CANDY = new RegistryObject(BlockEyeCandy::new);
        BLOCK_ENTITY_TYPE_EYE_CANDY = new RegistryObject(() -> RegistryUtilities.getBlockEntityType(BlockEyeCandy.BlockEntityEyeCandy::new, (Block)((Block)BLOCK_EYE_CANDY.get())));
        BLOCK_STATISTIC_TURNSTILE = new RegistryObject(BlockStatisticTurnstile::new);
        BLOCK_ENTITY_TYPE_STATISTIC_TURNSTILE = new RegistryObject(() -> RegistryUtilities.getBlockEntityType(BlockStatisticTurnstile.BlockEntityStatisticTurnstile::new, (Block)((Block)BLOCK_STATISTIC_TURNSTILE.get())));
        BLOCK_FEEDBACK_BOX = new RegistryObject(BlockFeedbackBox::new);
        BLOCK_ENTITY_TYPE_FEEDBACK_BOX = new RegistryObject(() -> RegistryUtilities.getBlockEntityType(BlockFeedbackBox.BlockEntityFeedbackBox::new, (Block)((Block)BLOCK_FEEDBACK_BOX.get())));
        SOUND_EVENT_BELL = RegistryUtilities.createSoundEvent((ResourceLocation)new ResourceLocation("mtrsteamloco:bell"));
    }

    @FunctionalInterface
    public static interface RegisterBlockItem {
        public void accept(String var1, RegistryObject<Block> var2, CreativeModeTabs.Wrapper var3);
    }
}

