/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.mtrsteamloco;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class MtrVersion
implements Comparable<MtrVersion> {
    public final int[] parts;

    private MtrVersion(int[] parts) {
        this.parts = parts;
    }

    public static MtrVersion parse(String src) {
        ArrayList<Integer> parts = new ArrayList<Integer>();
        String[] strParts = src.split("-");
        for (int i2 = 1; i2 < strParts.length; ++i2) {
            String[] subParts;
            for (String subPart : subParts = strParts[i2].split("\\.")) {
                if (!subPart.matches("\\d+")) continue;
                parts.add(Integer.parseInt(subPart));
            }
        }
        return new MtrVersion(parts.stream().mapToInt(i -> i).toArray());
    }

    @Override
    public int compareTo(@NotNull MtrVersion o) {
        for (int i = 0; i < Math.min(this.parts.length, o.parts.length); ++i) {
            if (this.parts[i] == o.parts[i]) continue;
            return Integer.compare(this.parts[i], o.parts[i]);
        }
        return Integer.compare(this.parts.length, o.parts.length);
    }
}

