/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.mtrsteamloco.block;

import cn.zbx1425.mtrsteamloco.Main;
import mtr.SoundEvents;
import mtr.block.IBlock;
import mtr.mappings.BlockDirectionalMapper;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.mappings.Utilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.StringUtils;

public class BlockStatisticTurnstile
extends BlockDirectionalMapper
implements EntityBlockMapper {
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");

    public BlockStatisticTurnstile() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76419_).m_60978_(2.0f).m_60955_());
    }

    public void m_7892_(BlockState state, Level level, BlockPos blockPos, Entity entity) {
        if (!level.f_46443_ && entity instanceof Player) {
            Direction facing = (Direction)IBlock.getStatePropertySafe((BlockState)state, (Property)f_54117_);
            Vec3 playerPosRotated = entity.m_20182_().m_82492_((double)blockPos.m_123341_() + 0.5, 0.0, (double)blockPos.m_123343_() + 0.5).m_82524_((float)Math.toRadians(facing.m_122435_()));
            boolean open = (Boolean)IBlock.getStatePropertySafe((BlockState)state, (Property)OPEN);
            if (open && playerPosRotated.f_82481_ > 0.0) {
                level.m_46597_(blockPos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
            } else if (!open && playerPosRotated.f_82481_ < 0.0) {
                BlockPos mainBlockPos = this.searchMainBlock(level, blockPos);
                BlockEntityStatisticTurnstile blockEntity = (BlockEntityStatisticTurnstile)level.m_7702_(mainBlockPos);
                assert (blockEntity != null);
                level.m_5594_(null, blockPos, SoundEvents.TICKET_BARRIER, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_46597_(blockPos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true)));
                if (!level.m_183326_().m_183582_(blockPos, (Object)this)) {
                    Utilities.scheduleBlockTick((Level)level, (BlockPos)blockPos, (Block)this, (int)40);
                }
            }
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos) {
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_())).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        Direction facing = (Direction)IBlock.getStatePropertySafe((BlockState)state, (Property)f_54117_);
        return IBlock.getVoxelShapeByDirection((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0, (Direction)facing);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        Direction facing = (Direction)IBlock.getStatePropertySafe((BlockState)state, (Property)f_54117_);
        boolean open = (Boolean)IBlock.getStatePropertySafe((BlockState)state, (Property)OPEN);
        VoxelShape base = IBlock.getVoxelShapeByDirection((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)24.0, (double)16.0, (Direction)facing);
        return open ? base : Shapes.m_83110_((VoxelShape)IBlock.getVoxelShapeByDirection((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)24.0, (double)9.0, (Direction)facing), (VoxelShape)base);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, OPEN});
    }

    public BlockPos searchMainBlock(Level level, BlockPos start) {
        BlockPos cursor = new BlockPos((Vec3i)start);
        while (level.m_8055_(cursor.m_122024_()).m_60713_((Block)this)) {
            cursor = cursor.m_122024_();
        }
        while (level.m_8055_(cursor.m_122012_()).m_60713_((Block)this)) {
            cursor = cursor.m_122012_();
        }
        return cursor;
    }

    public BlockEntityMapper createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntityStatisticTurnstile(blockPos, blockState);
    }

    public static class BlockEntityStatisticTurnstile
    extends BlockEntityMapper {
        public String counterName;

        public boolean isActive() {
            return this.counterName != null;
        }

        public BlockEntityStatisticTurnstile(BlockPos pos, BlockState state) {
            super((BlockEntityType)Main.BLOCK_ENTITY_TYPE_STATISTIC_TURNSTILE.get(), pos, state);
        }

        public void readCompoundTag(CompoundTag compoundTag) {
            this.counterName = compoundTag.m_128461_("counterName");
            if (StringUtils.isEmpty((CharSequence)this.counterName)) {
                this.counterName = null;
            }
        }

        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.m_128359_("counterName", this.counterName == null ? "" : this.counterName);
        }
    }
}

