/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.mtrsteamloco.forge;

import cn.zbx1425.mtrsteamloco.Main;
import cn.zbx1425.mtrsteamloco.forge.ClientProxy;
import cn.zbx1425.mtrsteamloco.mappings.ForgeUtilities;
import mtr.CreativeModeTabs;
import mtr.Registry;
import mtr.RegistryObject;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.DeferredRegisterHolder;
import mtr.mappings.RegistryUtilities;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="mtrsteamloco")
public class MainForge {
    private static final DeferredRegisterHolder<Item> ITEMS = new DeferredRegisterHolder("mtrsteamloco", ForgeUtilities.registryGetItem());
    private static final DeferredRegisterHolder<Block> BLOCKS = new DeferredRegisterHolder("mtrsteamloco", ForgeUtilities.registryGetBlock());
    private static final DeferredRegisterHolder<BlockEntityType<?>> BLOCK_ENTITY_TYPES = new DeferredRegisterHolder("mtrsteamloco", ForgeUtilities.registryGetBlockEntityType());
    private static final DeferredRegisterHolder<SoundEvent> SOUND_EVENTS = new DeferredRegisterHolder("mtrsteamloco", ForgeUtilities.registryGetSoundEvent());
    private static final DeferredRegisterHolder<ParticleType<?>> PARTICLE_TYPES = new DeferredRegisterHolder("mtrsteamloco", ForgeUtilities.registryGetParticleType());

    public MainForge() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ForgeUtilities.registerModEventBus("mtrsteamloco", eventBus);
        Main.PARTICLE_STEAM_SMOKE = new SimpleParticleType(true);
        PARTICLE_TYPES.register("steam_smoke", () -> Main.PARTICLE_STEAM_SMOKE);
        ITEMS.register();
        BLOCKS.register();
        BLOCK_ENTITY_TYPES.register();
        SOUND_EVENTS.register();
        PARTICLE_TYPES.register();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            eventBus.register(ClientProxy.ModEventBusListener.class);
            MinecraftForge.EVENT_BUS.register(ClientProxy.ForgeEventBusListener.class);
        });
    }

    private static void registerBlock(String path, RegistryObject<Block> block) {
        BLOCKS.register(path, () -> block.get());
    }

    private static void registerBlock(String path, RegistryObject<Block> block, CreativeModeTabs.Wrapper creativeModeTabWrapper) {
        MainForge.registerBlock(path, block);
        ITEMS.register(path, () -> {
            BlockItem blockItem = new BlockItem((Block)block.get(), RegistryUtilities.createItemProperties(() -> ((CreativeModeTabs.Wrapper)creativeModeTabWrapper).get()));
            Registry.registerCreativeModeTab((ResourceLocation)creativeModeTabWrapper.resourceLocation, (Item)blockItem);
            return blockItem;
        });
    }

    private static void registerBlockEntityType(String path, RegistryObject<? extends BlockEntityType<? extends BlockEntityMapper>> blockEntityType) {
        BLOCK_ENTITY_TYPES.register(path, () -> blockEntityType.get());
    }

    private static void registerSoundEvent(String path, SoundEvent soundEvent) {
        SOUND_EVENTS.register(path, () -> soundEvent);
    }

    static {
        Main.init(MainForge::registerBlock, MainForge::registerBlockEntityType, MainForge::registerSoundEvent);
    }
}

