/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.mtrsteamloco.mixin;

import cn.zbx1425.mtrsteamloco.CustomResources;
import cn.zbx1425.mtrsteamloco.gui.ErrorScreen;
import cn.zbx1425.mtrsteamloco.mixin.TrainClientAccessor;
import cn.zbx1425.mtrsteamloco.render.integration.MtrModelRegistryUtil;
import cn.zbx1425.sowcer.util.GlStateTracker;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import mtr.client.ClientData;
import mtr.client.TrainClientRegistry;
import mtr.render.TrainRendererBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={mtr.client.CustomResources.class})
public class CustomResourcesMixin {
    private static String capturedTextureId = "";

    @Inject(at={@At(value="HEAD")}, method={"reload(Lnet/minecraft/server/packs/resources/ResourceManager;)V"})
    private static void reloadHead(ResourceManager manager, CallbackInfo ci) {
        GlStateTracker.capture();
        MtrModelRegistryUtil.loadingErrorList.clear();
        MtrModelRegistryUtil.resourceManager = manager;
        CustomResources.reset(manager);
    }

    @Inject(at={@At(value="TAIL")}, method={"reload(Lnet/minecraft/server/packs/resources/ResourceManager;)V"})
    private static void reloadTail(ResourceManager manager, CallbackInfo ci) {
        ClientData.TRAINS.forEach(train -> {
            TrainRendererBase renderer = TrainClientRegistry.getTrainProperties((String)train.trainId).renderer;
            ((TrainClientAccessor)train).setTrainRenderer(renderer.createTrainInstance(train));
        });
        if (MtrModelRegistryUtil.loadingErrorList.size() > 0) {
            Minecraft.m_91087_().m_91152_((Screen)new ErrorScreen(MtrModelRegistryUtil.loadingErrorList, Minecraft.m_91087_().f_91080_));
        }
        GlStateTracker.restore();
    }

    @Inject(at={@At(value="HEAD")}, method={"readResource"}, cancellable=true)
    private static void readResource(ResourceManager manager, String path, Consumer<JsonObject> callback, CallbackInfo ci) {
        if (path.toLowerCase(Locale.ROOT).endsWith(".obj") || path.contains("|")) {
            JsonObject dummyBbData = MtrModelRegistryUtil.createDummyBbDataPack(path, capturedTextureId);
            callback.accept(dummyBbData);
            ci.cancel();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getOrDefault"}, remap=false)
    private static <T> void getOrDefault(JsonObject jsonObject, String key, T defaultValue, Function<JsonElement, T> function, CallbackInfoReturnable<T> cir) {
        if (key.equals("texture_id")) {
            capturedTextureId = jsonObject.has(key) ? jsonObject.get(key).getAsString() : defaultValue.toString();
        }
    }
}

