/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.mtrsteamloco.mixin;

import cn.zbx1425.mtrsteamloco.render.integration.MtrModelRegistryUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import mtr.client.DynamicTrainModel;
import mtr.client.ResourcePackCreatorProperties;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ResourcePackCreatorProperties.class})
public class ResourcePackCreatorPropertiesMixin {
    @Shadow(remap=false)
    private JsonObject modelObject;
    @Shadow(remap=false)
    private DynamicTrainModel model;

    @Inject(method={"readJson"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void readJson(Path path, BiConsumer<String, JsonObject> jsonCallback, CallbackInfo ci) {
        if (path.toString().toLowerCase(Locale.ROOT).endsWith(".obj")) {
            jsonCallback.accept(path.getFileName().toString(), MtrModelRegistryUtil.createDummyBbDataExternal(path.toString()));
            ci.cancel();
        }
    }

    @Inject(method={"updateModel"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void updateModelHead(CallbackInfo ci) {
        if (this.modelObject.size() == 0) {
            ci.cancel();
            return;
        }
        if (MtrModelRegistryUtil.getDummyBbDataType(this.modelObject) > 0) {
            this.modelObject.remove("outliner");
            this.modelObject.add("outliner", (JsonElement)new JsonArray());
        }
    }

    @Inject(method={"updateModel"}, at={@At(value="TAIL")}, remap=false)
    private void updateModelTail(CallbackInfo ci) {
        if (MtrModelRegistryUtil.getDummyBbDataType(this.modelObject) > 0) {
            JsonArray outlinerArray = new JsonArray();
            for (Map.Entry entry : this.model.parts.entrySet()) {
                JsonObject elementObject = new JsonObject();
                elementObject.addProperty("name", (String)entry.getKey());
                outlinerArray.add((JsonElement)elementObject);
            }
            this.modelObject.remove("outliner");
            this.modelObject.add("outliner", (JsonElement)outlinerArray);
        }
    }
}

