/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.mtrsteamloco.render;

import cn.zbx1425.mtrsteamloco.mixin.RailAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import mtr.Blocks;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.Rail;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.StringUtils;

public class RailPicker {
    public static Rail pickedRail;
    public static BlockPos pickedPosStart;
    public static BlockPos pickedPosEnd;

    public static void pick() {
        BlockPos pos;
        pickedRail = null;
        Minecraft minecraft = Minecraft.m_91087_();
        Entity entity = minecraft.m_91288_();
        if (entity == null || minecraft.f_91073_ == null) {
            return;
        }
        HitResult hitResult = entity.m_19907_(20.0, 0.0f, false);
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        pickedPosStart = pos = ((BlockHitResult)hitResult).m_82425_();
        BlockState blockState = minecraft.f_91073_.m_8055_(pos);
        if (!blockState.m_60713_((Block)Blocks.RAIL_NODE.get())) {
            return;
        }
        if (ClientData.RAILS.get(pos) == null) {
            return;
        }
        Optional<Map.Entry> closestEntry = ((Map)ClientData.RAILS.get(pos)).entrySet().stream().min(Comparator.comparingDouble(entry -> Mth.m_14145_((float)((float)(-Math.toDegrees(Math.atan2(((BlockPos)entry.getKey()).m_123341_() - pos.m_123341_(), ((BlockPos)entry.getKey()).m_123343_() - pos.m_123343_())))), (float)entity.m_146908_())));
        if (closestEntry.isEmpty()) {
            return;
        }
        pickedPosEnd = (BlockPos)closestEntry.get().getKey();
        pickedRail = (Rail)closestEntry.get().getValue();
    }

    public static void render(PoseStack matrices, MultiBufferSource vertexConsumers) {
        if (pickedRail == null) {
            return;
        }
        RailAccessor rail = (RailAccessor)pickedRail;
        double length = pickedRail.getLength();
        double gradient = Math.abs(rail.invokeGetPositionY(length / 2.0 - 0.5) - rail.invokeGetPositionY(length / 2.0 + 0.5)) * 1000.0;
        double radius = !rail.getIsStraight1() && !rail.getIsStraight2() ? Math.min(rail.getR1(), rail.getR2()) : (!rail.getIsStraight1() ? rail.getR1() : (!rail.getIsStraight2() ? rail.getR2() : 0.0));
        String[] contents = new String[]{String.format("L%.1fm", pickedRail.getLength()), String.format("R%.1fm P%.1f\u2030", radius, gradient)};
        matrices.m_85836_();
        matrices.m_252880_((float)pickedPosStart.m_123341_(), (float)pickedPosStart.m_123342_(), (float)pickedPosStart.m_123343_());
        matrices.m_85837_(0.5, 0.5, 0.5);
        matrices.m_252781_(Minecraft.m_91087_().f_91063_.m_109153_().m_253121_());
        matrices.m_85841_(-0.025f, -0.025f, 0.025f);
        float opacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int bgColor = (int)(opacity * 255.0f) << 24;
        Font font = Minecraft.m_91087_().f_91062_;
        int n = -contents.length / 2;
        Objects.requireNonNull(font);
        int yOffset = n * 9;
        for (String text : contents) {
            if (text != null && !StringUtils.isEmpty((CharSequence)text)) {
                float xOffset = -font.m_92895_(text) / 2;
                font.m_252905_(text, xOffset, (float)yOffset, -1, false, matrices.m_85850_().m_252922_(), vertexConsumers, false, bgColor, 0xF000F0);
            }
            Objects.requireNonNull(font);
            yOffset += 9 + 2;
        }
        matrices.m_85849_();
        IDrawing.drawLine((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (float)((float)pickedPosStart.m_123341_() + 0.5f), (float)((float)pickedPosStart.m_123342_() + 0.2f), (float)((float)pickedPosStart.m_123343_() + 0.5f), (float)((float)pickedPosEnd.m_123341_() + 0.5f), (float)((float)pickedPosEnd.m_123342_() + 0.2f), (float)((float)pickedPosEnd.m_123343_() + 0.5f), (int)255, (int)255, (int)180);
    }
}

