/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.mtrsteamloco.render;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.BooleanSupplier;

public final class ShadersModHandler {
    private static InternalHandler internalHandler;

    public static void init() {
        Class<?> ignored2;
        internalHandler = new InternalHandler(){};
        try {
            ignored2 = Class.forName("optifine.Installer");
            internalHandler = new Optifine();
        }
        catch (Exception ignored2) {
            // empty catch block
        }
        try {
            ignored2 = Class.forName("net.irisshaders.iris.api.v0.IrisApi");
            internalHandler = new Oculus();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isShaderPackInUse() {
        return internalHandler.isShaderPackInUse();
    }

    public static boolean canUseOptimization() {
        return !(internalHandler instanceof Optifine) || !ShadersModHandler.isShaderPackInUse();
    }

    private static interface InternalHandler {
        default public boolean isShaderPackInUse() {
            return false;
        }
    }

    private static class Optifine
    implements InternalHandler {
        private final BooleanSupplier shadersEnabledSupplier = Optifine.createShadersEnabledSupplier();

        Optifine() {
        }

        @Override
        public boolean isShaderPackInUse() {
            return this.shadersEnabledSupplier.getAsBoolean();
        }

        private static BooleanSupplier createShadersEnabledSupplier() {
            try {
                Class<?> ofShaders = Class.forName("net.optifine.shaders.Shaders");
                Field field = ofShaders.getDeclaredField("activeProgramID");
                return () -> {
                    try {
                        return (Integer)field.get(null) != 0;
                    }
                    catch (IllegalAccessException ignored) {
                        return false;
                    }
                };
            }
            catch (Exception ignored) {
                return () -> false;
            }
        }
    }

    private static class Oculus
    implements InternalHandler {
        private final BooleanSupplier shadersEnabledSupplier = Oculus.createShadersEnabledSupplier();

        Oculus() {
        }

        @Override
        public boolean isShaderPackInUse() {
            return this.shadersEnabledSupplier.getAsBoolean();
        }

        private static BooleanSupplier createShadersEnabledSupplier() {
            try {
                Class<?> irisApiClass = Class.forName("net.irisshaders.iris.api.v0.IrisApi");
                Object irisApiInstance = irisApiClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                Method fnIsShaderPackInUse = irisApiClass.getMethod("isShaderPackInUse", new Class[0]);
                return () -> {
                    try {
                        return (Boolean)fnIsShaderPackInUse.invoke(irisApiInstance, new Object[0]);
                    }
                    catch (Exception ignored) {
                        return false;
                    }
                };
            }
            catch (Exception ignored) {
                return () -> false;
            }
        }
    }
}

