/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.mtrsteamloco.render.integration;

import cn.zbx1425.mtrsteamloco.Main;
import cn.zbx1425.mtrsteamloco.MainClient;
import cn.zbx1425.mtrsteamloco.render.integration.MtrModelRegistryUtil;
import cn.zbx1425.mtrsteamloco.render.integration.SowcerModelAgent;
import cn.zbx1425.sowcer.math.Vector3f;
import cn.zbx1425.sowcer.util.GlStateTracker;
import cn.zbx1425.sowcerext.model.RawModel;
import cn.zbx1425.sowcerext.model.loader.ObjModelLoader;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import mtr.client.DynamicTrainModel;
import mtr.client.ResourcePackCreatorProperties;
import mtr.data.EnumHelper;
import mtr.model.ModelTrainBase;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class DynamicTrainModelLoader {
    private static Map<String, RawModel> cachedModels;
    private static String cachedPath;
    private static long cachedPathMtime;

    public static void loadInto(JsonObject model, DynamicTrainModel target) {
        if (MtrModelRegistryUtil.isDummyBbData(model)) {
            int bbDataType = MtrModelRegistryUtil.getDummyBbDataType(model);
            target.parts.clear();
            try {
                boolean isLoadingFromEditor;
                if (target.properties.has("atlasIndex")) {
                    MainClient.atlasManager.load(MtrModelRegistryUtil.resourceManager, new ResourceLocation(target.properties.get("atlasIndex").getAsString()));
                }
                Map<Object, Object> models = new HashMap();
                if (bbDataType == 1) {
                    String modelLocations = MtrModelRegistryUtil.getPathFromDummyBbData(model);
                    if (modelLocations.contains("|")) {
                        String modelLocationName;
                        boolean isModelReversed;
                        String[] extraAttribs;
                        ResourceLocation modelLocation;
                        int i;
                        String[] rlListPairs = modelLocations.split("\\|");
                        ArrayList<JsonObject> arrayList = new ArrayList<JsonObject>();
                        target.properties.get("parts").getAsJsonArray().forEach(elem -> previousParts.add(elem.getAsJsonObject()));
                        JsonArray newParts = new JsonArray();
                        for (i = 0; i < rlListPairs.length / 2; ++i) {
                            modelLocation = new ResourceLocation((String)rlListPairs[i * 2]);
                            extraAttribs = ((String)rlListPairs[i * 2 + 1]).split(";", -1)[2].split(",");
                            isModelReversed = Arrays.asList(extraAttribs).contains("reversed");
                            modelLocationName = modelLocation.m_135815_().substring(modelLocation.m_135815_().lastIndexOf(47) + 1) + (isModelReversed ? "/reversed" : "");
                            Map<String, RawModel> modelParts = ObjModelLoader.loadModels(MtrModelRegistryUtil.resourceManager, modelLocation, MainClient.atlasManager);
                            for (Map.Entry<String, RawModel> entry : modelParts.entrySet()) {
                                if (isModelReversed) {
                                    entry.getValue().sourceLocation = new ResourceLocation(entry.getValue().sourceLocation.toString().substring(0, entry.getValue().sourceLocation.toString().lastIndexOf("/")) + "/reversed" + entry.getValue().sourceLocation.toString().substring(entry.getValue().sourceLocation.toString().lastIndexOf("/")));
                                    entry.getValue().applyRotation(new Vector3f(0.0f, 1.0f, 0.0f), 180.0f);
                                }
                                models.put(modelLocationName + "/" + entry.getKey(), entry.getValue());
                            }
                            arrayList.forEach(elem -> {
                                if (elem.get("name").getAsString().startsWith(modelLocationName)) {
                                    newParts.add((JsonElement)elem);
                                }
                            });
                            arrayList.removeIf(elem -> elem.get("name").getAsString().startsWith(modelLocationName));
                        }
                        for (i = 0; i < rlListPairs.length / 2; ++i) {
                            modelLocation = new ResourceLocation((String)rlListPairs[i * 2]);
                            extraAttribs = ((String)rlListPairs[i * 2 + 1]).split(";", -1)[2].split(",");
                            isModelReversed = Arrays.asList(extraAttribs).contains("reversed");
                            modelLocationName = modelLocation.m_135815_().substring(modelLocation.m_135815_().lastIndexOf(47) + 1) + (isModelReversed ? "/reversed" : "");
                            String whiteList = ((String)rlListPairs[i * 2 + 1]).split(";", -1)[0];
                            String blackList = ((String)rlListPairs[i * 2 + 1]).split(";", -1)[1];
                            for (JsonObject part : arrayList) {
                                JsonObject newPartObj = (JsonObject)new JsonParser().parse(part.toString());
                                String previousName = newPartObj.get("name").getAsString();
                                newPartObj.remove("name");
                                newPartObj.addProperty("name", modelLocationName + "/" + previousName);
                                newPartObj.remove("whitelisted_cars");
                                newPartObj.addProperty("whitelisted_cars", whiteList);
                                newPartObj.remove("blacklisted_cars");
                                newPartObj.addProperty("blacklisted_cars", blackList);
                                if (isModelReversed) {
                                    ResourcePackCreatorProperties.DoorOffset newDoorOffset = (ResourcePackCreatorProperties.DoorOffset)EnumHelper.valueOf((Enum)ResourcePackCreatorProperties.DoorOffset.NONE, (String)newPartObj.get("door_offset").getAsString().toUpperCase(Locale.ROOT));
                                    switch (newDoorOffset) {
                                        case LEFT_POSITIVE: {
                                            newDoorOffset = ResourcePackCreatorProperties.DoorOffset.RIGHT_NEGATIVE;
                                            break;
                                        }
                                        case RIGHT_POSITIVE: {
                                            newDoorOffset = ResourcePackCreatorProperties.DoorOffset.LEFT_NEGATIVE;
                                            break;
                                        }
                                        case LEFT_NEGATIVE: {
                                            newDoorOffset = ResourcePackCreatorProperties.DoorOffset.RIGHT_POSITIVE;
                                            break;
                                        }
                                        case RIGHT_NEGATIVE: {
                                            newDoorOffset = ResourcePackCreatorProperties.DoorOffset.LEFT_POSITIVE;
                                        }
                                    }
                                    newPartObj.remove("door_offset");
                                    newPartObj.addProperty("door_offset", newDoorOffset.toString());
                                    ResourcePackCreatorProperties.RenderCondition newRenderCondition = (ResourcePackCreatorProperties.RenderCondition)EnumHelper.valueOf((Enum)ResourcePackCreatorProperties.RenderCondition.ALL, (String)newPartObj.get("render_condition").getAsString().toUpperCase(Locale.ROOT));
                                    switch (newRenderCondition) {
                                        case DOOR_LEFT_OPEN: {
                                            newRenderCondition = ResourcePackCreatorProperties.RenderCondition.DOOR_RIGHT_OPEN;
                                            break;
                                        }
                                        case DOOR_RIGHT_OPEN: {
                                            newRenderCondition = ResourcePackCreatorProperties.RenderCondition.DOOR_LEFT_OPEN;
                                            break;
                                        }
                                        case DOOR_LEFT_CLOSED: {
                                            newRenderCondition = ResourcePackCreatorProperties.RenderCondition.DOOR_RIGHT_CLOSED;
                                            break;
                                        }
                                        case DOOR_RIGHT_CLOSED: {
                                            newRenderCondition = ResourcePackCreatorProperties.RenderCondition.DOOR_LEFT_CLOSED;
                                        }
                                    }
                                    newPartObj.remove("render_condition");
                                    newPartObj.addProperty("render_condition", newRenderCondition.toString());
                                }
                                newParts.add((JsonElement)newPartObj);
                            }
                        }
                        target.properties.remove("parts");
                        target.properties.add("parts", (JsonElement)newParts);
                    } else {
                        models = ObjModelLoader.loadModels(MtrModelRegistryUtil.resourceManager, new ResourceLocation(modelLocations), MainClient.atlasManager);
                    }
                } else {
                    String path = MtrModelRegistryUtil.getPathFromDummyBbData(model);
                    if (cachedModels == null || !path.equals(cachedPath) || new File(path).lastModified() != cachedPathMtime) {
                        MainClient.modelManager.clearNamespace("mtrsteamloco-external");
                        cachedModels = ObjModelLoader.loadExternalModels(MtrModelRegistryUtil.getPathFromDummyBbData(model), MainClient.atlasManager);
                        for (RawModel rawModel : cachedModels.values()) {
                            rawModel.replaceAllTexture(MtrModelRegistryUtil.PLACEHOLDER_TILE_TEXTURE_LOCATION);
                        }
                        cachedPath = path;
                        cachedPathMtime = new File(path).lastModified();
                    }
                    models = cachedModels;
                }
                String repaintTexture = MtrModelRegistryUtil.getTextureIdFromDummyBbData(model);
                if (!StringUtils.isEmpty((CharSequence)repaintTexture)) {
                    for (RawModel rawModel : models.values()) {
                        rawModel.replaceAllTexture("default.png", new ResourceLocation(repaintTexture));
                    }
                }
                JsonArray propertyParts = target.properties.getAsJsonArray("parts");
                Map<Object, Object> map = models;
                propertyParts.forEach(jsonElement -> {
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    String name = jsonObject.get("name").getAsString();
                    RawModel partModel = finalModels.getOrDefault(name, null);
                    if (partModel != null) {
                        ModelTrainBase.RenderStage renderStage = (ModelTrainBase.RenderStage)EnumHelper.valueOf((Enum)ModelTrainBase.RenderStage.EXTERIOR, (String)jsonObject.get("stage").getAsString().toUpperCase(Locale.ROOT));
                        switch (renderStage) {
                            case EXTERIOR: {
                                partModel.setAllRenderType("reset");
                                break;
                            }
                            case INTERIOR: {
                                partModel.setAllRenderType("interior");
                                break;
                            }
                            case INTERIOR_TRANSLUCENT: {
                                partModel.setAllRenderType("interiortranslucent");
                                break;
                            }
                            case LIGHTS: 
                            case ALWAYS_ON_LIGHTS: {
                                partModel.setAllRenderType("light");
                            }
                        }
                    }
                });
                boolean bl = isLoadingFromEditor = !GlStateTracker.isStateProtected;
                if (isLoadingFromEditor) {
                    GlStateTracker.capture();
                }
                for (Map.Entry<Object, Object> entry : models.entrySet()) {
                    target.parts.put((String)entry.getKey(), new SowcerModelAgent((RawModel)entry.getValue()));
                }
                if (isLoadingFromEditor) {
                    GlStateTracker.restore();
                }
            }
            catch (Exception e) {
                Main.LOGGER.error("Failed loading OBJ into DynamicTrainModel", (Throwable)e);
                MtrModelRegistryUtil.loadingErrorList.add(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    static {
        cachedPathMtime = 0L;
    }
}

