/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.mtrsteamloco.render.rail;

import cn.zbx1425.sowcer.math.Matrix4f;
import cn.zbx1425.sowcer.util.AttrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import mtr.data.Rail;
import mtr.data.RailType;
import net.minecraft.util.Mth;

public class BakedRail {
    public HashMap<Long, ArrayList<Matrix4f>> coveredChunks = new HashMap();
    public static final int POS_SHIFT = 1;
    public String modelKey;
    public int color;

    public BakedRail(Rail rail) {
        this.modelKey = rail.railType == RailType.SIDING ? "rail_siding" : "rail";
        this.color = AttrUtil.argbToBgr(rail.railType.color | 0xFF000000);
        rail.render((x1, z1, x2, z2, x3, z3, x4, z4, y1, y2) -> {
            float xc = (float)((x1 + x4) / 2.0);
            float yc = (float)((y1 + y2) / 2.0);
            float zc = (float)((z1 + z4) / 2.0);
            this.coveredChunks.computeIfAbsent(BakedRail.chunkIdFromWorldPos(Mth.m_14143_((float)xc), Mth.m_14143_((float)zc)), ignored -> new ArrayList()).add(BakedRail.getLookAtMat(xc, yc, zc, (float)x4, (float)y2, (float)z4, 0.25f));
        }, 0.0f, 0.0f);
    }

    public static long chunkIdFromWorldPos(float bpX, float bpZ) {
        return (long)((int)bpX >> 5) << 32 | (long)((int)bpZ >> 5) & 0xFFFFFFFFL;
    }

    public static long chunkIdFromSectPos(int spX, int spZ) {
        return (long)(spX >> 1) << 32 | (long)(spZ >> 1) & 0xFFFFFFFFL;
    }

    public static Matrix4f getLookAtMat(float posX, float posY, float posZ, float tgX, float tgY, float tgZ, float len) {
        Matrix4f matrix4f = Matrix4f.translation(posX, posY, posZ);
        float yaw = (float)Mth.m_14136_((double)(tgX - posX), (double)(tgZ - posZ));
        float pitch = (float)Math.asin((tgY - posY) * (1.0f / len));
        matrix4f.rotateY((float)Math.PI + yaw);
        matrix4f.rotateX(pitch);
        return matrix4f;
    }
}

