/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.mtrsteamloco.render.rail;

import cn.zbx1425.mtrsteamloco.ClientConfig;
import cn.zbx1425.mtrsteamloco.data.RailModelRegistry;
import cn.zbx1425.mtrsteamloco.mixin.LevelRendererAccessor;
import cn.zbx1425.mtrsteamloco.render.rail.BakedRail;
import cn.zbx1425.mtrsteamloco.render.rail.InstancedRailChunk;
import cn.zbx1425.mtrsteamloco.render.rail.MeshBuildingRailChunk;
import cn.zbx1425.mtrsteamloco.render.rail.RailChunkBase;
import cn.zbx1425.mtrsteamloco.render.rail.RailWrapper;
import cn.zbx1425.sowcer.batch.BatchManager;
import cn.zbx1425.sowcer.batch.ShaderProp;
import cn.zbx1425.sowcer.math.Matrix4f;
import cn.zbx1425.sowcer.math.Vector3f;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import mtr.data.Rail;
import mtr.data.RailType;
import mtr.render.RenderTrains;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class RailRenderDispatcher {
    private final HashMap<RailWrapper, BakedRail> railRefMap = new HashMap();
    private final HashMap<String, HashMap<Long, RailChunkBase>> railChunkMap = new HashMap();
    private boolean isInstanced;
    private final HashSet<RailWrapper> currentFrameRails = new HashSet();
    public static boolean isHoldingRailItem = false;

    private void addRail(RailWrapper rail) {
        if (this.railRefMap.containsKey(rail)) {
            return;
        }
        BakedRail bakedRail = new BakedRail(rail.rail);
        this.railRefMap.put(rail, bakedRail);
        HashMap<Long, RailChunkBase> chunkMap = this.railChunkMap.get(bakedRail.modelKey);
        if (chunkMap == null) {
            return;
        }
        for (long chunkId : bakedRail.coveredChunks.keySet()) {
            chunkMap.computeIfAbsent(chunkId, ignored -> {
                if (this.isInstanced) {
                    return new InstancedRailChunk((Long)chunkId, bakedRail.modelKey);
                }
                return new MeshBuildingRailChunk((Long)chunkId, bakedRail.modelKey);
            }).addRail(bakedRail);
        }
    }

    private void removeRail(RailWrapper rail) {
        if (!this.railRefMap.containsKey(rail)) {
            return;
        }
        BakedRail bakedRail = this.railRefMap.get(rail);
        this.railRefMap.remove(rail);
        HashMap<Long, RailChunkBase> chunkMap = this.railChunkMap.get(bakedRail.modelKey);
        if (chunkMap == null) {
            return;
        }
        for (long chunkId : bakedRail.coveredChunks.keySet()) {
            chunkMap.get(chunkId).removeRail(bakedRail);
        }
    }

    public void registerRail(Rail rail) {
        if (rail.railType == RailType.NONE) {
            return;
        }
        this.currentFrameRails.add(new RailWrapper(rail));
    }

    public void clearRail() {
        this.currentFrameRails.clear();
        this.railRefMap.clear();
        for (HashMap<Long, RailChunkBase> chunkMap : this.railChunkMap.values()) {
            for (RailChunkBase chunk : chunkMap.values()) {
                chunk.close();
            }
            chunkMap.clear();
        }
        this.railChunkMap.clear();
        for (String key : RailModelRegistry.rawElements.keySet()) {
            this.railChunkMap.put(key, new HashMap());
        }
    }

    public void registerLightUpdate(int x, int yMin, int yMax, int z) {
        long chunkId = BakedRail.chunkIdFromSectPos(x, z);
        for (HashMap<Long, RailChunkBase> chunkMap : this.railChunkMap.values()) {
            RailChunkBase chunk = chunkMap.get(chunkId);
            if (chunk == null || chunk.isDirty || !chunk.containsYSection(yMin, yMax)) continue;
            chunk.isDirty = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateAndEnqueueAll(Level level, BatchManager batchManager, Matrix4f viewMatrix) {
        boolean shouldBeInstanced;
        isHoldingRailItem = Minecraft.m_91087_().f_91074_ != null && RenderTrains.isHoldingRailRelated((Player)Minecraft.m_91087_().f_91074_);
        boolean bl = shouldBeInstanced = ClientConfig.getRailRenderLevel() == 3;
        if (this.isInstanced != shouldBeInstanced) {
            this.clearRail();
        }
        this.isInstanced = shouldBeInstanced;
        HashSet<RailWrapper> railsToAdd = new HashSet<RailWrapper>(this.currentFrameRails);
        railsToAdd.removeAll(this.railRefMap.keySet());
        for (RailWrapper railWrapper : railsToAdd) {
            this.addRail(railWrapper);
        }
        HashSet<RailWrapper> railsToRemove = new HashSet<RailWrapper>(this.railRefMap.keySet());
        railsToRemove.removeAll(this.currentFrameRails);
        for (RailWrapper rail : railsToRemove) {
            this.removeRail(rail);
        }
        this.currentFrameRails.clear();
        boolean bl2 = false;
        Frustum cullingFrustum = ((LevelRendererAccessor)Minecraft.m_91087_().f_91060_).getCullingFrustum();
        ShaderProp shaderProp = new ShaderProp().setViewMatrix(viewMatrix);
        for (HashMap<Long, RailChunkBase> chunkMap : this.railChunkMap.values()) {
            Iterator<Map.Entry<Long, RailChunkBase>> it = chunkMap.entrySet().iterator();
            while (it.hasNext()) {
                RailChunkBase chunk = it.next().getValue();
                if (chunk.containingRails.size() == 0) {
                    chunk.close();
                    it.remove();
                    continue;
                }
                if (chunk.isDirty) {
                    void var7_10;
                    if (var7_10 < true) {
                        chunk.rebuildBuffer(level);
                    }
                    ++var7_10;
                }
                if (!cullingFrustum.m_113029_(chunk.boundingBox)) continue;
                chunk.enqueue(batchManager, shaderProp);
            }
        }
    }

    public void drawBoundingBoxes(PoseStack matrixStack, VertexConsumer buffer) {
        for (HashMap<Long, RailChunkBase> chunkMap : this.railChunkMap.values()) {
            for (RailChunkBase chunk : chunkMap.values()) {
                boolean isChunkEven = chunk.isEven();
                LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)buffer, (AABB)chunk.boundingBox, (float)1.0f, (float)(isChunkEven ? 1.0f : 0.0f), (float)(isChunkEven ? 0.0f : 1.0f), (float)1.0f);
                for (ArrayList<Matrix4f> rail : chunk.containingRails.values()) {
                    for (Matrix4f pieceMat : rail) {
                        Vector3f lightPos = pieceMat.getTranslationPart();
                        BlockPos lightBlockPos = new BlockPos((double)lightPos.x(), (double)lightPos.y() + 0.1, (double)lightPos.z());
                        LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)buffer, (AABB)new AABB(lightBlockPos), (float)1.0f, (float)(isChunkEven ? 1.0f : 0.0f), (float)(isChunkEven ? 0.0f : 1.0f), (float)1.0f);
                    }
                }
            }
        }
    }
}

