/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.mtrsteamloco.render.train;

import cn.zbx1425.mtrsteamloco.Main;
import cn.zbx1425.mtrsteamloco.MainClient;
import cn.zbx1425.mtrsteamloco.render.RenderUtil;
import cn.zbx1425.mtrsteamloco.render.train.RenderTrainDK3Mini;
import cn.zbx1425.sowcer.math.Matrix4f;
import cn.zbx1425.sowcer.math.PoseStackUtil;
import cn.zbx1425.sowcerext.multipart.MultipartContainer;
import cn.zbx1425.sowcerext.multipart.MultipartUpdateProp;
import cn.zbx1425.sowcerext.multipart.animated.AnimatedLoader;
import cn.zbx1425.sowcerext.multipart.mi.MiLoader;
import cn.zbx1425.sowcerext.multipart.mi.MiScheduleHelper;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import mtr.MTRClient;
import mtr.client.TrainClientRegistry;
import mtr.client.TrainProperties;
import mtr.data.TrainClient;
import mtr.model.ModelBogie;
import mtr.render.TrainRendererBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public class RenderTrainDK3
extends TrainRendererBase {
    private static final MultipartContainer[] models = new MultipartContainer[4];
    protected final TrainClient train;
    protected final MultipartUpdateProp updateProp = new MultipartUpdateProp();
    protected final MiScheduleHelper scheduleHelper = new MiScheduleHelper();
    protected static final int MODEL_BODY_HEAD = 0;
    protected static final int MODEL_BODY_TAIL = 1;
    protected static final int MODEL_AUX_HEAD = 2;
    protected static final int MODEL_AUX_TAIL = 3;
    private final ImmutableSet<String> HIDE_LIST_MIDDLE = ImmutableSet.builder().add((Object[])new String[]{"conductor", "driver", "cabdoorl", "cabdoorr"}).build();
    private final ImmutableSet<String> HIDE_LIST_TAIL = ImmutableSet.builder().add((Object[])new String[]{"cabdoorlnm", "cabdoorrnm"}).build();
    private final ImmutableSet<String> HIDE_LIST_HEAD = ImmutableSet.builder().add((Object[])new String[]{"cabdoorl", "cabdoorr"}).build();
    private float elapsedDwellTicks = 0.0f;
    private float totalDwellTicks = 0.0f;
    private float lastRenderedTick = 0.0f;
    private static final ModelBogie MODEL_BOGIE = new ModelBogie();

    public static void initGLModel(ResourceManager resourceManager) {
        try {
            MainClient.atlasManager.load(resourceManager, new ResourceLocation("mtrsteamloco:models/atlas/dk3.json"));
            RenderTrainDK3.models[0] = AnimatedLoader.loadModel(resourceManager, MainClient.modelManager, MainClient.atlasManager, new ResourceLocation("mtrsteamloco:models/dk3/ch.animated"));
            RenderTrainDK3.models[1] = AnimatedLoader.loadModel(resourceManager, MainClient.modelManager, MainClient.atlasManager, new ResourceLocation("mtrsteamloco:models/dk3/c.animated"));
            RenderTrainDK3.models[2] = MiLoader.loadModel(resourceManager, MainClient.modelManager, MainClient.atlasManager, new ResourceLocation("mtrsteamloco:models/alex/dk3auxhead.json"));
            RenderTrainDK3.models[3] = MiLoader.loadModel(resourceManager, MainClient.modelManager, MainClient.atlasManager, new ResourceLocation("mtrsteamloco:models/alex/dk3auxtail.json"));
        }
        catch (IOException e) {
            Main.LOGGER.error("Failed loading model for DK3 regular:", (Throwable)e);
        }
    }

    protected MultipartContainer getModel(int index) {
        return models[index];
    }

    public RenderTrainDK3(TrainClient train) {
        this.train = train;
    }

    public TrainRendererBase createTrainInstance(TrainClient trainClient) {
        return new RenderTrainDK3(trainClient);
    }

    public void renderCar(int carIndex, double x, double y, double z, float yaw, float pitch, boolean doorLeftOpen, boolean doorRightOpen) {
        boolean isTail;
        if (RenderUtil.shouldSkipRenderTrain(this.train)) {
            return;
        }
        int carNum = !this.train.isReversed() ? carIndex : this.train.trainCars - carIndex - 1;
        boolean bl = isTail = carNum % 2 != 0 || carNum == this.train.trainCars - 1;
        if (this.train.spacing == 20 && carIndex == 2) {
            isTail = true;
        }
        if (isTranslucentBatch) {
            return;
        }
        BlockPos posAverage = RenderTrainDK3.applyAverageTransform((Vec3)this.train.getViewOffset(), (double)x, (double)y, (double)z);
        if (posAverage == null) {
            return;
        }
        float lastFrameDuration = MTRClient.getLastFrameDuration();
        float ticksElapsed = Minecraft.m_91087_().m_91104_() || this.lastRenderedTick == MTRClient.getGameTick() ? 0.0f : lastFrameDuration;
        this.lastRenderedTick = MTRClient.getGameTick();
        this.elapsedDwellTicks += ticksElapsed;
        if (this.train.justOpening()) {
            this.elapsedDwellTicks = 0.0f;
            this.totalDwellTicks = this.train.getTotalDwellTicks();
        }
        float dwellTicks = this.totalDwellTicks - 20.0f;
        float stopTicks = this.elapsedDwellTicks;
        if (this.train.getDoorValue() == 0.0f) {
            doorLeftOpen = false;
            doorRightOpen = false;
        }
        if (this.train.isReversed()) {
            boolean t = doorLeftOpen;
            doorLeftOpen = doorRightOpen;
            doorRightOpen = t;
        }
        if (doorLeftOpen || doorRightOpen) {
            if (stopTicks > dwellTicks - 240.0f) {
                if (doorLeftOpen) {
                    this.scheduleHelper.play(18.0f - (dwellTicks - stopTicks) / 20.0f, 26.0f);
                } else {
                    this.scheduleHelper.play(46.0f - (dwellTicks - stopTicks) / 20.0f, 54.0f);
                }
            } else if (stopTicks < 120.0f) {
                if (doorLeftOpen) {
                    this.scheduleHelper.play(stopTicks / 20.0f, 6.0f);
                } else {
                    this.scheduleHelper.play(28.0f + stopTicks / 20.0f, 34.0f);
                }
            } else if (doorLeftOpen) {
                this.scheduleHelper.play(6.0f, 6.0f);
            } else {
                this.scheduleHelper.play(34.0f, 34.0f);
            }
        } else if (stopTicks > dwellTicks + 160.0f) {
            this.scheduleHelper.play(0.0f, 0.0f);
        }
        matrices.m_85836_();
        matrices.m_85837_(x, y - 1.0, z);
        PoseStackUtil.rotY(matrices, (float)Math.PI + yaw);
        boolean hasPitch = pitch < 0.0f ? this.train.transportMode.hasPitchAscending : this.train.transportMode.hasPitchDescending;
        PoseStackUtil.rotX(matrices, hasPitch ? pitch : 0.0f);
        int light = LightTexture.m_109885_((int)world.m_45517_(LightLayer.BLOCK, posAverage), (int)world.m_45517_(LightLayer.SKY, posAverage));
        this.updateProp.update(this.train, carIndex, !this.train.isReversed());
        this.updateProp.miKeyframeTime = this.scheduleHelper.currentFrameTime;
        if (this.train.isReversed()) {
            PoseStackUtil.rotY(matrices, (float)Math.PI);
        }
        if (!isTail) {
            PoseStackUtil.rotY(matrices, (float)Math.PI);
        }
        this.updateProp.miHiddenParts = this.train.isCurrentlyManual() ? this.HIDE_LIST_MIDDLE : (carNum == this.train.trainCars - 1 ? this.HIDE_LIST_TAIL : (carNum == 0 ? this.HIDE_LIST_HEAD : this.HIDE_LIST_MIDDLE));
        if (!(this instanceof RenderTrainDK3Mini)) {
            matrices.m_252880_(0.0f, 0.0f, 1.0f);
            if (this.train.spacing == 20) {
                if (carIndex == 2) {
                    matrices.m_85837_(0.0, 0.0, -1.5);
                } else {
                    matrices.m_85837_(0.0, 0.0, -0.5);
                }
            }
        }
        Matrix4f pose = new Matrix4f(matrices.m_85850_().m_252922_());
        if (!isTail) {
            this.getModel(0).updateAndEnqueueAll(MainClient.drawScheduler, this.updateProp, pose, light);
            this.getModel(2).updateAndEnqueueAll(MainClient.drawScheduler, this.updateProp, pose, light);
        } else {
            this.getModel(1).updateAndEnqueueAll(MainClient.drawScheduler, this.updateProp, pose, light);
            this.getModel(3).updateAndEnqueueAll(MainClient.drawScheduler, this.updateProp, pose, light);
        }
        if (!(this instanceof RenderTrainDK3Mini)) {
            TrainProperties trainProperties = TrainClientRegistry.getTrainProperties((String)this.train.trainId);
            MODEL_BOGIE.render(matrices, vertexConsumers, light, (int)(trainProperties.bogiePosition * 16.0f));
            MODEL_BOGIE.render(matrices, vertexConsumers, light, -((int)(trainProperties.bogiePosition * 16.0f)));
        }
        this.scheduleHelper.elapse();
        matrices.m_85849_();
        matrices.m_85849_();
    }

    public void renderConnection(Vec3 prevPos1, Vec3 prevPos2, Vec3 prevPos3, Vec3 prevPos4, Vec3 thisPos1, Vec3 thisPos2, Vec3 thisPos3, Vec3 thisPos4, double x, double y, double z, float yaw, float pitch) {
    }

    public void renderBarrier(Vec3 prevPos1, Vec3 prevPos2, Vec3 prevPos3, Vec3 prevPos4, Vec3 thisPos1, Vec3 thisPos2, Vec3 thisPos3, Vec3 thisPos4, double x, double y, double z, float yaw, float pitch) {
    }
}

