/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.sowcer.object;

import cn.zbx1425.sowcer.batch.MaterialProp;
import cn.zbx1425.sowcer.model.Mesh;
import cn.zbx1425.sowcer.object.IndexBuf;
import cn.zbx1425.sowcer.object.InstanceBuf;
import cn.zbx1425.sowcer.util.GlStateTracker;
import cn.zbx1425.sowcer.vertex.VertAttrMapping;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.Closeable;
import org.lwjgl.opengl.GL33;

public class VertArray
implements Closeable {
    public int id = GL33.glGenVertexArrays();
    public MaterialProp materialProp;
    public IndexBuf indexBuf;
    public InstanceBuf instanceBuf;
    public VertAttrMapping mapping;
    private static VertArray dummyVao;

    public static VertArray getDummyVao() {
        if (dummyVao == null) {
            dummyVao = new VertArray();
        }
        return dummyVao;
    }

    public void create(Mesh mesh, VertAttrMapping mapping, InstanceBuf instanceBuf) {
        this.materialProp = mesh.materialProp;
        this.indexBuf = mesh.indexBuf;
        this.instanceBuf = instanceBuf;
        this.mapping = mapping;
        GL33.glBindVertexArray((int)this.id);
        mapping.setupAttrsToVao(mesh.vertBuf, instanceBuf);
        mesh.indexBuf.bind(34963);
        VertArray.unbind();
    }

    public void bind() {
        GlStateTracker.assertProtected();
        GL33.glBindVertexArray((int)this.id);
    }

    public static void unbind() {
        GlStateTracker.assertProtected();
        GL33.glBindVertexArray((int)0);
    }

    public void draw() {
        if (this.instanceBuf == null) {
            GL33.glDrawElements((int)4, (int)this.indexBuf.vertexCount, (int)this.indexBuf.indexType, (long)0L);
        } else {
            if (this.instanceBuf.size < 1) {
                return;
            }
            GL33.glDrawElementsInstanced((int)4, (int)this.indexBuf.vertexCount, (int)this.indexBuf.indexType, (long)0L, (int)this.instanceBuf.size);
        }
    }

    public int getFaceCount() {
        return this.indexBuf.faceCount * (this.instanceBuf == null ? 1 : this.instanceBuf.size);
    }

    @Override
    public void close() {
        if (RenderSystem.m_69586_()) {
            GL33.glDeleteVertexArrays((int)this.id);
            this.id = 0;
        } else {
            RenderSystem.m_69879_(this::close);
        }
    }
}

