/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.sowcer.shader;

import cn.zbx1425.mtrsteamloco.render.ShadersModHandler;
import cn.zbx1425.sowcer.batch.MaterialProp;
import cn.zbx1425.sowcer.batch.ShaderProp;
import cn.zbx1425.sowcer.math.Matrix4f;
import cn.zbx1425.sowcer.shader.PatchingResourceProvider;
import cn.zbx1425.sowcer.util.AttrUtil;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.shaders.ProgramManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;

public class ShaderManager {
    public static final VertexFormatElement MC_ELEMENT_MATRIX = new VertexFormatElement(0, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.GENERIC, 16);
    public static final VertexFormat MC_FORMAT_BLOCK_MAT = new VertexFormat(ImmutableMap.builder().put((Object)"Position", (Object)DefaultVertexFormat.f_85804_).put((Object)"Color", (Object)DefaultVertexFormat.f_85805_).put((Object)"UV0", (Object)DefaultVertexFormat.f_85806_).put((Object)"UV1", (Object)DefaultVertexFormat.f_85807_).put((Object)"UV2", (Object)DefaultVertexFormat.f_85808_).put((Object)"Normal", (Object)DefaultVertexFormat.f_85809_).put((Object)"ModelMat", (Object)MC_ELEMENT_MATRIX).put((Object)"Padding", (Object)DefaultVertexFormat.f_85810_).build());
    public final Map<String, ShaderInstance> shaders = new HashMap<String, ShaderInstance>();

    public boolean isReady() {
        return this.shaders.size() > 0;
    }

    public void reloadShaders(ResourceManager resourceManager) throws IOException {
        this.shaders.values().forEach(ShaderInstance::close);
        this.shaders.clear();
        PatchingResourceProvider provider = new PatchingResourceProvider((ResourceProvider)resourceManager);
        this.loadShader(provider, "rendertype_entity_cutout");
        this.loadShader(provider, "rendertype_entity_translucent_cull");
        this.loadShader(provider, "rendertype_beacon_beam");
    }

    private void loadShader(ResourceProvider resourceManager, String name) throws IOException {
        ShaderInstance shader = new ShaderInstance(resourceManager, name, MC_FORMAT_BLOCK_MAT);
        this.shaders.put(name, shader);
    }

    public void setupShaderBatchState(MaterialProp materialProp, ShaderProp shaderProp) {
        ShaderInstance shaderInstance;
        boolean useCustomShader;
        boolean bl = useCustomShader = shaderProp.viewMatrix != null;
        if (useCustomShader) {
            shaderInstance = this.shaders.get(materialProp.shaderName);
            materialProp.setupCompositeState();
        } else {
            RenderType renderType = materialProp.getBlazeRenderType();
            renderType.m_110185_();
            shaderInstance = RenderSystem.m_157196_();
        }
        for (int l = 0; l < 8; ++l) {
            int o = RenderSystem.m_157203_((int)l);
            shaderInstance.m_173350_("Sampler" + l, (Object)o);
        }
        if (shaderInstance.f_173308_ != null) {
            Matrix4f mvMatrix = new Matrix4f(RenderSystem.m_253073_()).copy();
            if (shaderProp.viewMatrix != null) {
                mvMatrix.multiply(shaderProp.viewMatrix);
            }
            if (materialProp.billboard) {
                AttrUtil.zeroRotation(mvMatrix);
            }
            shaderInstance.f_173308_.m_5679_(mvMatrix.asMoj());
        }
        if (shaderInstance.f_173309_ != null) {
            shaderInstance.f_173309_.m_5679_(RenderSystem.m_253262_());
        }
        if (shaderInstance.f_200956_ != null) {
            shaderInstance.f_200956_.m_200759_(RenderSystem.m_253191_());
        }
        if (shaderInstance.f_173312_ != null) {
            shaderInstance.f_173312_.m_5941_(RenderSystem.m_157197_());
        }
        if (shaderInstance.f_173315_ != null) {
            shaderInstance.f_173315_.m_5985_(RenderSystem.m_157200_());
        }
        if (shaderInstance.f_173316_ != null) {
            shaderInstance.f_173316_.m_5985_(RenderSystem.m_157199_());
        }
        if (shaderInstance.f_173317_ != null) {
            shaderInstance.f_173317_.m_5941_(RenderSystem.m_157198_());
        }
        if (shaderInstance.f_173310_ != null) {
            shaderInstance.f_173310_.m_5679_(RenderSystem.m_252744_());
        }
        if (shaderInstance.f_173319_ != null) {
            shaderInstance.f_173319_.m_5985_(RenderSystem.m_157201_());
        }
        if (shaderInstance.f_173311_ != null) {
            Window window = Minecraft.m_91087_().m_91268_();
            shaderInstance.f_173311_.m_7971_((float)window.m_85441_(), (float)window.m_85442_());
        }
        RenderSystem.m_157461_((ShaderInstance)shaderInstance);
        if (shaderInstance.f_173299_ != ShaderInstance.f_173327_) {
            ProgramManager.m_85578_((int)shaderInstance.f_173299_);
            ShaderInstance.f_173327_ = shaderInstance.f_173299_;
        }
        shaderInstance.m_173363_();
    }

    public void cleanupShaderBatchState(MaterialProp materialProp, ShaderProp shaderProp) {
        ShaderInstance shaderInstance;
        boolean useCustomShader;
        boolean bl = useCustomShader = shaderProp.viewMatrix != null;
        if (!useCustomShader && (shaderInstance = RenderSystem.m_157196_()) != null && shaderInstance.f_173308_ != null) {
            shaderInstance.f_173308_.m_5679_(RenderSystem.m_253073_());
            if (ShadersModHandler.isShaderPackInUse()) {
                shaderInstance.m_173363_();
            } else {
                shaderInstance.f_173308_.m_85633_();
            }
        }
    }
}

