/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.sowcerext.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;

public class Face {
    int[] vertices;

    public Face(int[] vertices) {
        this.vertices = vertices;
    }

    public Face(int begin, int end) {
        this.vertices = IntStream.range(begin, end + 1).toArray();
    }

    public Face(DataInputStream dis) throws IOException {
        this.vertices = new int[]{dis.readInt(), dis.readInt(), dis.readInt()};
    }

    public static List<Face> triangulate(int[] vertices, boolean isFace2) {
        int i;
        ArrayList<Face> result = new ArrayList<Face>();
        if (vertices.length > 3) {
            for (i = 2; i < vertices.length; ++i) {
                result.add(new Face(new int[]{vertices[0], vertices[i - 1], vertices[i]}));
            }
        } else {
            result.add(new Face(new int[]{vertices[0], vertices[1], vertices[2]}));
        }
        if (isFace2) {
            ArrayUtils.reverse((int[])vertices);
            if (vertices.length > 3) {
                for (i = 2; i < vertices.length; ++i) {
                    result.add(new Face(new int[]{vertices[0], vertices[i - 1], vertices[i]}));
                }
            } else {
                result.add(new Face(new int[]{vertices[0], vertices[1], vertices[2]}));
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Face csvFace = (Face)o;
        return Arrays.equals(this.vertices, csvFace.vertices);
    }

    public int hashCode() {
        return Arrays.hashCode(this.vertices);
    }

    public Face copy() {
        return new Face(Arrays.copyOf(this.vertices, this.vertices.length));
    }

    public void flip() {
        ArrayUtils.reverse((int[])this.vertices);
    }

    public void serializeTo(DataOutputStream dos) throws IOException {
        assert (this.vertices.length == 3);
        dos.writeInt(this.vertices[0]);
        dos.writeInt(this.vertices[1]);
        dos.writeInt(this.vertices[2]);
    }
}

