/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.sowcerext.model;

import cn.zbx1425.sowcer.batch.BatchManager;
import cn.zbx1425.sowcer.batch.EnqueueProp;
import cn.zbx1425.sowcer.batch.ShaderProp;
import cn.zbx1425.sowcer.math.Matrix4f;
import cn.zbx1425.sowcer.model.VertArrays;
import cn.zbx1425.sowcer.util.AttrUtil;
import cn.zbx1425.sowcer.util.Profiler;
import cn.zbx1425.sowcer.vertex.VertAttrMapping;
import cn.zbx1425.sowcer.vertex.VertAttrState;
import cn.zbx1425.sowcerext.model.RawMesh;
import cn.zbx1425.sowcerext.model.RawModel;
import java.io.Closeable;
import net.minecraft.client.renderer.MultiBufferSource;

public class ModelCluster
implements Closeable {
    public final VertArrays uploadedOpaqueParts;
    public final RawModel opaqueParts;
    public final RawModel translucentParts = new RawModel();

    public ModelCluster(RawModel source, VertAttrMapping mapping) {
        this.opaqueParts = new RawModel();
        for (RawMesh mesh : source.meshList.values()) {
            if (mesh.materialProp.translucent) {
                this.translucentParts.append(mesh);
                continue;
            }
            this.opaqueParts.append(mesh);
        }
        this.translucentParts.distinct();
        this.uploadedOpaqueParts = mapping == null ? null : VertArrays.createAll(this.opaqueParts.upload(mapping), mapping, null);
    }

    public void renderOpaqueOptimized(BatchManager batchManager, Matrix4f pose, int light, Profiler profiler) {
        int shaderLightmapUV = AttrUtil.exchangeLightmapUVBits(light);
        batchManager.enqueue(this.uploadedOpaqueParts, new EnqueueProp(new VertAttrState().setColor(255, 255, 255, 255).setOverlayUV(0).setLightmapUV(shaderLightmapUV).setModelMatrix(pose)), ShaderProp.DEFAULT);
    }

    public void renderOpaqueUnoptimized(MultiBufferSource vertexConsumers, Matrix4f pose, int light, Profiler profiler) {
        this.opaqueParts.writeBlazeBuffer(vertexConsumers, pose, light, profiler);
    }

    public void renderTranslucent(MultiBufferSource vertexConsumers, Matrix4f pose, int light, Profiler profiler) {
        this.translucentParts.writeBlazeBuffer(vertexConsumers, pose, light, profiler);
    }

    public boolean isUploaded() {
        return this.uploadedOpaqueParts != null;
    }

    @Override
    public void close() {
        this.uploadedOpaqueParts.close();
    }
}

