/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.sowcerext.model;

import cn.zbx1425.sowcer.batch.MaterialProp;
import cn.zbx1425.sowcer.math.Matrix4f;
import cn.zbx1425.sowcer.math.Vector3f;
import cn.zbx1425.sowcer.model.Mesh;
import cn.zbx1425.sowcer.object.IndexBuf;
import cn.zbx1425.sowcer.object.VertBuf;
import cn.zbx1425.sowcer.util.OffHeapAllocator;
import cn.zbx1425.sowcer.util.Profiler;
import cn.zbx1425.sowcer.vertex.VertAttrMapping;
import cn.zbx1425.sowcer.vertex.VertAttrSrc;
import cn.zbx1425.sowcer.vertex.VertAttrType;
import cn.zbx1425.sowcerext.model.Face;
import cn.zbx1425.sowcerext.model.Vertex;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.renderer.texture.OverlayTexture;

public class RawMesh {
    public MaterialProp materialProp;
    public List<Vertex> vertices = new ArrayList<Vertex>();
    public List<Face> faces = new ArrayList<Face>();

    public RawMesh(MaterialProp materialProp) {
        this.materialProp = materialProp;
    }

    public RawMesh(DataInputStream dis) throws IOException {
        this.materialProp = new MaterialProp(dis);
        int numVertices = dis.readInt();
        this.vertices = new ArrayList<Vertex>(numVertices);
        for (int i = 0; i < numVertices; ++i) {
            this.vertices.add(new Vertex(dis));
        }
        int numFaces = dis.readInt();
        this.faces = new ArrayList<Face>(numFaces);
        for (int i = 0; i < numFaces; ++i) {
            this.faces.add(new Face(dis));
        }
    }

    public void append(RawMesh nextMesh) {
        if (nextMesh == this) {
            throw new IllegalStateException("Mesh self-appending");
        }
        int vertOffset = this.vertices.size();
        this.vertices.addAll(nextMesh.vertices);
        for (Face face : nextMesh.faces) {
            Face newFace = face.copy();
            int i = 0;
            while (i < newFace.vertices.length) {
                int n = i++;
                newFace.vertices[n] = newFace.vertices[n] + vertOffset;
            }
            this.faces.add(newFace);
        }
    }

    public void appendTransformed(RawMesh nextMesh, Matrix4f mat, int color, int light) {
        if (nextMesh == this) {
            throw new IllegalStateException("Mesh self-appending");
        }
        int vertOffset = this.vertices.size();
        for (Vertex vertex : nextMesh.vertices) {
            Vertex newVertex = new Vertex(mat.transform(vertex.position), mat.transform3(vertex.normal));
            newVertex.u = vertex.u;
            newVertex.v = vertex.v;
            newVertex.color = color;
            newVertex.light = light;
            this.vertices.add(newVertex);
        }
        for (Face face : nextMesh.faces) {
            Face newFace = face.copy();
            int i = 0;
            while (i < newFace.vertices.length) {
                int n = i++;
                newFace.vertices[n] = newFace.vertices[n] + vertOffset;
            }
            this.faces.add(newFace);
        }
    }

    public boolean checkVertIndex() {
        for (Face face : this.faces) {
            for (int vertIndex : face.vertices) {
                if (vertIndex >= 0 && vertIndex < this.vertices.size()) continue;
                return false;
            }
        }
        return true;
    }

    public void distinct() {
        ArrayList<Vertex> distinctVertices = new ArrayList<Vertex>(this.vertices.size());
        HashMap<Vertex, Integer> verticesLookup = new HashMap<Vertex, Integer>(this.vertices.size());
        HashSet<Face> distinctFaces = new HashSet<Face>(this.faces.size());
        for (Face face : this.faces) {
            for (int i = 0; i < face.vertices.length; ++i) {
                int newIndex;
                Vertex vertex = this.vertices.get(face.vertices[i]);
                if (verticesLookup.containsKey(vertex)) {
                    newIndex = (Integer)verticesLookup.get(vertex);
                } else {
                    distinctVertices.add(vertex);
                    newIndex = distinctVertices.size() - 1;
                    verticesLookup.put(vertex, newIndex);
                }
                face.vertices[i] = newIndex;
            }
            distinctFaces.add(face);
        }
        this.vertices.clear();
        this.vertices.addAll(distinctVertices);
        this.faces.clear();
        this.faces.addAll(distinctFaces);
    }

    public void generateNormals() {
        ArrayList<Vertex> newVertices = new ArrayList<Vertex>(this.vertices.size());
        for (Face face : this.faces) {
            double nz;
            double ny;
            if (face.vertices.length < 3) continue;
            int i0 = face.vertices[0];
            int i1 = face.vertices[1];
            int i2 = face.vertices[2];
            double ax = this.vertices.get((int)i1).position.x() - this.vertices.get((int)i0).position.x();
            double ay = this.vertices.get((int)i1).position.y() - this.vertices.get((int)i0).position.y();
            double az = this.vertices.get((int)i1).position.z() - this.vertices.get((int)i0).position.z();
            double bx = this.vertices.get((int)i2).position.x() - this.vertices.get((int)i0).position.x();
            double by = this.vertices.get((int)i2).position.y() - this.vertices.get((int)i0).position.y();
            double bz = this.vertices.get((int)i2).position.z() - this.vertices.get((int)i0).position.z();
            double nx = ay * bz - az * by;
            double t = nx * nx + (ny = az * bx - ax * bz) * ny + (nz = ax * by - ay * bx) * nz;
            if (t != 0.0) {
                t = 1.0 / Math.sqrt(t);
                float mx = (float)(nx * t);
                float my = (float)(ny * t);
                float mz = (float)(nz * t);
                for (int j = 0; j < face.vertices.length; ++j) {
                    Vertex newVert = this.vertices.get(face.vertices[j]).copy();
                    if (RawMesh.vecIsZero(newVert.normal)) {
                        newVert.normal = new Vector3f(mx, my, mz);
                    }
                    newVertices.add(newVert);
                    face.vertices[j] = newVertices.size() - 1;
                }
                continue;
            }
            for (int j = 0; j < face.vertices.length; ++j) {
                Vertex newVert = this.vertices.get(face.vertices[j]).copy();
                if (RawMesh.vecIsZero(this.vertices.get((int)face.vertices[j]).normal)) {
                    newVert.normal = new Vector3f(0.0f, 1.0f, 0.0f);
                }
                newVertices.add(newVert);
                face.vertices[j] = newVertices.size() - 1;
            }
        }
        this.vertices = newVertices;
    }

    public Mesh upload(VertAttrMapping mapping) {
        this.distinct();
        ByteBuffer vertBuf = OffHeapAllocator.allocate(this.vertices.size() * mapping.strideVertex);
        for (int i = 0; i < this.vertices.size(); ++i) {
            if (RawMesh.shouldWriteVertBuf(mapping, VertAttrType.POSITION)) {
                Vector3f pos = this.vertices.get((int)i).position;
                vertBuf.putFloat(pos.x()).putFloat(pos.y()).putFloat(pos.z());
            }
            if (RawMesh.shouldWriteVertBuf(mapping, VertAttrType.COLOR)) {
                vertBuf.putInt(this.vertices.get((int)i).color);
            }
            if (RawMesh.shouldWriteVertBuf(mapping, VertAttrType.UV_TEXTURE)) {
                float u = this.vertices.get((int)i).u;
                float v = this.vertices.get((int)i).v;
                vertBuf.putFloat(u).putFloat(v);
            }
            if (RawMesh.shouldWriteVertBuf(mapping, VertAttrType.UV_LIGHTMAP)) {
                vertBuf.putInt(this.vertices.get((int)i).light);
            }
            if (RawMesh.shouldWriteVertBuf(mapping, VertAttrType.NORMAL)) {
                Vector3f mojNormal = this.vertices.get((int)i).normal.copy();
                mojNormal.normalize();
                vertBuf.put((byte)(mojNormal.x() * 127.0f)).put((byte)(mojNormal.y() * 127.0f)).put((byte)(mojNormal.z() * 127.0f));
            }
            if (mapping.paddingVertex <= 0) continue;
            vertBuf.put((byte)0);
        }
        VertBuf vertBufObj = new VertBuf();
        vertBufObj.upload(vertBuf, 35044);
        OffHeapAllocator.free(vertBuf);
        ByteBuffer indexBuf = OffHeapAllocator.allocate(this.faces.size() * 3 * 4);
        for (Face face : this.faces) {
            for (int j = 0; j < face.vertices.length; ++j) {
                indexBuf.putInt(face.vertices[j]);
            }
        }
        IndexBuf indexBufObj = new IndexBuf(this.faces.size(), 5125);
        indexBufObj.upload(indexBuf, 35044);
        OffHeapAllocator.free(indexBuf);
        return new Mesh(vertBufObj, indexBufObj, this.materialProp);
    }

    private static boolean shouldWriteVertBuf(VertAttrMapping mapping, VertAttrType type) {
        return mapping.sources.get((Object)type) == VertAttrSrc.VERTEX_BUF;
    }

    private static int getVertBufPos(VertAttrMapping mapping, int vertId, VertAttrType type) {
        return mapping.strideVertex * vertId + mapping.pointers.get((Object)type);
    }

    private static boolean vecIsZero(Vector3f vec) {
        return vec.x() == 0.0f && vec.y() == 0.0f && vec.z() == 0.0f;
    }

    public void applyMatrix(Matrix4f matrix) {
        for (Vertex vertex : this.vertices) {
            vertex.position = matrix.transform(vertex.position);
            vertex.normal = matrix.transform3(vertex.normal);
        }
    }

    public void applyTranslation(float x, float y, float z) {
        for (Vertex vertex : this.vertices) {
            vertex.position.add(x, y, z);
        }
    }

    public void applyRotation(Vector3f axis, float angle) {
        for (Vertex vertex : this.vertices) {
            vertex.position.rotDeg(axis, angle);
            vertex.normal.rotDeg(axis, angle);
        }
    }

    public void applyScale(float x, float y, float z) {
        float rx = (float)(1.0 / (double)x);
        float ry = (float)(1.0 / (double)y);
        float rz = (float)(1.0 / (double)z);
        float rx2 = rx * rx;
        float ry2 = ry * ry;
        float rz2 = rz * rz;
        boolean reverse = (double)(x * y * z) < 0.0;
        for (Vertex vertex : this.vertices) {
            float nz2;
            float ny2;
            vertex.position.mul(x, y, z);
            float nx2 = vertex.normal.x() * vertex.normal.x();
            float u = nx2 * rx2 + (ny2 = vertex.normal.y() * vertex.normal.y()) * ry2 + (nz2 = vertex.normal.z() * vertex.normal.z()) * rz2;
            if ((double)u == 0.0) continue;
            u = (float)Math.sqrt((nx2 + ny2 + nz2) / u);
            vertex.normal.mul(rx * u, ry * u, rz * u);
        }
        if (reverse) {
            for (Face face : this.faces) {
                face.flip();
            }
        }
    }

    public void applyMirror(boolean vx, boolean vy, boolean vz, boolean nx, boolean ny, boolean nz) {
        for (Vertex vertex : this.vertices) {
            vertex.position.mul(vx ? -1.0f : 1.0f, vy ? -1.0f : 1.0f, vz ? -1.0f : 1.0f);
            vertex.normal.mul(nx ? -1.0f : 1.0f, ny ? -1.0f : 1.0f, nz ? -1.0f : 1.0f);
        }
        int numFlips = 0;
        if (vx) {
            ++numFlips;
        }
        if (vy) {
            ++numFlips;
        }
        if (vz) {
            ++numFlips;
        }
        if (numFlips % 2 != 0) {
            for (Face face : this.faces) {
                face.flip();
            }
        }
    }

    public void applyUVMirror(boolean u, boolean v) {
        for (Vertex vertex : this.vertices) {
            if (u) {
                vertex.u = 1.0f - vertex.u;
            }
            if (!v) continue;
            vertex.v = 1.0f - vertex.v;
        }
    }

    public void applyShear(Vector3f dir, Vector3f shear, float ratio) {
        for (Vertex vertex : this.vertices) {
            float n1 = ratio * (dir.x() * vertex.position.x() + dir.y() * vertex.position.y() + dir.z() * vertex.position.z());
            Vector3f offset1 = shear.copy();
            offset1.mul(n1);
            vertex.position.add(offset1);
            if (RawMesh.vecIsZero(vertex.normal)) continue;
            float n2 = ratio * (shear.x() * vertex.normal.x() + shear.y() * vertex.normal.y() + shear.z() * vertex.normal.z());
            Vector3f offset2 = dir.copy();
            offset2.mul(-n2);
            vertex.normal.add(offset2);
            vertex.normal.normalize();
        }
    }

    public void setRenderType(String type) {
        this.materialProp.translucent = false;
        this.materialProp.writeDepthBuf = true;
        this.materialProp.cutoutHack = false;
        this.materialProp.attrState = this.materialProp.attrState.copy();
        this.materialProp.attrState.lightmapUV = null;
        switch (type) {
            case "exterior": {
                this.materialProp.shaderName = "rendertype_entity_cutout";
                break;
            }
            case "exteriortranslucent": {
                this.materialProp.shaderName = "rendertype_entity_translucent_cull";
                this.materialProp.translucent = true;
                break;
            }
            case "interior": {
                this.materialProp.shaderName = "rendertype_entity_cutout";
                this.materialProp.attrState.setLightmapUV(0xF000F0);
                break;
            }
            case "interiortranslucent": {
                this.materialProp.shaderName = "rendertype_entity_translucent_cull";
                this.materialProp.translucent = true;
                this.materialProp.attrState.setLightmapUV(0xF000F0);
                break;
            }
            case "light": {
                this.materialProp.shaderName = "rendertype_beacon_beam";
                this.materialProp.cutoutHack = true;
                break;
            }
            case "lighttranslucent": {
                this.materialProp.shaderName = "rendertype_beacon_beam";
                this.materialProp.translucent = true;
                this.materialProp.writeDepthBuf = false;
            }
        }
    }

    public void writeBlazeBuffer(VertexConsumer vertexConsumer, Matrix4f matrix, int color, int light, Profiler profiler) {
        if (profiler != null) {
            profiler.recordBlazeAction(this.faces.size());
        }
        for (Face face : this.faces) {
            assert (face.vertices.length == 3);
            for (int vertIndex : face.vertices) {
                Vertex vertex = this.vertices.get(vertIndex);
                vertexConsumer.m_252986_(matrix.asMoj(), vertex.position.x(), vertex.position.y(), vertex.position.z()).m_6122_((int)((byte)(color >>> 24)), (int)((byte)(color >>> 16)), (int)((byte)(color >>> 8)), (int)((byte)color)).m_7421_(vertex.u, vertex.v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix.getRotationPart(), vertex.normal.x(), vertex.normal.y(), vertex.normal.z()).m_5752_();
            }
        }
    }

    public RawMesh copy() {
        RawMesh result = new RawMesh(this.materialProp);
        for (Vertex vertex : this.vertices) {
            result.vertices.add(vertex.copy());
        }
        for (Face face : this.faces) {
            result.faces.add(face.copy());
        }
        return result;
    }

    public void serializeTo(DataOutputStream dos) throws IOException {
        this.materialProp.serializeTo(dos);
        dos.writeInt(this.vertices.size());
        for (Vertex vertex : this.vertices) {
            vertex.serializeTo(dos);
        }
        dos.writeInt(this.faces.size());
        for (Face face : this.faces) {
            face.serializeTo(dos);
        }
    }
}

