/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.sowcerext.model;

import cn.zbx1425.sowcer.batch.MaterialProp;
import cn.zbx1425.sowcer.math.Matrix4f;
import cn.zbx1425.sowcer.math.Vector3f;
import cn.zbx1425.sowcer.model.Model;
import cn.zbx1425.sowcer.util.AttrUtil;
import cn.zbx1425.sowcer.util.Profiler;
import cn.zbx1425.sowcer.vertex.VertAttrMapping;
import cn.zbx1425.sowcer.vertex.VertAttrState;
import cn.zbx1425.sowcerext.model.RawMesh;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class RawModel {
    public ResourceLocation sourceLocation;
    public HashMap<MaterialProp, RawMesh> meshList = new HashMap();
    private Map<RawMesh, MaterialProp> originalMaterialProps;

    public RawModel() {
    }

    public RawModel(DataInputStream dis) throws IOException {
        int count = dis.readInt();
        for (int i = 0; i < count; ++i) {
            RawMesh mesh = new RawMesh(dis);
            this.append(mesh);
        }
    }

    public Model upload(VertAttrMapping mapping) {
        Model model = new Model();
        for (RawMesh mesh : this.meshList.values()) {
            if (mesh.faces.size() == 0) continue;
            if (!mesh.checkVertIndex()) {
                throw new IndexOutOfBoundsException("RawModel contains invalid vertex index");
            }
            model.meshList.add(mesh.upload(mapping));
        }
        return model;
    }

    public void append(RawMesh nextMesh) {
        if (this.meshList.containsKey(nextMesh.materialProp)) {
            RawMesh mesh = this.meshList.get(nextMesh.materialProp);
            mesh.append(nextMesh);
        } else {
            RawMesh newMesh = new RawMesh(nextMesh.materialProp);
            this.meshList.put(nextMesh.materialProp, newMesh);
            newMesh.append(nextMesh);
        }
    }

    public void appendTransformed(RawModel nextModel, Matrix4f mat, int color, int light) {
        for (RawMesh nextMesh : nextModel.meshList.values()) {
            if (this.meshList.containsKey(nextMesh.materialProp)) {
                RawMesh mesh = this.meshList.get(nextMesh.materialProp);
                mesh.appendTransformed(nextMesh, mat, color, light);
                continue;
            }
            RawMesh newMesh = new RawMesh(nextMesh.materialProp);
            this.meshList.put(nextMesh.materialProp, newMesh);
            newMesh.appendTransformed(nextMesh, mat, color, light);
        }
    }

    public int getVertexCount() {
        int result = 0;
        for (RawMesh mesh : this.meshList.values()) {
            result += mesh.vertices.size();
        }
        return result;
    }

    public void append(Collection<RawMesh> nextMesh) {
        for (RawMesh mesh : nextMesh) {
            this.append(mesh);
        }
    }

    public void append(RawModel nextModel) {
        this.append(nextModel.meshList.values());
    }

    public void applyMatrix(Matrix4f matrix) {
        for (RawMesh mesh : this.meshList.values()) {
            mesh.applyMatrix(matrix);
        }
    }

    public void applyTranslation(float x, float y, float z) {
        for (RawMesh mesh : this.meshList.values()) {
            mesh.applyTranslation(x, y, z);
        }
    }

    public void applyRotation(Vector3f axis, float angle) {
        for (RawMesh mesh : this.meshList.values()) {
            mesh.applyRotation(axis, angle);
        }
    }

    public void applyScale(float x, float y, float z) {
        for (RawMesh mesh : this.meshList.values()) {
            mesh.applyScale(x, y, z);
        }
    }

    public void applyMirror(boolean vx, boolean vy, boolean vz, boolean nx, boolean ny, boolean nz) {
        for (RawMesh mesh : this.meshList.values()) {
            mesh.applyMirror(vx, vy, vz, nx, ny, nz);
        }
    }

    public void generateNormals() {
        for (RawMesh mesh : this.meshList.values()) {
            mesh.generateNormals();
        }
    }

    public void distinct() {
        for (RawMesh mesh : this.meshList.values()) {
            mesh.distinct();
        }
    }

    public void applyShear(Vector3f dir, Vector3f shear, float ratio) {
        for (RawMesh mesh : this.meshList.values()) {
            mesh.applyShear(dir, shear, ratio);
        }
    }

    public void setAllRenderType(String renderType) {
        if (this.originalMaterialProps == null) {
            this.originalMaterialProps = new HashMap<RawMesh, MaterialProp>();
            for (Map.Entry<MaterialProp, RawMesh> entry : this.meshList.entrySet()) {
                this.originalMaterialProps.put(entry.getValue(), entry.getKey().copy());
            }
        }
        for (Map.Entry<MaterialProp, RawMesh> entry : this.meshList.entrySet()) {
            if (renderType.equals("reset")) {
                MaterialProp originalProp = this.originalMaterialProps.get(entry.getValue());
                if (originalProp != null) {
                    entry.getValue().materialProp.copyFrom(originalProp);
                    entry.getKey().copyFrom(originalProp);
                } else {
                    entry.getValue().setRenderType(renderType);
                }
            } else {
                entry.getValue().setRenderType(renderType);
            }
            entry.getKey().shaderName = entry.getValue().materialProp.shaderName;
        }
    }

    public void replaceAllTexture(String oldTexture, ResourceLocation newTexture) {
        for (Map.Entry<MaterialProp, RawMesh> entry : this.meshList.entrySet()) {
            String oldPath;
            if (entry.getKey().texture == null || !(oldPath = entry.getKey().texture.m_135815_()).substring(oldPath.lastIndexOf("/") + 1).equals(oldTexture)) continue;
            entry.getValue().materialProp.texture = newTexture;
            entry.getKey().texture = newTexture;
        }
    }

    public void replaceAllTexture(ResourceLocation newTexture) {
        for (Map.Entry<MaterialProp, RawMesh> entry : this.meshList.entrySet()) {
            entry.getValue().materialProp.texture = newTexture;
            entry.getKey().texture = newTexture;
        }
    }

    public void clearAttrStates() {
        for (Map.Entry<MaterialProp, RawMesh> entry : this.meshList.entrySet()) {
            entry.getValue().materialProp.attrState = entry.getKey().attrState = new VertAttrState();
        }
    }

    public void writeBlazeBuffer(MultiBufferSource vertexConsumers, Matrix4f matrix, int light, Profiler profiler) {
        if (this.meshList.isEmpty()) {
            return;
        }
        for (Map.Entry<MaterialProp, RawMesh> entry : this.meshList.entrySet()) {
            RenderType renderType = entry.getKey().getBlazeRenderType();
            int resultColor = entry.getKey().attrState.color != null ? entry.getKey().attrState.color : -1;
            int resultLight = entry.getKey().attrState.lightmapUV != null ? entry.getKey().attrState.lightmapUV : light;
            Matrix4f resultMatrix = matrix;
            if (entry.getKey().billboard) {
                resultMatrix = matrix.copy();
                AttrUtil.zeroRotation(resultMatrix);
            }
            entry.getValue().writeBlazeBuffer(vertexConsumers.m_6299_(renderType), resultMatrix, resultColor, resultLight, profiler);
        }
    }

    public RawModel copy() {
        RawModel result = new RawModel();
        result.sourceLocation = this.sourceLocation;
        for (RawMesh mesh : this.meshList.values()) {
            result.meshList.put(mesh.materialProp, mesh.copy());
        }
        return result;
    }

    public void serializeTo(DataOutputStream dos) throws IOException {
        dos.writeInt(this.meshList.size());
        for (RawMesh mesh : this.meshList.values()) {
            mesh.serializeTo(dos);
        }
    }
}

